/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.oid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.oid.AutoIncrementIdGenerator;
import org.apache.torque.oid.IdGenerator;
import org.apache.torque.oid.SequenceIdGenerator;

public final class IDGeneratorFactory {
    public static final List<IDMethod> ID_GENERATOR_METHODS;

    private IDGeneratorFactory() {
    }

    public static IdGenerator create(Adapter adapter, String name) {
        IDMethod idMethod = adapter.getIDMethodType();
        if (IDMethod.AUTO_INCREMENT == idMethod) {
            return new AutoIncrementIdGenerator(adapter, name);
        }
        if (IDMethod.SEQUENCE == idMethod) {
            return new SequenceIdGenerator(adapter, name);
        }
        return null;
    }

    static {
        ArrayList<IDMethod> idGeneratorMethods = new ArrayList<IDMethod>();
        idGeneratorMethods.add(IDMethod.NATIVE);
        idGeneratorMethods.add(IDMethod.AUTO_INCREMENT);
        idGeneratorMethods.add(IDMethod.SEQUENCE);
        ID_GENERATOR_METHODS = Collections.unmodifiableList(idGeneratorMethods);
    }
}

