/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.AnsiSignatures;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AnsiSignaturesTest
extends BaseJDBCTestCase {
    public static final String MISSING_METHOD_SQLSTATE = "XJ001";
    public static final String TRIED_ALL_COMBINATIONS = "42X50";
    public static final String AMBIGUOUS = "42X73";

    public AnsiSignaturesTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.defaultSuite(AnsiSignaturesTest.class);
        return new CleanDatabaseTestSetup((Test)suite);
    }

    public void test_boolean_boolean_boolean() throws Exception {
        this.declareAndRunFunction("boolean_boolean_boolean", "boolean", new String[]{"boolean"}, "true", "true");
    }

    public void test_boolean_Boolean_boolean() throws Exception {
        this.declareAndRunFunction("boolean_Boolean_boolean", "boolean", new String[]{"boolean"}, "true", "true");
    }

    public void test_boolean_boolean_Boolean() throws Exception {
        this.declareAndRunFunction("boolean_boolean_Boolean", "boolean", new String[]{"boolean"}, "true", "true");
    }

    public void test_boolean_Boolean_Boolean() throws Exception {
        this.declareAndRunFunction("boolean_Boolean_Boolean", "boolean", new String[]{"boolean"}, "true", "true");
    }

    public void test_smallint_short_short() throws Exception {
        this.declareAndRunFunction("smallint_short_short", "smallint", new String[]{"smallint"}, "3", "3");
    }

    public void test_smallint_short_Integer() throws Exception {
        this.declareAndRunFunction("smallint_short_Integer", "smallint", new String[]{"smallint"}, "3", "3");
    }

    public void test_smallint_Integer_short() throws Exception {
        this.declareAndRunFunction("smallint_Integer_short", "smallint", new String[]{"smallint"}, "3", "3");
    }

    public void test_smallint_Integer_Integer() throws Exception {
        this.declareAndRunFunction("smallint_Integer_Integer", "smallint", new String[]{"smallint"}, "3", "3");
    }

    public void test_integer_int_int() throws Exception {
        this.declareAndRunFunction("integer_int_int", "int", new String[]{"int"}, "3", "3");
    }

    public void test_integer_int_Integer() throws Exception {
        this.declareAndRunFunction("integer_int_Integer", "int", new String[]{"int"}, "3", "3");
    }

    public void test_integer_Integer_int() throws Exception {
        this.declareAndRunFunction("integer_Integer_int", "int", new String[]{"int"}, "3", "3");
    }

    public void test_integer_Integer_Integer() throws Exception {
        this.declareAndRunFunction("integer_Integer_Integer", "int", new String[]{"int"}, "3", "3");
    }

    public void test_bigint_long_long() throws Exception {
        this.declareAndRunFunction("bigint_long_long", "bigint", new String[]{"bigint"}, "3", "3");
    }

    public void test_bigint_long_Long() throws Exception {
        this.declareAndRunFunction("bigint_long_Long", "bigint", new String[]{"bigint"}, "3", "3");
    }

    public void test_bigint_Long_long() throws Exception {
        this.declareAndRunFunction("bigint_Long_long", "bigint", new String[]{"bigint"}, "3", "3");
    }

    public void test_bigint_Long_Long() throws Exception {
        this.declareAndRunFunction("bigint_Long_Long", "bigint", new String[]{"bigint"}, "3", "3");
    }

    public void test_real_float_float() throws Exception {
        this.declareAndRunFunction("real_float_float", "real", new String[]{"real"}, "3.0", "3.0");
    }

    public void test_real_float_Float() throws Exception {
        this.declareAndRunFunction("real_float_Float", "real", new String[]{"real"}, "3.0", "3.0");
    }

    public void test_real_Float_float() throws Exception {
        this.declareAndRunFunction("real_Float_float", "real", new String[]{"real"}, "3.0", "3.0");
    }

    public void test_real_Float_Float() throws Exception {
        this.declareAndRunFunction("real_Float_Float", "real", new String[]{"real"}, "3.0", "3.0");
    }

    public void test_double_double_double() throws Exception {
        this.declareAndRunFunction("double_double_double", "double", new String[]{"double"}, "3.0", "3.0");
    }

    public void test_double_double_Double() throws Exception {
        this.declareAndRunFunction("double_double_Double", "double", new String[]{"double"}, "3.0", "3.0");
    }

    public void test_double_Double_double() throws Exception {
        this.declareAndRunFunction("double_Double_double", "double", new String[]{"double"}, "3.0", "3.0");
    }

    public void test_double_Double_Double() throws Exception {
        this.declareAndRunFunction("double_Double_Double", "double", new String[]{"double"}, "3.0", "3.0");
    }

    public void test_numeric_BigDecimal_BigDecimal() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.declareAndRunFunction("numeric_BigDecimal_BigDecimal", "numeric( 7, 2 )", new String[]{"numeric( 7, 2 )"}, "12345.67", "12345.67");
    }

    public void test_decimal_BigDecimal_BigDecimal() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.declareAndRunFunction("decimal_BigDecimal_BigDecimal", "decimal( 7, 2 )", new String[]{"decimal( 7, 2 )"}, "12345.67", "12345.67");
    }

    public void test_varchar_String_String() throws Exception {
        this.declareAndRunFunction("varchar_String_String", "varchar( 10 )", new String[]{"varchar( 10 )"}, "'3.0'", "3.0");
    }

    public void test_char_String_String() throws Exception {
        this.declareAndRunFunction("char_String_String", "char( 10 )", new String[]{"char( 10 )"}, "'3.0'", "3.0       ");
    }

    public void test_longvarchar_String_String() throws Exception {
        this.declareAndRunFunction("longvarchar_String_String", "long varchar", new String[]{"varchar( 10 )"}, "'3.0'", "3.0");
    }

    public void test_bigint__smallint_int_bigint_real_double() throws Exception {
        this.declareAndRunFunction("bigint__smallint_int_bigint_real_double", "bigint", new String[]{"smallint", "int", "bigint", "real", "double"}, "3, 3, 3, 3.0, 3.0", "3");
    }

    public void test_flipped_bigint__smallint_int_bigint_real_double() throws Exception {
        this.declareAndRunFunction("flipped_bigint__smallint_int_bigint_real_double", "bigint", new String[]{"smallint", "int", "bigint", "real", "double"}, "3, 3, 3, 3.0, 3.0", "3");
    }

    public void test_binary_bytes_bytes() throws Exception {
        this.declareAndRunFunction("binary_bytes_bytes", "char( 2 ) for bit data", new String[]{"char( 2 ) for bit data"}, "X'a1b2'", "a1b2");
    }

    public void test_binary_bytes_int() throws Exception {
        this.declareAndRunFunction("binary_bytes_int", "char( 1 ) for bit data", new String[]{"integer"}, "3", "03");
    }

    public void test_varbinary_bytes_bytes() throws Exception {
        this.declareAndRunFunction("varbinary_bytes_bytes", "varchar( 2 ) for bit data", new String[]{"varchar( 2 ) for bit data"}, "X'a1b2'", "a1b2");
    }

    public void test_varbinary_bytes_int() throws Exception {
        this.declareAndRunFunction("varbinary_bytes_int", "char( 1 ) for bit data", new String[]{"integer"}, "3", "03");
    }

    public void test_longvarbinary_bytes_bytes() throws Exception {
        this.declareAndRunFunction("longvarbinary_bytes_bytes", "long varchar for bit data", new String[]{"varchar(2) for bit data"}, "X'a1b2'", "a1b2");
    }

    public void test_longvarbinary_bytes_int() throws Exception {
        this.declareAndRunFunction("longvarbinary_bytes_int", "long varchar for bit data", new String[]{"integer"}, "3", "03");
    }

    public void test_date_Date_Date() throws Exception {
        this.declareAndRunFunction("date_Date_Date", "date", new String[]{"date"}, "date('1994-02-23')", "1994-02-23");
    }

    public void test_time_Time_Time() throws Exception {
        this.declareAndRunFunction("time_Time_Time", "time", new String[]{"time"}, "time('15:09:02')", "15:09:02");
    }

    public void test_timestamp_Timestamp_Timestamp() throws Exception {
        this.declareAndRunFunction("timestamp_Timestamp_Timestamp", "timestamp", new String[]{"timestamp"}, "timestamp('1962-09-23 03:23:34.234')", "1962-09-23 03:23:34.234");
    }

    public void test_clob_Clob_String() throws Exception {
        Connection conn = this.getConnection();
        this.declareAndRunFunction("clob_Clob_String", "clob", new String[]{"varchar( 10 )"}, "'3'", "3");
        this.declareFunction(conn, "varchar_Clob_Clob", "varchar( 10 )", new String[]{"clob"});
        this.runFunction(conn, "varchar_Clob_Clob", " \"clob_Clob_String\"( 'abc' )", "abc", null);
        PreparedStatement ps = this.chattyPrepare(conn, "values ( \"varchar_Clob_Clob\"( ? ) )");
        String expectedValue = "abcdef";
        Clob clob = AnsiSignatures.clob_Clob_String(expectedValue);
        ps.setClob(1, clob);
        String actualValue = this.getScalarString(ps);
        AnsiSignaturesTest.assertTrue((boolean)expectedValue.equals(actualValue));
    }

    public void test_blob_Blob_String() throws Exception {
        Connection conn = this.getConnection();
        this.declareAndRunFunction("blob_Blob_String", "blob", new String[]{"varchar( 10 )"}, "'3'", "33");
        this.declareFunction(conn, "varchar_Blob_Blob", "varchar( 10 )", new String[]{"blob"});
        this.runFunction(conn, "varchar_Blob_Blob", " \"blob_Blob_String\"( 'abc' )", "abc", null);
        PreparedStatement ps = this.chattyPrepare(conn, "values ( \"varchar_Blob_Blob\"( ? ) )");
        String expectedValue = "34";
        Blob blob = AnsiSignatures.blob_Blob_String(expectedValue);
        ps.setBlob(1, blob);
        String actualValue = this.getScalarString(ps);
        AnsiSignaturesTest.assertTrue((boolean)expectedValue.equals(actualValue));
    }

    public void test_smallint_bad_short_Short() throws Exception {
        this.declareAndFailFunction("smallint_bad_short_Short", "smallint", new String[]{"smallint"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_smallint_bad_Short_short() throws Exception {
        this.declareAndFailFunction("smallint_bad_Short_short", "smallint", new String[]{"smallint"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_smallint_bad_Short_Short() throws Exception {
        this.declareAndFailFunction("smallint_bad_Short_Short", "smallint", new String[]{"smallint"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_boolean_badreturn_byte_int() throws Exception {
        this.declareAndFailFunction("boolean_badreturn_byte_int", "boolean", new String[]{"int"}, "3", "true", TRIED_ALL_COMBINATIONS);
    }

    public void test_smallint_badreturn_byte_short() throws Exception {
        this.declareAndFailFunction("smallint_badreturn_byte_short", "smallint", new String[]{"smallint"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_integer_badreturn_byte_int() throws Exception {
        this.declareAndFailFunction("integer_badreturn_byte_int", "int", new String[]{"int"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_bigint_badreturn_byte_long() throws Exception {
        this.declareAndFailFunction("bigint_badreturn_byte_long", "bigint", new String[]{"bigint"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_real_badreturn_byte_float() throws Exception {
        this.declareAndFailFunction("real_badreturn_byte_float", "real", new String[]{"real"}, "3.0", "3.0", TRIED_ALL_COMBINATIONS);
    }

    public void test_double_badreturn_byte_double() throws Exception {
        this.declareAndFailFunction("double_badreturn_byte_double", "double", new String[]{"double"}, "3.0", "3.0", TRIED_ALL_COMBINATIONS);
    }

    public void test_binary_badreturn_bytes_bytes() throws Exception {
        this.declareAndFailFunction("binary_badreturn_bytes_bytes", "char( 2 ) for bit data", new String[]{"char( 2 ) for bit data"}, "X'a1b2'", "a1b2", TRIED_ALL_COMBINATIONS);
    }

    public void test_varbinary_badreturn_bytes_bytes() throws Exception {
        this.declareAndFailFunction("varbinary_badreturn_bytes_bytes", "varchar( 2 ) for bit data", new String[]{"varchar( 2 ) for bit data"}, "X'a1b2'", "a1b2", TRIED_ALL_COMBINATIONS);
    }

    public void test_longvarbinary_badreturn_bytes_bytes() throws Exception {
        this.declareAndFailFunction("longvarbinary_badreturn_bytes_bytes", "long varchar for bit data", new String[]{"char( 2 ) for bit data"}, "X'a1b2'", "a1b2", TRIED_ALL_COMBINATIONS);
    }

    public void test_boolean_amb_boolean_boolean() throws Exception {
        this.declareAndFailFunction("boolean_amb_boolean_boolean", "boolean", new String[]{"boolean"}, "true", "true", AMBIGUOUS);
    }

    public void test_boolean_amb_Boolean_boolean() throws Exception {
        this.declareAndFailFunction("boolean_amb_Boolean_boolean", "boolean", new String[]{"boolean"}, "true", "true", AMBIGUOUS);
    }

    public void test_smallint_amb_short_short() throws Exception {
        this.declareAndFailFunction("smallint_amb_short_short", "smallint", new String[]{"smallint"}, "3", "3", AMBIGUOUS);
    }

    public void test_smallint_amb_Integer_short() throws Exception {
        this.declareAndFailFunction("smallint_amb_Integer_short", "smallint", new String[]{"smallint"}, "3", "3", AMBIGUOUS);
    }

    public void test_smallint_amb_byte_short() throws Exception {
        this.declareAndFailFunction("smallint_amb_byte_short", "smallint", new String[]{"smallint"}, "3", "3", AMBIGUOUS);
    }

    public void test_integer_amb_int_int() throws Exception {
        this.declareAndFailFunction("integer_amb_int_int", "int", new String[]{"int"}, "3", "3", AMBIGUOUS);
    }

    public void test_integer_amb_Integer_int() throws Exception {
        this.declareAndFailFunction("integer_amb_Integer_int", "int", new String[]{"int"}, "3", "3", AMBIGUOUS);
    }

    public void test_integer_amb_byte_int() throws Exception {
        this.declareAndFailFunction("integer_amb_byte_int", "int", new String[]{"int"}, "3", "3", AMBIGUOUS);
    }

    public void test_bigint_amb_long_long() throws Exception {
        this.declareAndFailFunction("bigint_amb_long_long", "bigint", new String[]{"bigint"}, "3", "3", AMBIGUOUS);
    }

    public void test_bigint_amb_Long_long() throws Exception {
        this.declareAndFailFunction("bigint_amb_Long_long", "bigint", new String[]{"bigint"}, "3", "3", AMBIGUOUS);
    }

    public void test_bigint_amb_byte_long() throws Exception {
        this.declareAndFailFunction("bigint_amb_byte_long", "bigint", new String[]{"bigint"}, "3", "3", AMBIGUOUS);
    }

    public void test_real_amb_float_float() throws Exception {
        this.declareAndFailFunction("real_amb_float_float", "real", new String[]{"real"}, "3.0", "3.0", AMBIGUOUS);
    }

    public void test_real_amb_Float_float() throws Exception {
        this.declareAndFailFunction("real_amb_Float_float", "real", new String[]{"real"}, "3.0", "3.0", AMBIGUOUS);
    }

    public void test_real_amb_byte_float() throws Exception {
        this.declareAndFailFunction("real_amb_byte_float", "real", new String[]{"real"}, "3.0", "3.0", AMBIGUOUS);
    }

    public void test_double_amb_double_double() throws Exception {
        this.declareAndFailFunction("double_amb_double_double", "double", new String[]{"double"}, "3.0", "3.0", AMBIGUOUS);
    }

    public void test_double_amb_Double_double() throws Exception {
        this.declareAndFailFunction("double_amb_Double_double", "double", new String[]{"double"}, "3.0", "3.0", AMBIGUOUS);
    }

    public void test_double_amb_byte_double() throws Exception {
        this.declareAndFailFunction("double_amb_byte_double", "double", new String[]{"double"}, "3.0", "3.0", AMBIGUOUS);
    }

    public void test_boolean_unres_boolean() throws Exception {
        this.declareAndFailFunction("boolean_unres_boolean", "boolean", new String[]{"boolean"}, "true", "true", TRIED_ALL_COMBINATIONS);
    }

    public void test_boolean_unres_Boolean() throws Exception {
        this.declareAndFailFunction("boolean_unres_Boolean", "boolean", new String[]{"boolean"}, "true", "true", TRIED_ALL_COMBINATIONS);
    }

    public void test_smallint_unres_short() throws Exception {
        this.declareAndFailFunction("smallint_unres_short", "smallint", new String[]{"smallint"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_smallint_unres_Short() throws Exception {
        this.declareAndFailFunction("smallint_unres_Short", "smallint", new String[]{"smallint"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_integer_unres_int() throws Exception {
        this.declareAndFailFunction("integer_unres_int", "int", new String[]{"int"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_integer_unres_Integer() throws Exception {
        this.declareAndFailFunction("integer_unres_Integer", "int", new String[]{"int"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_bigint_unres_long() throws Exception {
        this.declareAndFailFunction("bigint_unres_long", "bigint", new String[]{"bigint"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_bigint_unres_Long() throws Exception {
        this.declareAndFailFunction("bigint_unres_Long", "bigint", new String[]{"bigint"}, "3", "3", TRIED_ALL_COMBINATIONS);
    }

    public void test_real_unres_float() throws Exception {
        this.declareAndFailFunction("real_unres_float", "real", new String[]{"real"}, "3.0", "3.0", TRIED_ALL_COMBINATIONS);
    }

    public void test_real_unres_Float() throws Exception {
        this.declareAndFailFunction("real_unres_Float", "real", new String[]{"real"}, "3.0", "3.0", TRIED_ALL_COMBINATIONS);
    }

    public void test_double_unres_double() throws Exception {
        this.declareAndFailFunction("double_unres_double", "double", new String[]{"double"}, "3.0", "3.0", TRIED_ALL_COMBINATIONS);
    }

    public void test_double_unres_Double() throws Exception {
        this.declareAndFailFunction("double_unres_Double", "double", new String[]{"double"}, "3.0", "3.0", TRIED_ALL_COMBINATIONS);
    }

    public void test_wrapperOutputArgs() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = conn.prepareStatement("create procedure wrapperProc\n(\n    out bigintCol bigint,\n    out booleanCol boolean,\n    out doubleCol double,\n    out floatCol float,\n    out intCol int,\n    out realCol real,\n    out smallintCol smallint\n)\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.AnsiSignatures.wrapperProc'\n");
        ps.execute();
        ps.close();
        CallableStatement cs = conn.prepareCall("call wrapperProc(  ?, ?, ?, ?, ?, ?, ? )");
        int param = 1;
        cs.registerOutParameter(param++, -5);
        cs.registerOutParameter(param++, 16);
        cs.registerOutParameter(param++, 8);
        cs.registerOutParameter(param++, 6);
        cs.registerOutParameter(param++, 4);
        cs.registerOutParameter(param++, 7);
        cs.registerOutParameter(param++, 5);
        cs.execute();
        param = 1;
        AnsiSignaturesTest.assertEquals((long)1L, (long)cs.getLong(param++));
        AnsiSignaturesTest.assertEquals((boolean)true, (boolean)cs.getBoolean(param++));
        AnsiSignaturesTest.assertEquals((double)1.0, (double)cs.getDouble(param++), (double)0.0);
        AnsiSignaturesTest.assertEquals((double)1.0, (double)cs.getDouble(param++), (double)0.0);
        AnsiSignaturesTest.assertEquals((int)1, (int)cs.getInt(param++));
        AnsiSignaturesTest.assertEquals((float)1.0f, (float)cs.getFloat(param++), (float)0.0f);
        AnsiSignaturesTest.assertEquals((short)1, (short)cs.getShort(param++));
    }

    private void declareAndRunFunction(String name, String returnType, String[] argTypes, String args, String result) throws Exception {
        Connection conn = this.getConnection();
        this.declareFunction(conn, name, returnType, argTypes);
        this.runFunction(conn, name, args, result, null);
    }

    private void declareAndFailFunction(String name, String returnType, String[] argTypes, String args, String result, String sqlstate) throws Exception {
        Connection conn = this.getConnection();
        this.declareFunction(conn, name, returnType, argTypes);
        this.runFunction(conn, name, args, result, sqlstate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFunction(Connection conn, String name, String args, String result, String sqlstate) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("values ( " + this.doubleQuote(name) + "( " + args + " ) )");
        String query = buffer.toString();
        AnsiSignaturesTest.println(query);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(query);
            rs = ps.executeQuery();
            rs.next();
            AnsiSignaturesTest.assertEquals((String)rs.getString(1), (String)result);
            if (sqlstate != null) {
                AnsiSignaturesTest.fail((String)("Should have failed with sqlstate: " + sqlstate));
            }
        }
        catch (SQLException se) {
            AnsiSignaturesTest.assertSQLState(sqlstate, se);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    private void declareFunction(Connection conn, String name, String returnType, String[] argTypes) throws Exception {
        StringBuffer buffer = new StringBuffer();
        int count = argTypes.length;
        buffer.append("create function " + this.doubleQuote(name));
        buffer.append("\n(");
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("\n\ta_" + i + " " + argTypes[i]);
        }
        buffer.append("\n)\n");
        buffer.append("returns " + returnType);
        buffer.append("\nlanguage java\nparameter style java\nno sql\n");
        buffer.append("external name '" + AnsiSignatures.class.getName() + "." + name + "'");
        String ddl = buffer.toString();
        AnsiSignaturesTest.println(ddl);
        PreparedStatement ps = conn.prepareStatement(ddl);
        ps.execute();
        ps.close();
        conn.commit();
    }

    private String doubleQuote(String raw) {
        return "\"" + raw + "\"";
    }

    @Override
    protected PreparedStatement chattyPrepare(Connection conn, String text) throws SQLException {
        AnsiSignaturesTest.println("Preparing statement:\n\t" + text);
        return conn.prepareStatement(text);
    }

    private String getScalarString(PreparedStatement ps) throws Exception {
        ResultSet rs = ps.executeQuery();
        rs.next();
        String retval = rs.getString(1);
        rs.close();
        ps.close();
        return retval;
    }
}

