/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.net.URL;
import java.net.URLClassLoader;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClassLoaderTestSetup
extends BaseJDBCTestSetup {
    private ClassLoader oldLoader;

    public ClassLoaderTestSetup(Test test) {
        super(test);
    }

    private static ClassLoader makeClassLoader() {
        return new URLClassLoader(new URL[0]);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestConfiguration.getCurrent().shutdownEngine();
        this.oldLoader = ClassLoaderTestSetup.getThreadLoader();
        ClassLoaderTestSetup.setThreadLoader(ClassLoaderTestSetup.makeClassLoader());
    }

    @Override
    protected void tearDown() throws Exception {
        ClassLoaderTestSetup.setThreadLoader(this.oldLoader);
        super.tearDown();
    }

    public static void setThreadLoader(ClassLoader which) {
        Thread.currentThread().setContextClassLoader(which);
    }

    public static ClassLoader getThreadLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

