/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NullsTest
extends BaseJDBCTestCase {
    public NullsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(NullsTest.class);
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    public void testCreate() throws SQLException {
        Statement st = this.createStatement();
        this.assertCompileError("42X01", "create table a(a1 int null)");
        String sql = "create table a(a1 int null not null)";
        NullsTest.assertStatementError("42X01", st, sql);
        sql = "create table a(a1 int not null null)";
        NullsTest.assertStatementError("42X01", st, sql);
        sql = "create table a1(ac1 int null primary key)";
        NullsTest.assertStatementError("42X01", st, sql);
        sql = "create table a1(ac1 int null, ac2 int not null, primary key(ac1,ac2))";
        NullsTest.assertStatementError("42X01", st, sql);
        sql = "create table a2(ac1 int null null)";
        NullsTest.assertStatementError("42X01", st, sql);
        sql = "create table a3(ac1 int not null null not null)";
        NullsTest.assertStatementError("42X01", st, sql);
        sql = "create table a3(ac1 int default null)";
        st.executeUpdate(sql);
        sql = "create table a4(ac1 int not null)";
        st.executeUpdate(sql);
        this.dropTable("a3");
        this.dropTable("a4");
        sql = "create table a5(ac1 int default null, ac2 int not null)";
        st.executeUpdate(sql);
        this.dropTable("a5");
        sql = "create table a6(ac1 int default null)";
        st.executeUpdate(sql);
        sql = "create table a7(ac1 int not null primary key)";
        st.executeUpdate(sql);
        this.dropTable("a6");
        this.dropTable("a7");
        st.close();
    }

    public void testAlter() throws SQLException {
        Statement st = this.createStatement();
        String sql = "create table a(a1 int not null , a2 int not null)";
        st.executeUpdate(sql);
        sql = "alter table a add column a3 int null constraint ap1 primary key";
        NullsTest.assertStatementError("42X01", st, sql);
        this.assertCompileError("42X01", "alter table a add column a3 int null");
        sql = "alter table a add constraint ap1 primary key(a1,a2)";
        st.executeUpdate(sql);
        this.dropTable("a");
        sql = "create table a ( a int not null unique)";
        st.executeUpdate(sql);
        sql = "alter table a modify a null";
        NullsTest.assertStatementError("42X01", st, sql);
        this.dropTable("a");
        sql = "create table a (a1 int not null, a2 int, a3 int)";
        st.executeUpdate(sql);
        sql = "insert into a values(1,1,1)";
        NullsTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "alter table a alter column a2 not null";
        st.executeUpdate(sql);
        sql = "alter table a alter column a3 not null";
        st.executeUpdate(sql);
        sql = "alter table a add constraint ap1 primary key(a1, a2, a3)";
        st.executeUpdate(sql);
        sql = "insert into a values(1, NULL, 1)";
        NullsTest.assertStatementError("23502", st, sql);
        this.dropTable("a");
        sql = "create table a (a1 int not null, a2 int default null, a3 int default null)";
        st.executeUpdate(sql);
        sql = "insert into a values(1,NULL,1)";
        NullsTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "alter table a add constraint ap1 primary key(a1, a2, a3)";
        NullsTest.assertStatementError("42831", st, sql);
        this.dropTable("a");
        sql = "create table a (a1 int not null, a2 int)";
        st.executeUpdate(sql);
        sql = "insert into a values(1, NULL)";
        NullsTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "alter table a add constraint ap1 primary key(a1, a2)";
        NullsTest.assertStatementError("42831", st, sql);
        this.dropTable("a");
        sql = "create table a (a1 int, a2 int, a3 int)";
        st.executeUpdate(sql);
        sql = "alter table a add constraint ap1 primary key(a1, a2, a3)";
        NullsTest.assertStatementError("42831", st, sql);
        this.dropTable("a");
        st.close();
    }

    public void testInsert() throws SQLException {
        Statement st = this.createStatement();
        String sql = "create table a (a int not null constraint auniq unique)";
        st.executeUpdate(sql);
        sql = "insert into a values (1)";
        st.executeUpdate(sql);
        sql = "insert into a values (1)";
        NullsTest.assertStatementError("23505", st, sql);
        this.dropTable("a");
        sql = "create table s (x int default null not null, y int)";
        st.executeUpdate(sql);
        sql = "insert into s (y) values(1)";
        NullsTest.assertStatementError("23502", st, sql);
        sql = "select * from s";
        JDBC.assertEmpty(st.executeQuery(sql));
        this.dropTable("s");
        st.close();
    }

    public void testInsertIntoTableWithNullAndNonNullColumns() throws SQLException {
        Statement st = this.createStatement();
        String sql = "create table t (i int, i_d int default null, i_n int not null, s smallint, s_d smallint default null, s_n smallint not null)";
        st.executeUpdate(sql);
        sql = "insert into t (i, i_d, i_n, s, s_d, s_n) values (1, 1, 1, 1, 1, 1)";
        NullsTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "insert into t values (null, null, 2, null, null, 2)";
        NullsTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "insert into t (i, i_n, s, s_d, s_n) values (3, 3, 3, 3, 3)";
        NullsTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "insert into t (i, i_d, i_n, s, s_n) values (4, 4, 4, 4, 4)";
        NullsTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "insert into t (i, i_n, s, s_n) values (5, 5, 5, 5)";
        NullsTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "insert into t (i, i_d, s, s_d) values (6, 6, 6, 6)";
        NullsTest.assertStatementError("23502", st, sql);
        sql = "insert into t (i_d, i_n, s_d, s_n) values (7, 7, 7, 7)";
        NullsTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "insert into t values (8, 8, null, 8, 8, 8)";
        NullsTest.assertStatementError("23502", st, sql);
        sql = "insert into t values (9, 9, 9, 9, 9, null)";
        NullsTest.assertStatementError("23502", st, sql);
        sql = "select * from t";
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{"1", "1", "1", "1", "1", "1"}, {null, null, "2", null, null, "2"}, {"3", null, "3", "3", "3", "3"}, {"4", "4", "4", "4", null, "4"}, {"5", null, "5", "5", null, "5"}, {null, "7", "7", null, "7", "7"}});
        this.dropTable("t");
        st.close();
    }

    public void testISNullAndNot() throws SQLException {
        String sql = "create table u (c1 integer)";
        Statement st = this.createStatement();
        st.addBatch(sql);
        sql = "insert into u values null";
        st.addBatch(sql);
        sql = "insert into u values 1";
        st.addBatch(sql);
        sql = "insert into u values null";
        st.addBatch(sql);
        sql = "insert into u values 2";
        st.addBatch(sql);
        st.executeBatch();
        sql = "select * from u";
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{null}, {"1"}, {null}, {"2"}});
        sql = "select * from u where c1 is null";
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{null}, {null}});
        sql = "select * from u where c1 is not null";
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{"1"}, {"2"}});
        st.close();
        sql = "select * from u where cast (? as varchar(1)) is null";
        PreparedStatement p1 = this.prepareStatement(sql);
        p1.setString(1, "a");
        JDBC.assertEmpty(p1.executeQuery());
        p1.close();
        sql = "select * from u where cast (? as varchar(1)) is not null";
        PreparedStatement p2 = this.prepareStatement(sql);
        p2.setString(1, "a");
        JDBC.assertFullResultSet(p2.executeQuery(), new String[][]{{null}, {"1"}, {null}, {"2"}});
        p2.close();
        st = this.createStatement();
        sql = "select count(*) from u where c1 is null";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "2");
        sql = "insert into u select * from (values null) as X";
        NullsTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "select * from u";
        JDBC.assertFullResultSet(st.executeQuery(sql), new String[][]{{null}, {"1"}, {null}, {"2"}, {null}});
        sql = "select count(*) from u where c1 is null";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "3");
        this.dropTable("u");
        st.close();
    }
}

