/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.TimeZoneTestSetup;

public class Derby5866TriggerOrderTest
extends BaseJDBCTestCase {
    private static final TimeZone TIMEZONE = TimeZone.getTimeZone("Europe/Oslo");
    private static final String OVERRIDE_TIME_PROP = "derby.debug.overrideTriggerCreationTimestamp";

    public Derby5866TriggerOrderTest(String name) {
        super(name);
    }

    public static Test suite() {
        CleanDatabaseTestSetup test = new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(Derby5866TriggerOrderTest.class));
        return new TimeZoneTestSetup((Test)test, TIMEZONE);
    }

    @Override
    protected void tearDown() throws Exception {
        TimeZoneTestSetup.setDefault(TIMEZONE);
        Derby5866TriggerOrderTest.removeSystemProperty(OVERRIDE_TIME_PROP);
        super.tearDown();
    }

    public void testTimeZoneChange() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("create table t2(x int generated always as identity, y varchar(128))");
        s.execute("create trigger tr1 after insert on t1 insert into t2(y) values 'I won! :)'");
        TimeZoneTestSetup.setDefault(TimeZone.getTimeZone("GMT-8:00"));
        s.execute("create trigger tr2 after insert on t1 insert into t2(y) values 'I lost... :('");
        s.execute("insert into t1 values 1");
        JDBC.assertFullResultSet(s.executeQuery("select * from t2 order by x"), new String[][]{{"1", "I won! :)"}, {"2", "I lost... :("}});
    }

    public void testEqualTimestamps() throws SQLException {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.testSpecificTimestamps(now, now, now);
    }

    public void testReversedTimestamps() throws SQLException {
        long now = System.currentTimeMillis();
        this.testSpecificTimestamps(new Timestamp(now), new Timestamp(now - 1L), new Timestamp(now - 2L), new Timestamp(now - 3L));
    }

    public void testCrossDaylightSaving() throws SQLException {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(2014, 2, 30, 0, 45, 0);
        this.testSpecificTimestamps(new Timestamp(cal.getTimeInMillis()), new Timestamp(cal.getTimeInMillis() + 1800000L));
        cal.clear();
        cal.set(2014, 9, 26, 0, 45, 0);
        this.testSpecificTimestamps(new Timestamp(cal.getTimeInMillis()), new Timestamp(cal.getTimeInMillis() + 1800000L));
        cal.clear();
        cal.set(2014, 2, 30, 0, 59, 59);
        cal.set(14, 999);
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        this.testSpecificTimestamps(ts, ts, ts);
        cal.clear();
        cal.set(2014, 9, 26, 0, 59, 59);
        cal.set(14, 999);
        ts = new Timestamp(cal.getTimeInMillis());
        this.testSpecificTimestamps(ts, ts, ts);
    }

    public void testPreEpoch() throws SQLException {
        Timestamp ts = new Timestamp(-86400000L);
        this.testSpecificTimestamps(ts, ts, ts);
        ts.setNanos(123000000);
        this.testSpecificTimestamps(ts, ts, ts);
        ts.setNanos(567000000);
        this.testSpecificTimestamps(ts, ts, ts);
        ts.setNanos(999000000);
        this.testSpecificTimestamps(ts, ts, ts);
    }

    private void testSpecificTimestamps(Timestamp ... timestamps) throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("create table t2(x int generated always as identity, y int)");
        for (int i = 0; i < timestamps.length; ++i) {
            this.overrideTriggerCreationTime(timestamps[i]);
            s.execute("create trigger tr" + (i + 1) + " after insert on t1 insert into t2(y) values " + (i + 1));
        }
        s.execute("insert into t1 values 1");
        ResultSet rs = s.executeQuery("select * from t2 order by x");
        for (int i = 1; i <= timestamps.length; ++i) {
            if (rs.next()) {
                Derby5866TriggerOrderTest.assertEquals((String)"X", (int)i, (int)rs.getInt("X"));
                Derby5866TriggerOrderTest.assertEquals((String)"Y", (int)i, (int)rs.getInt("Y"));
                continue;
            }
            Derby5866TriggerOrderTest.fail((String)("Row " + i + " was missing"));
        }
        JDBC.assertEmpty(rs);
        PreparedStatement ps = this.prepareStatement("select * from sys.sysschemas natural join sys.systriggers where schemaname = ? and triggername like 'TR%' order by creationtimestamp");
        ps.setString(1, this.getTestConfiguration().getUserName());
        rs = ps.executeQuery();
        Timestamp prev = null;
        for (int i = 1; i <= timestamps.length; ++i) {
            Derby5866TriggerOrderTest.assertTrue((boolean)rs.next());
            Derby5866TriggerOrderTest.assertEquals((String)("TR" + i), (String)rs.getString("TRIGGERNAME"));
            Timestamp ts = rs.getTimestamp("CREATIONTIMESTAMP");
            Derby5866TriggerOrderTest.assertNotNull((Object)ts);
            if (prev != null && !prev.before(ts)) {
                Derby5866TriggerOrderTest.fail((String)(String.valueOf(prev) + " expected to be before " + String.valueOf(ts)));
            }
            prev = ts;
        }
        JDBC.assertEmpty(rs);
        this.rollback();
    }

    private void overrideTriggerCreationTime(Timestamp ts) {
        Derby5866TriggerOrderTest.setSystemProperty(OVERRIDE_TIME_PROP, String.valueOf(ts.getTime()));
    }
}

