/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.shared.common.i18n.MessageService;

public class OptTraceViewer
implements OptionalTool {
    @Override
    public void loadTool(String ... configurationParameters) throws SQLException {
        if (configurationParameters == null || configurationParameters.length != 1) {
            throw this.wrap(MessageService.getTextMessage("X0Y89.S", new Object[0]));
        }
        String fileURL = configurationParameters[0];
        String createView = "create view planCost as\nselect *\nfrom table\n(\n    planCost\n    (\n        'FILE_URL',\n        'planCost',\n        asList( 'stmtText', 'stmtID', 'qbID' ),\n        asList( 'pcComplete', 'pcSummary', 'pcType', 'ceEstimatedCost', 'ceEstimatedRowCount' )\n     )\n) v\n".replace("FILE_URL", fileURL);
        Connection conn = this.getDerbyConnection();
        this.executeDDL(conn, "create type ArrayList external name 'java.util.ArrayList' language java");
        this.executeDDL(conn, "create function asList( cell varchar( 32672 ) ... ) returns ArrayList\nlanguage java parameter style derby no sql\nexternal name 'org.apache.derby.vti.XmlVTI.asList'\n");
        this.executeDDL(conn, "create function planCost\n(\n    xmlResourceName varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    parentTags ArrayList,\n    childTags ArrayList\n)\nreturns table\n(\n    text varchar( 32672 ),\n    stmtID    int,\n    qbID   int,\n    complete  boolean,\n    summary   varchar( 32672 ),\n    type        varchar( 50 ),\n    estimatedCost        double,\n    estimatedRowCount    bigint\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTI'\n");
        this.executeDDL(conn, createView);
    }

    @Override
    public void unloadTool(String ... configurationParameters) throws SQLException {
        Connection conn = this.getDerbyConnection();
        this.executeDDL(conn, "drop view planCost");
        this.executeDDL(conn, "drop function planCost");
        this.executeDDL(conn, "drop function asList");
        this.executeDDL(conn, "drop type ArrayList restrict");
    }

    private Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private void executeDDL(Connection conn, String text) throws SQLException {
        PreparedStatement ddl = this.prepareStatement(conn, text);
        ddl.execute();
        ddl.close();
    }

    private PreparedStatement prepareStatement(Connection conn, String text) throws SQLException {
        return conn.prepareStatement(text);
    }

    private SQLException wrap(Throwable t) {
        return new SQLException(t.getMessage(), t);
    }

    private SQLException wrap(String errorMessage) {
        String sqlState = "XJ001.U".substring(0, 5);
        return new SQLException(errorMessage, sqlState);
    }
}

