/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class VarargsTest
extends GeneratedColumnsHelper {
    private static final String NEEDS_DERBY_STYLE = "42ZC9";
    private static final String NEEDS_JAVA_STYLE = "42ZCA";
    private static final String RETURNS_RESULT_SETS = "42ZCB";
    private static final String AMBIGUOUS = "42X73";
    private static final String NO_SUCH_METHOD = "42X50";
    private static final String BAD_TIME_FORMAT = "22007";
    private static final String BAD_BOOLEAN_FORMAT = "22018";
    private static final String NEEDS_DJRS_STYLE = "42ZB2";
    private static final String NEEDS_PARAMETER_MARKER = "42886";

    public VarargsTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("UserDefinedAggregatesTest");
        suite.addTest(TestConfiguration.defaultSuite(VarargsTest.class));
        return suite;
    }

    public void test_01_basicSyntax() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create function varargsDerbyStyle( a int ... ) returns int\nparameter style derby language java no sql\nexternal name 'Foo.foo'\n");
        this.goodStatement(conn, "create function varargsTableFunction( a int ... )\nreturns table( b int )\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'Foo.foo'\n");
        this.goodStatement(conn, "create function nonvarargsJavaStyle( a int ) returns int\nparameter style java language java no sql\nexternal name 'Foo.foo'\n");
        this.goodStatement(conn, "create procedure varargsDerbyStyle( a int ... )\nlanguage java parameter style derby no sql\nexternal name 'Foo.foo'\n");
        this.goodStatement(conn, "create procedure nonvarargsJavaStyle( a int )\nlanguage java parameter style java no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError(NEEDS_DERBY_STYLE, "create function varargsJavaStyle( a int ... ) returns int\nparameter style java language java no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError(NEEDS_JAVA_STYLE, "create function nonvarargsDerbyStyle( a int ) returns int\nparameter style derby language java no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError(NEEDS_DERBY_STYLE, "create procedure varargsDerbyStyle( a int ... )\nlanguage java parameter style java no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError(NEEDS_JAVA_STYLE, "create procedure nonvarargsDerbyStyle( a int )\nlanguage java parameter style derby no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError("42X01", "create function varargsDerbyStyleNoParam( ... ) returns int\nparameter style derby language java no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError("42X01", "create procedure varargsDerbyStyleNoParam( ... )\nlanguage java parameter style derby no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError(RETURNS_RESULT_SETS, "create procedure varargsDerbyStyle( a int ... )\nlanguage java parameter style derby no sql result sets 1\nexternal name 'Foo.foo'\n");
    }

    public void test_02_simple() throws Exception {
        if (!this.vmSupportsVarargs()) {
            return;
        }
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create function maximum( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.max'\n");
        this.goodStatement(conn, "create function formatMessage( message varchar( 32672 ),  args varchar( 32672 ) ... ) returns varchar( 32672 )\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.formatMessage'\n");
        this.assertResults(conn, "values maximum()", new String[][]{{null}}, false);
        this.assertResults(conn, "values maximum( null )", new String[][]{{null}}, false);
        this.assertResults(conn, "values maximum( 1 )", new String[][]{{"1"}}, false);
        this.assertResults(conn, "values maximum( 1, 3, 2 )", new String[][]{{"3"}}, false);
        this.assertResults(conn, "values formatMessage( 'First {0} then {1} then {2}', 'one', 'two', 'three' )", new String[][]{{"First one then two then three"}}, false);
    }

    public void test_03_misc() throws Exception {
        if (!this.vmSupportsVarargs()) {
            return;
        }
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create function ambiguousTypes( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.ambiguousTypes'\n");
        this.expectCompilationError(AMBIGUOUS, "values ambiguousTypes( 1, 2, 3 )");
        this.goodStatement(conn, "create function maxInts( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.maxInts'\n");
        this.assertResults(conn, "values maxInts( 3 )", new String[][]{{"3"}}, false);
        this.assertResults(conn, "values maxInts( 1, 2, 5, 4, 3 )", new String[][]{{"5"}}, false);
        this.goodStatement(conn, "create function nonVarargsMethod( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.nonVarargsMethod'\n");
        this.expectCompilationError(NO_SUCH_METHOD, "values nonVarargsMethod( 3 )");
        this.goodStatement(conn, "create function vnvr_vararg( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.vnvr'\n");
        this.goodStatement(conn, "create function vnvr_nonvararg( a int ) returns int\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.vnvr'\n");
        this.assertResults(conn, "values vnvr_vararg( 3 )", new String[][]{{"3"}}, false);
        this.assertResults(conn, "values vnvr_nonvararg( 3 )", new String[][]{{"-3"}}, false);
        this.goodStatement(conn, "create function lnv( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.lnv'\n");
        this.goodStatement(conn, "create function lnv_1( a int, b int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.lnv'\n");
        this.goodStatement(conn, "create function lnv_2( a int, b int, c int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.lnv'\n");
        this.assertResults(conn, "values lnv( 5, 4, 3, 2, 1 )", new String[][]{{"5"}}, false);
        this.assertResults(conn, "values lnv_1( 5, 4, 3, 2, 1 )", new String[][]{{"4"}}, false);
        this.assertResults(conn, "values lnv_2( 5, 4, 3, 2, 1 )", new String[][]{{"3"}}, false);
    }

    public void test_04_inOut() throws Exception {
        if (!this.vmSupportsVarargs()) {
            return;
        }
        Connection conn = this.getConnection();
        CallableStatement cs = null;
        this.goodStatement(conn, "create procedure inVarargs( out result varchar( 32672 ), b int ... )\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.inVarargs'\n");
        cs = this.chattyPrepareCall(conn, "call inVarargs( ?, ? )");
        cs.registerOutParameter(1, 12);
        cs.setInt(2, 5);
        cs.execute();
        VarargsTest.assertEquals((String)"RESULT:  5", (String)cs.getString(1));
        cs = this.chattyPrepareCall(conn, "call inVarargs( ?, ?, ? )");
        cs.registerOutParameter(1, 12);
        cs.setInt(2, 5);
        cs.setInt(3, 4);
        cs.execute();
        VarargsTest.assertEquals((String)"RESULT:  5 4", (String)cs.getString(1));
        cs = this.chattyPrepareCall(conn, "call inVarargs( ?, ?, ?, ? )");
        cs.registerOutParameter(1, 12);
        cs.setInt(2, 5);
        cs.setInt(3, 4);
        cs.setInt(4, 3);
        cs.execute();
        VarargsTest.assertEquals((String)"RESULT:  5 4 3", (String)cs.getString(1));
        this.goodStatement(conn, "create procedure outVarargs( seed int, out b int ... )\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.outVarargs'\n");
        cs = this.chattyPrepareCall(conn, "call outVarargs( ? )");
        cs.setInt(1, 5);
        cs.execute();
        cs = this.chattyPrepareCall(conn, "call outVarargs( ?, ? )");
        cs.registerOutParameter(2, 4);
        cs.setInt(1, 5);
        cs.execute();
        VarargsTest.assertEquals((int)5, (int)cs.getInt(2));
        cs = this.chattyPrepareCall(conn, "call outVarargs( ?, ?, ? )");
        cs.registerOutParameter(2, 4);
        cs.registerOutParameter(3, 4);
        cs.setInt(1, 5);
        cs.execute();
        VarargsTest.assertEquals((int)5, (int)cs.getInt(2));
        VarargsTest.assertEquals((int)6, (int)cs.getInt(3));
        cs = this.chattyPrepareCall(conn, "call outVarargs( ?, ?, ?, ? )");
        cs.registerOutParameter(2, 4);
        cs.registerOutParameter(3, 4);
        cs.registerOutParameter(4, 4);
        cs.setInt(1, 5);
        cs.execute();
        VarargsTest.assertEquals((int)5, (int)cs.getInt(2));
        VarargsTest.assertEquals((int)6, (int)cs.getInt(3));
        VarargsTest.assertEquals((int)7, (int)cs.getInt(4));
        this.goodStatement(conn, "create procedure inoutVarargs( seed int, inout b int ... )\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.inoutVarargs'\n");
        cs = this.chattyPrepareCall(conn, "call inoutVarargs( ? )");
        cs.setInt(1, 5);
        cs.execute();
        cs = this.chattyPrepareCall(conn, "call inoutVarargs( ?, ? )");
        cs.registerOutParameter(2, 4);
        cs.setInt(1, 5);
        cs.setInt(2, 3);
        cs.execute();
        VarargsTest.assertEquals((int)8, (int)cs.getInt(2));
        cs = this.chattyPrepareCall(conn, "call inoutVarargs( ?, ?, ? )");
        cs.registerOutParameter(2, 4);
        cs.registerOutParameter(3, 4);
        cs.setInt(1, 5);
        cs.setInt(2, 3);
        cs.setInt(3, 10);
        cs.execute();
        VarargsTest.assertEquals((int)8, (int)cs.getInt(2));
        VarargsTest.assertEquals((int)15, (int)cs.getInt(3));
        cs = this.chattyPrepareCall(conn, "call inoutVarargs( ?, ?, ?, ? )");
        cs.registerOutParameter(2, 4);
        cs.registerOutParameter(3, 4);
        cs.registerOutParameter(4, 4);
        cs.setInt(1, 5);
        cs.setInt(2, 3);
        cs.setInt(3, 10);
        cs.setInt(4, 100);
        cs.execute();
        VarargsTest.assertEquals((int)8, (int)cs.getInt(2));
        VarargsTest.assertEquals((int)15, (int)cs.getInt(3));
        VarargsTest.assertEquals((int)105, (int)cs.getInt(4));
    }

    public void test_05_datatypes() throws Exception {
        if (!this.vmSupportsVarargs()) {
            return;
        }
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create function makeBlob( a varchar( 32672 ) ) returns blob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.makeBlob'\n");
        this.goodStatement(conn, "create function makeBytes( a varchar( 32672 ) ) returns char(1) for bit data\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.makeBytes'\n");
        this.goodStatement(conn, "create function makeVarBytes( a varchar( 32672 ) ) returns varchar(10) for bit data\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.makeBytes'\n");
        this.goodStatement(conn, "create function makeLongVarBytes( a varchar( 32672 ) ) returns long varchar for bit data\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.makeBytes'\n");
        this.goodStatement(conn, "create function makeClob( a varchar( 32672 ) ) returns clob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.makeClob'\n");
        this.goodStatement(conn, "create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(conn, "create function makePrice( currencyCode char( 3 ), amount decimal( 31, 5 ), timeInstant Timestamp )\nreturns Price language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        this.vetDatatype(conn, "boolean", "boolean", "true", "false", "true", "1", "1", "2");
        this.vetDatatype(conn, "long", "bigint", "1", "2", "3", "1", "3", "6");
        this.vetDatatype(conn, "int", "int", "1", "2", "3", "1", "3", "6");
        this.vetDatatype(conn, "short", "smallint", "1", "2", "3", "1", "3", "6");
        this.vetDatatype(conn, "bigdecimal", "decimal(5,2)", "1.0", "2.0", "3.0", "1", "3", "6");
        this.vetDatatype(conn, "bigdecimal", "numeric(5,2)", "1.0", "2.0", "3.0", "1", "3", "6");
        this.vetDatatype(conn, "double", "double", "1.0", "2.0", "3.0", "1.0", "3.0", "6.0");
        this.vetDatatype(conn, "float", "real", "1.0", "2.0", "3.0", "1.0", "3.0", "6.0");
        this.vetDatatype(conn, "double", "float", "1.0", "2.0", "3.0", "1.0", "3.0", "6.0");
        this.vetDatatype(conn, "blob", "blob", "makeBlob( '1' )", "makeBlob( '2' )", "makeBlob( '3' )", "1", "3", "6");
        this.vetDatatype(conn, "clob", "clob", "makeClob( '1' )", "makeClob( '2' )", "makeClob( '3' )", "1", "12", "123");
        this.vetDatatype(conn, "byte[]", "char(1) for bit data", "makeBytes( '1' )", "makeBytes( '2' )", "makeBytes( '3' )", "1", "3", "6");
        this.vetDatatype(conn, "byte[]", "varchar(10) for bit data", "makeVarBytes( '1' )", "makeVarBytes( '2' )", "makeVarBytes( '3' )", "1", "3", "6");
        this.vetDatatype(conn, "byte[]", "long varchar for bit data", "makeLongVarBytes( '1' )", "makeLongVarBytes( '2' )", "makeLongVarBytes( '3' )", "1", "3", "6");
        this.vetDatatype(conn, "String", "char(1)", "'1'", "'2'", "'3'", "1", "12", "123");
        this.vetDatatype(conn, "String", "varchar(10)", "'1'", "'2'", "'3'", "1", "12", "123");
        this.vetDatatype(conn, "String", "long varchar", "'1'", "'2'", "'3'", "1", "12", "123");
        this.vetDatatype(conn, "date", "date", "date('1994-02-23')", "date('1995-02-23')", "date('1996-02-23')", "1", "2", "3");
        this.vetDatatype(conn, "time", "time", "time('15:09:02')", "time('14:09:02')", "time('13:09:02')", "1", "2", "3");
        this.vetDatatype(conn, "timestamp", "timestamp", "timestamp('1962-09-23 03:23:34.234')", "timestamp('1963-09-23 03:23:34.234')", "timestamp('1964-09-23 03:23:34.234')", "1", "2", "3");
        this.vetDatatype(conn, "Price", "Price", "makePrice( 'USD', cast( 9.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') )", "makePrice( 'USD', cast( 10.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') )", "makePrice( 'USD', cast( 11.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') )", "1", "2", "3");
        this.goodStatement(conn, "create table all_types\n(\n    bigint_col  bigint,\n    blob_col    blob,\n    boolean_col boolean,\n    char_col    char( 1 ),\n    char_for_bit_data_col   char( 1 ) for bit data,\n    clob_col    clob,\n    date_col    date,\n    decimal_col decimal,\n    double_col  double,\n    float_col   float,\n    integer_col int,\n    long_varchar_col    long varchar,\n    long_varchar_for_bit_data_col   long varchar for bit data,\n    numeric_col    numeric,\n    real_col       real,\n    smallint_col   smallint,\n    time_col       time,\n    timestamp_col  timestamp,\n    varchar_col    varchar( 5 ),\n    varchar_for_bit_data_col  varchar( 10 ) for bit data,\n    price_col    price\n)\n");
        this.goodStatement(conn, "insert into all_types values\n(\n    1,\n    makeBlob( '1' ),\n    true,\n    '1',\n    makeBytes( '1' ),\n    makeClob( '1' ),\n    date( '1994-02-23' ),\n    1.0,\n    1.0,\n    1.0,\n    1,\n    '1',\n    makeLongVarBytes( '1' ),\n    1.0,\n    1.0,\n    1,\n    time( '15:09:02' ),\n    timestamp( '1962-09-23 03:23:34.234' ),\n    '1',\n    makeVarBytes( '1' ),\n    makePrice( 'USD', cast( 9.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') )\n)\n");
        this.vetNumericCoercions(conn, "long", "bigint", "1");
        this.vetNumericCoercions(conn, "int", "int", "1");
        this.vetNumericCoercions(conn, "short", "smallint", "1");
        this.vetNumericCoercions(conn, "bigdecimal", "decimal", "1");
        this.vetNumericCoercions(conn, "bigdecimal", "numeric", "1");
        this.vetNumericCoercions(conn, "float", "real", "1.0");
        this.vetNumericCoercions(conn, "double", "double", "1.0");
        this.vetNumericCoercions(conn, "double", "float", "1.0");
        this.vetStringCoercions(conn, "String", "char(50)");
        this.vetStringCoercions(conn, "clob", "clob");
        this.vetStringCoercions(conn, "String", "varchar(50)");
        this.vetStringCoercions(conn, "String", "long varchar");
        this.vetTimeCoercions(conn, "date", "date");
        this.vetTimeCoercions(conn, "time", "time");
        this.vetTimeCoercions(conn, "timestamp", "timestamp");
        this.vetBinaryCoercions(conn, "byte[]", "char(1) for bit data");
        this.vetBinaryCoercions(conn, "byte[]", "varchar(10) for bit data");
        this.vetBinaryCoercions(conn, "byte[]", "long varchar for bit data");
        this.vetBooleanCoercions(conn, "boolean", "boolean");
        this.vetPriceCoercions(conn, "Price", "Price");
    }

    private void vetDatatype(Connection conn, String javatype, String sqltype, String arg1, String arg2, String arg3, String result1, String result2, String result3) throws Exception {
        this.createAddFunc(conn, sqltype);
        this.assertResults(conn, "values addFunc( '" + sqltype + "' )", new String[][]{{null}}, false);
        this.assertResults(conn, "values addFunc( '" + sqltype + "', " + arg1 + " )", new String[][]{{javatype + " " + sqltype + " " + result1}}, false);
        this.assertResults(conn, "values addFunc( '" + sqltype + "', " + arg1 + ", " + arg2 + " )", new String[][]{{javatype + " " + sqltype + " " + result2}}, false);
        this.assertResults(conn, "values addFunc( '" + sqltype + "', " + arg1 + ", " + arg2 + ", " + arg3 + " )", new String[][]{{javatype + " " + sqltype + " " + result3}}, false);
        this.dropAddFunc(conn);
    }

    private void createAddFunc(Connection conn, String sqltype) throws Exception {
        this.goodStatement(conn, "create function addFunc( seed varchar( 50 ), a " + sqltype + " ... ) returns varchar( 50 )\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.add'\n");
    }

    private void dropAddFunc(Connection conn) throws Exception {
        this.goodStatement(conn, "drop function addFunc");
    }

    private void vetNumericCoercions(Connection conn, String javatype, String sqltype, String expectedValue) throws Exception {
        this.createAddFunc(conn, sqltype);
        this.vetGoodCoercion(conn, javatype, sqltype, "bigint_col", expectedValue);
        this.vetGoodCoercion(conn, javatype, sqltype, "decimal_col", expectedValue);
        this.vetGoodCoercion(conn, javatype, sqltype, "double_col", expectedValue);
        this.vetGoodCoercion(conn, javatype, sqltype, "float_col", expectedValue);
        this.vetGoodCoercion(conn, javatype, sqltype, "integer_col", expectedValue);
        this.vetGoodCoercion(conn, javatype, sqltype, "numeric_col", expectedValue);
        this.vetGoodCoercion(conn, javatype, sqltype, "real_col", expectedValue);
        this.vetGoodCoercion(conn, javatype, sqltype, "smallint_col", expectedValue);
        this.vetBadCoercion(conn, sqltype, "blob_col", "42821");
        this.vetBadCoercion(conn, sqltype, "boolean_col", "42821");
        this.vetBadCoercion(conn, sqltype, "char_col", "42821");
        this.vetBadCoercion(conn, sqltype, "char_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "clob_col", "42821");
        this.vetBadCoercion(conn, sqltype, "date_col", "42821");
        this.vetBadCoercion(conn, sqltype, "long_varchar_col", "42821");
        this.vetBadCoercion(conn, sqltype, "long_varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "time_col", "42821");
        this.vetBadCoercion(conn, sqltype, "timestamp_col", "42821");
        this.vetBadCoercion(conn, sqltype, "varchar_col", "42821");
        this.vetBadCoercion(conn, sqltype, "price_col", "42821");
        this.dropAddFunc(conn);
    }

    private void vetGoodCoercion(Connection conn, String javatype, String sqltype, String colname, String expectedValue) throws Exception {
        this.assertResults(conn, "select addFunc( '" + sqltype + "', " + colname + " ) from all_types", new String[][]{{javatype + " " + sqltype + " " + expectedValue}}, true);
    }

    private void vetBadCoercion(Connection conn, String sqltype, String colname, String sqlstate) throws Exception {
        this.expectCompilationError(sqlstate, "select addFunc( '" + sqltype + "', " + colname + " ) from all_types");
    }

    private void vetStringCoercions(Connection conn, String javatype, String sqltype) throws Exception {
        this.createAddFunc(conn, sqltype);
        boolean isClob = javatype.equals("clob") || sqltype.equals("long varchar");
        this.vetGoodCoercion(conn, javatype, sqltype, "char_col", "1");
        this.vetGoodCoercion(conn, javatype, sqltype, "clob_col", "1");
        this.vetGoodCoercion(conn, javatype, sqltype, "long_varchar_col", "1");
        this.vetGoodCoercion(conn, javatype, sqltype, "varchar_col", "1");
        this.vetGoodCoercion(conn, javatype, sqltype, "boolean_col", "true");
        if (isClob) {
            this.vetBadCoercion(conn, sqltype, "date_col", "42821");
            this.vetBadCoercion(conn, sqltype, "time_col", "42821");
            this.vetBadCoercion(conn, sqltype, "timestamp_col", "42821");
        } else {
            this.vetGoodCoercion(conn, javatype, sqltype, "date_col", "1994-02-23");
            this.vetGoodCoercion(conn, javatype, sqltype, "time_col", "15:09:02");
            this.vetGoodCoercion(conn, javatype, sqltype, "timestamp_col", "1962-09-23 03:23:34.234");
        }
        this.vetBadCoercion(conn, sqltype, "bigint_col", "42821");
        this.vetBadCoercion(conn, sqltype, "decimal_col", "42821");
        this.vetBadCoercion(conn, sqltype, "double_col", "42821");
        this.vetBadCoercion(conn, sqltype, "float_col", "42821");
        this.vetBadCoercion(conn, sqltype, "integer_col", "42821");
        this.vetBadCoercion(conn, sqltype, "numeric_col", "42821");
        this.vetBadCoercion(conn, sqltype, "real_col", "42821");
        this.vetBadCoercion(conn, sqltype, "smallint_col", "42821");
        this.vetBadCoercion(conn, sqltype, "blob_col", "42821");
        this.vetBadCoercion(conn, sqltype, "char_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "long_varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "price_col", "42821");
        this.dropAddFunc(conn);
    }

    private void vetTimeCoercions(Connection conn, String javatype, String sqltype) throws Exception {
        this.createAddFunc(conn, sqltype);
        if (javatype.equals("date")) {
            this.vetGoodCoercion(conn, javatype, sqltype, "date_col", "1");
        } else {
            this.vetBadCoercion(conn, sqltype, "date_col", "42821");
        }
        if (javatype.equals("time")) {
            this.vetGoodCoercion(conn, javatype, sqltype, "time_col", "1");
        } else {
            this.vetBadCoercion(conn, sqltype, "time_col", "42821");
        }
        if (javatype.equals("timestamp")) {
            this.vetGoodCoercion(conn, javatype, sqltype, "timestamp_col", "1");
        } else {
            this.vetBadCoercion(conn, sqltype, "timestamp_col", "42821");
        }
        this.vetBadFormat(conn, sqltype, "char_col", BAD_TIME_FORMAT);
        this.vetBadFormat(conn, sqltype, "varchar_col", BAD_TIME_FORMAT);
        this.vetBadCoercion(conn, sqltype, "clob_col", "42821");
        this.vetBadCoercion(conn, sqltype, "long_varchar_col", "42821");
        this.vetBadCoercion(conn, sqltype, "boolean_col", "42821");
        this.vetBadCoercion(conn, sqltype, "bigint_col", "42821");
        this.vetBadCoercion(conn, sqltype, "decimal_col", "42821");
        this.vetBadCoercion(conn, sqltype, "double_col", "42821");
        this.vetBadCoercion(conn, sqltype, "float_col", "42821");
        this.vetBadCoercion(conn, sqltype, "integer_col", "42821");
        this.vetBadCoercion(conn, sqltype, "numeric_col", "42821");
        this.vetBadCoercion(conn, sqltype, "real_col", "42821");
        this.vetBadCoercion(conn, sqltype, "smallint_col", "42821");
        this.vetBadCoercion(conn, sqltype, "blob_col", "42821");
        this.vetBadCoercion(conn, sqltype, "char_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "long_varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "price_col", "42821");
        this.dropAddFunc(conn);
    }

    private void vetBadFormat(Connection conn, String sqltype, String colname, String sqlstate) throws Exception {
        this.expectExecutionError(conn, sqlstate, "select addFunc( '" + sqltype + "', " + colname + " ) from all_types");
    }

    private void vetBinaryCoercions(Connection conn, String javatype, String sqltype) throws Exception {
        this.createAddFunc(conn, sqltype);
        this.vetGoodCoercion(conn, javatype, sqltype, "char_for_bit_data_col", "1");
        this.vetGoodCoercion(conn, javatype, sqltype, "varchar_for_bit_data_col", "1");
        this.vetGoodCoercion(conn, javatype, sqltype, "long_varchar_for_bit_data_col", "1");
        this.vetBadCoercion(conn, sqltype, "char_col", "42821");
        this.vetBadCoercion(conn, sqltype, "varchar_col", "42821");
        this.vetBadCoercion(conn, sqltype, "clob_col", "42821");
        this.vetBadCoercion(conn, sqltype, "long_varchar_col", "42821");
        this.vetBadCoercion(conn, sqltype, "date_col", "42821");
        this.vetBadCoercion(conn, sqltype, "time_col", "42821");
        this.vetBadCoercion(conn, sqltype, "timestamp_col", "42821");
        this.vetBadCoercion(conn, sqltype, "boolean_col", "42821");
        this.vetBadCoercion(conn, sqltype, "bigint_col", "42821");
        this.vetBadCoercion(conn, sqltype, "decimal_col", "42821");
        this.vetBadCoercion(conn, sqltype, "double_col", "42821");
        this.vetBadCoercion(conn, sqltype, "float_col", "42821");
        this.vetBadCoercion(conn, sqltype, "integer_col", "42821");
        this.vetBadCoercion(conn, sqltype, "numeric_col", "42821");
        this.vetBadCoercion(conn, sqltype, "real_col", "42821");
        this.vetBadCoercion(conn, sqltype, "smallint_col", "42821");
        this.vetBadCoercion(conn, sqltype, "blob_col", "42821");
        this.vetBadCoercion(conn, sqltype, "price_col", "42821");
        this.dropAddFunc(conn);
    }

    private void vetBooleanCoercions(Connection conn, String javatype, String sqltype) throws Exception {
        this.createAddFunc(conn, sqltype);
        this.vetGoodCoercion(conn, javatype, sqltype, "boolean_col", "1");
        this.vetBadFormat(conn, sqltype, "char_col", BAD_BOOLEAN_FORMAT);
        this.vetBadFormat(conn, sqltype, "varchar_col", BAD_BOOLEAN_FORMAT);
        this.vetBadFormat(conn, sqltype, "clob_col", BAD_BOOLEAN_FORMAT);
        this.vetBadFormat(conn, sqltype, "long_varchar_col", BAD_BOOLEAN_FORMAT);
        this.vetBadCoercion(conn, sqltype, "char_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "long_varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "date_col", "42821");
        this.vetBadCoercion(conn, sqltype, "time_col", "42821");
        this.vetBadCoercion(conn, sqltype, "timestamp_col", "42821");
        this.vetBadCoercion(conn, sqltype, "bigint_col", "42821");
        this.vetBadCoercion(conn, sqltype, "decimal_col", "42821");
        this.vetBadCoercion(conn, sqltype, "double_col", "42821");
        this.vetBadCoercion(conn, sqltype, "float_col", "42821");
        this.vetBadCoercion(conn, sqltype, "integer_col", "42821");
        this.vetBadCoercion(conn, sqltype, "numeric_col", "42821");
        this.vetBadCoercion(conn, sqltype, "real_col", "42821");
        this.vetBadCoercion(conn, sqltype, "smallint_col", "42821");
        this.vetBadCoercion(conn, sqltype, "blob_col", "42821");
        this.vetBadCoercion(conn, sqltype, "price_col", "42821");
        this.dropAddFunc(conn);
    }

    private void vetPriceCoercions(Connection conn, String javatype, String sqltype) throws Exception {
        this.createAddFunc(conn, sqltype);
        this.vetGoodCoercion(conn, javatype, sqltype, "price_col", "1");
        this.vetBadCoercion(conn, sqltype, "char_col", "42821");
        this.vetBadCoercion(conn, sqltype, "varchar_col", "42821");
        this.vetBadCoercion(conn, sqltype, "clob_col", "42821");
        this.vetBadCoercion(conn, sqltype, "long_varchar_col", "42821");
        this.vetBadCoercion(conn, sqltype, "boolean_col", "42821");
        this.vetBadCoercion(conn, sqltype, "char_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "long_varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(conn, sqltype, "date_col", "42821");
        this.vetBadCoercion(conn, sqltype, "time_col", "42821");
        this.vetBadCoercion(conn, sqltype, "timestamp_col", "42821");
        this.vetBadCoercion(conn, sqltype, "bigint_col", "42821");
        this.vetBadCoercion(conn, sqltype, "decimal_col", "42821");
        this.vetBadCoercion(conn, sqltype, "double_col", "42821");
        this.vetBadCoercion(conn, sqltype, "float_col", "42821");
        this.vetBadCoercion(conn, sqltype, "integer_col", "42821");
        this.vetBadCoercion(conn, sqltype, "numeric_col", "42821");
        this.vetBadCoercion(conn, sqltype, "real_col", "42821");
        this.vetBadCoercion(conn, sqltype, "smallint_col", "42821");
        this.vetBadCoercion(conn, sqltype, "blob_col", "42821");
        this.dropAddFunc(conn);
    }

    public void test_06_tableFunctions() throws Exception {
        if (!this.vmSupportsVarargs()) {
            return;
        }
        Connection conn = this.getConnection();
        this.expectCompilationError(NEEDS_DJRS_STYLE, "create function tf_derby( rowValues varchar( 32672 ) )\nreturns table\n(\n    col1 varchar( 32672 )\n)\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.oneColumnRows'\n");
        this.expectCompilationError(NEEDS_DJRS_STYLE, "create function tf_derby_varargs( rowValues varchar( 32672 ) ... )\nreturns table\n(\n    col1 varchar( 32672 )\n)\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.oneColumnRows'\n");
        this.goodStatement(conn, "create function oneColumnRows( rowValues varchar( 32672 ) ... )\nreturns table\n(\n    col1 varchar( 32672 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.oneColumnRows'\n");
        this.assertResults(conn, "select * from table( oneColumnRows() ) s", new String[0][], false);
        this.assertResults(conn, "select * from table( oneColumnRows( 'one' ) ) s", new String[][]{{"one"}}, false);
        this.assertResults(conn, "select * from table( oneColumnRows( 'one', 'two' ) ) s", new String[][]{{"one"}, {"two"}}, false);
        this.assertResults(conn, "select * from table( oneColumnRows( 'one', 'two', 'three' ) ) s", new String[][]{{"one"}, {"two"}, {"three"}}, false);
    }

    public void test_07_6047() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create procedure PROC_6047( inout x int )\nparameter style java modifies sql data language java\nexternal name 'DUMMY.PROC_6047'\n");
        this.expectCompilationError(NEEDS_PARAMETER_MARKER, "call PROC_6047(1)");
    }

    private boolean vmSupportsVarargs() {
        return JDBC.vmSupportsJDBC3();
    }
}

