/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.InternalDriver;

public class LOBStoredProcedure {
    public static int CLOBCREATELOCATOR() throws SQLException {
        EngineLOB clob = (EngineLOB)((Object)LOBStoredProcedure.getEmbedConnection().createClob());
        return clob.getLocator();
    }

    public static void CLOBRELEASELOCATOR(int LOCATOR) throws SQLException {
        Clob clob = (Clob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(LOCATOR);
        if (clob == null) {
            return;
        }
        EmbedClob embedClob = (EmbedClob)clob;
        embedClob.free();
        LOBStoredProcedure.getEmbedConnection().removeLOBMapping(LOCATOR);
    }

    public static long CLOBGETPOSITIONFROMSTRING(int LOCATOR, String searchLiteral, long fromPosition) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).position(searchLiteral, fromPosition);
    }

    public static long CLOBGETPOSITIONFROMLOCATOR(int LOCATOR, int searchLocator, long fromPosition) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).position(LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(searchLocator), fromPosition);
    }

    public static long CLOBGETLENGTH(int LOCATOR) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).length();
    }

    public static String CLOBGETSUBSTRING(int LOCATOR, long pos, int len) throws SQLException {
        len = Math.min(len, 10890);
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).getSubString(pos, len);
    }

    public static void CLOBSETSTRING(int LOCATOR, long pos, int length, String str) throws SQLException {
        LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).setString(pos, str, 0, length);
    }

    public static void CLOBTRUNCATE(int LOCATOR, long length) throws SQLException {
        LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).truncate(length);
    }

    private static Clob getClobObjectCorrespondingtoLOCATOR(int LOCATOR) throws SQLException {
        Clob clob = (Clob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(LOCATOR);
        if (clob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        return clob;
    }

    public static int BLOBCREATELOCATOR() throws SQLException {
        EngineLOB blob = (EngineLOB)((Object)LOBStoredProcedure.getEmbedConnection().createBlob());
        return blob.getLocator();
    }

    public static void BLOBRELEASELOCATOR(int LOCATOR) throws SQLException {
        Blob blob = (Blob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(LOCATOR);
        if (blob == null) {
            return;
        }
        EmbedBlob embedBlob = (EmbedBlob)blob;
        embedBlob.free();
        LOBStoredProcedure.getEmbedConnection().removeLOBMapping(LOCATOR);
    }

    public static long BLOBGETPOSITIONFROMLOCATOR(int LOCATOR, int searchLocator, long pos) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).position(LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(searchLocator), pos);
    }

    public static long BLOBGETPOSITIONFROMBYTES(int LOCATOR, byte[] searchBytes, long pos) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).position(searchBytes, pos);
    }

    public static long BLOBGETLENGTH(int LOCATOR) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).length();
    }

    public static byte[] BLOBGETBYTES(int LOCATOR, long pos, int len) throws SQLException {
        len = Math.min(len, 32672);
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).getBytes(pos, len);
    }

    public static void BLOBSETBYTES(int LOCATOR, long pos, int len, byte[] replaceBytes) throws SQLException {
        LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).setBytes(pos, replaceBytes, 0, len);
    }

    public static void BLOBTRUNCATE(int LOCATOR, long length) throws SQLException {
        LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).truncate(length);
    }

    private static Blob getBlobObjectCorrespondingtoLOCATOR(int LOCATOR) throws SQLException {
        Blob blob = (Blob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(LOCATOR);
        if (blob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        return blob;
    }

    private static EmbedConnection getEmbedConnection() throws SQLException {
        EmbedConnection conn;
        InternalDriver id = InternalDriver.activeDriver();
        if (id != null && (conn = (EmbedConnection)id.connect("jdbc:default:connection", null, 0)) != null) {
            return conn;
        }
        throw Util.noCurrentConnection();
    }

    private static SQLException newSQLException(String messageId) {
        return Util.generateCsSQLException(messageId, new Object[0]);
    }
}

