/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ParameterMetaDataJdbc30Test
extends BaseJDBCTestCase {
    public ParameterMetaDataJdbc30Test(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("ParameterMetaDataJdbc30Test");
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("Empty ParameterMetaDataJDBC30. JSR169 does not support ParameterMetaData");
        }
        suite.addTest(ParameterMetaDataJdbc30Test.baseSuite("ParameterMetaDataJdbc30Test:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ParameterMetaDataJdbc30Test.baseSuite("ParameterMetaDataJdbc30Test:client")));
        return suite;
    }

    private static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(ParameterMetaDataJdbc30Test.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                Connection conn = this.getConnection();
                stmt.execute("CREATE PROCEDURE PMDD(IN pmdI_1 DECIMAL(5,3), IN pmdI_2 DECIMAL(4,2), INOUT pmdI_3 DECIMAL(9,0), OUT pmdI_4 DECIMAL(10,2)) language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyDecimal'");
                stmt.execute("create table t ( c char(5), iNoNull int not null, i int, de decimal, d date)");
                stmt.executeUpdate("create function RDB(P1 INT) RETURNS DECIMAL(10,2) language java external name 'org.apache.derbyTesting.functionTests.tests.lang.outparams30.returnsBigDecimal' parameter style java");
            }
        };
    }

    public void testCallableStatement() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create procedure dummyint( in a integer, in b integer, out c integer, inout d integer) language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyint' parameter style java");
        CallableStatement cs = this.prepareCall("CALL dummyint(?,?,?,?)");
        cs.setInt(1, 1);
        cs.setInt(2, 1);
        cs.registerOutParameter(3, 4);
        Integer x = 1;
        cs.setObject(4, (Object)x, 4);
        cs.registerOutParameter(4, 4);
        ParameterMetaData paramMetaData = cs.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)4, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(paramMetaData, parameterMetaDataArray0);
        cs.execute();
        cs = this.prepareCall("? = call RDB(?)");
        paramMetaData = cs.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)2, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray1 = new String[][]{{"PARAMETER_NULLABLE", "true", "31", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(paramMetaData, parameterMetaDataArray1);
        stmt.execute("drop procedure dummyint");
        stmt.close();
        cs.close();
    }

    public void testPreparedStatement() throws SQLException {
        PreparedStatement ps = this.prepareStatement("insert into t values(?, ?, ?, ?, ?)");
        ps.setNull(1, 1);
        ps.setInt(2, 1);
        ps.setNull(3, 4);
        ps.setBigDecimal(4, new BigDecimal("1"));
        ps.setNull(5, 91);
        ParameterMetaData paramMetaData = ps.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)5, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "false", "5", "0", "1", "CHAR", "java.lang.String", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "5", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "10", "0", "91", "DATE", "java.sql.Date", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(paramMetaData, parameterMetaDataArray0);
        ps.execute();
        ps = this.prepareStatement("select * from sys.systables where  CAST(tablename AS VARCHAR(128)) like ? and CAST(tableID AS CHAR(36)) like ?");
        ps.setString(1, "SYS%");
        ps.setString(2, "8000001%");
        paramMetaData = ps.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)2, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray1 = new String[][]{{"PARAMETER_NULLABLE", "false", "128", "0", "12", "VARCHAR", "java.lang.String", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "36", "0", "1", "CHAR", "java.lang.String", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(paramMetaData, parameterMetaDataArray1);
        ps.execute();
        ps.close();
    }

    public void testBooleanParameters() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create function booleanValue( b boolean )\nreturns varchar( 100 ) language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.BooleanValuesTest.booleanValue'\n");
        stmt.executeUpdate("create table t_boolean( b boolean )");
        stmt.close();
        PreparedStatement ps = this.prepareStatement("values( booleanValue( ? ) )");
        ParameterMetaData paramMetaData = ps.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)1, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "false", "1", "0", "16", "BOOLEAN", "java.lang.Boolean", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(paramMetaData, parameterMetaDataArray0);
        ps.close();
        ps = this.prepareStatement("insert into t_boolean values(?)");
        ps.setBoolean(1, true);
        paramMetaData = ps.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)1, (int)paramMetaData.getParameterCount());
        parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "false", "1", "0", "16", "BOOLEAN", "java.lang.Boolean", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(paramMetaData, parameterMetaDataArray0);
        ps.close();
    }

    public void testBooleanProcedureArgs() throws Exception {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create procedure booleanProc( in inarg boolean, out outarg boolean, inout inoutarg boolean )language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.booleanProc' parameter style java");
        CallableStatement cs = this.prepareCall("CALL booleanProc(?,?,?)");
        cs.registerOutParameter(2, 16);
        cs.registerOutParameter(3, 16);
        ParameterMetaData paramMetaData = cs.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)3, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "false", "1", "0", "16", "BOOLEAN", "java.lang.Boolean", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "1", "0", "16", "BOOLEAN", "java.lang.Boolean", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "false", "1", "0", "16", "BOOLEAN", "java.lang.Boolean", "PARAMETER_MODE_IN_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(paramMetaData, parameterMetaDataArray0);
        cs.setBoolean(1, true);
        cs.setBoolean(3, true);
        cs.execute();
        ParameterMetaDataJdbc30Test.assertEquals((boolean)true, (boolean)cs.getBoolean(2));
        ParameterMetaDataJdbc30Test.assertEquals((boolean)false, (boolean)cs.getBoolean(3));
        cs.setObject(1, (Object)Boolean.FALSE);
        cs.setObject(3, (Object)Boolean.FALSE);
        cs.execute();
        ParameterMetaDataJdbc30Test.assertEquals((boolean)false, (boolean)cs.getBoolean(2));
        ParameterMetaDataJdbc30Test.assertEquals((boolean)true, (boolean)cs.getBoolean(3));
        stmt.close();
        cs.close();
    }

    public void testLikeEscaleStatement() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select * from sys.systables where CAST(tablename AS VARCHAR(128)) like ? escape CAST(? AS VARCHAR(128))");
        ps.setString(1, "SYS%");
        ps.setString(2, "");
        ParameterMetaData paramMetaData = ps.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)2, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "false", "128", "0", "12", "VARCHAR", "java.lang.String", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "128", "0", "12", "VARCHAR", "java.lang.String", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(paramMetaData, parameterMetaDataArray0);
        try {
            ResultSet rs = ps.executeQuery();
            rs.next();
            ParameterMetaDataJdbc30Test.fail((String)"DERBY-44 failed (didn't get SQLSTATE 22019)");
            rs.close();
        }
        catch (SQLException e) {
            ParameterMetaDataJdbc30Test.assertSQLState("22019", e);
        }
        ps.close();
    }

    public void testExecuteStatementUsing() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select * from sys.systables where CAST(tablename AS VARCHAR(128)) like 'SYS%' and CAST(tableID AS VARCHAR(128)) like '8000001%'");
        ParameterMetaData paramMetaData = ps.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)0, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = null;
        ParameterMetaDataJdbc30Test.testParameterMetaData(paramMetaData, parameterMetaDataArray0);
        ps.execute();
        ps.close();
    }

    public void testSelectStatementUsingBoolean() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select * from t where 1=? for update");
        ParameterMetaData paramMetaData = ps.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)1, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(paramMetaData, parameterMetaDataArray0);
        ParameterMetaDataJdbc30Test.dumpParameterMetaDataNegative(paramMetaData);
        ps.setInt(1, 1);
        ps.execute();
        ps.close();
    }

    public void testSelectStatementUsingNoParameter() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select * from t");
        ParameterMetaData paramMetaData = ps.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)0, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = null;
        ParameterMetaDataJdbc30Test.testParameterMetaData(paramMetaData, parameterMetaDataArray0);
        ps.execute();
        ps.close();
    }

    public void testCallableStatementReturnedScale() throws SQLException {
        if (!ParameterMetaDataJdbc30Test.usingDerbyNetClient()) {
            Statement stmt = this.createStatement();
            stmt.executeUpdate("create procedure dummy_numeric_Proc(out a NUMERIC(30,15), out b NUMERIC(30,15)) language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummy_numeric_Proc'");
            CallableStatement cs = this.prepareCall("CALL dummy_numeric_Proc(?,?)");
            cs.registerOutParameter(1, 2);
            cs.registerOutParameter(2, 2, 15);
            cs.execute();
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)2, (int)cs.getParameterMetaData().getParameterCount());
            String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "true", "30", "15", "2", "NUMERIC", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "true", "30", "15", "2", "NUMERIC", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}};
            ParameterMetaDataJdbc30Test.testParameterMetaData(cs.getParameterMetaData(), parameterMetaDataArray0);
            cs.close();
        }
    }

    public void testMetatdataAfterProcRecompile() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create procedure dummyint( in a integer, in b integer, out c integer, inout d integer) language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyint' parameter style java");
        CallableStatement cs = this.prepareCall("CALL dummyint(?,?,?,?)");
        cs.registerOutParameter(3, 4);
        cs.registerOutParameter(4, 4);
        cs.setInt(1, 1);
        cs.setInt(2, 1);
        cs.setInt(4, 4);
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(cs.getParameterMetaData(), parameterMetaDataArray0);
        cs.execute();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected DUMMYINT alias returned", (int)11111, (int)cs.getInt(4));
        if (!ParameterMetaDataJdbc30Test.usingDerbyNetClient()) {
            stmt.executeUpdate("drop procedure dummyint");
            stmt.executeUpdate("create procedure dummyint(in a integer, in b integer, out c integer, inout d integer) language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyint2' parameter style java");
            cs.execute();
            String[][] parameterMetaDataArray1 = new String[][]{{"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN_OUT"}};
            ParameterMetaDataJdbc30Test.testParameterMetaData(cs.getParameterMetaData(), parameterMetaDataArray1);
            cs.setInt(4, 6);
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected DUMMYINT alias returned", (int)6, (int)cs.getInt(4));
            cs.execute();
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected DUMMYINT alias returned", (int)22222, (int)cs.getInt(4));
        }
        cs.close();
        stmt.execute("drop procedure dummyint");
    }

    public void testParameterMetadataWithINTParameters() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("CREATE PROCEDURE PMDI(IN pmdI_1 INTEGER, IN pmdI_2 INTEGER, INOUT pmdI_3 INTEGER, OUT pmdI_4 INTEGER) language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyint'");
        CallableStatement cs = this.prepareCall("CALL PMDI(?, ?, ?, ?)");
        cs.setInt(1, 1);
        cs.setInt(2, 1);
        Integer x = 1;
        cs.setObject(3, (Object)x, 4);
        cs.registerOutParameter(3, 4);
        cs.registerOutParameter(4, 4);
        ParameterMetaData paramMetaData = cs.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)4, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(cs.getParameterMetaData(), parameterMetaDataArray0);
        cs.close();
        stmt.execute("DROP PROCEDURE PMDI");
        stmt.close();
    }

    public void testParameterMetadataWithCHARParameters() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("CREATE PROCEDURE PMDC(IN pmdI_1 CHAR(10), IN pmdI_2 VARCHAR(25), INOUT pmdI_3 CHAR(19), OUT pmdI_4 VARCHAR(32)) language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyString'");
        CallableStatement cs = this.prepareCall("CALL PMDC(?, ?, ?, ?)");
        cs.setString(1, "TEST0");
        cs.setString(2, "TEST1");
        String x = new String("TEST");
        cs.setObject(3, (Object)x, 1);
        cs.registerOutParameter(3, 1);
        cs.registerOutParameter(4, 1);
        ParameterMetaData paramMetaData = cs.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)4, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "false", "10", "0", "1", "CHAR", "java.lang.String", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "25", "0", "12", "VARCHAR", "java.lang.String", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "19", "0", "1", "CHAR", "java.lang.String", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "false", "32", "0", "12", "VARCHAR", "java.lang.String", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(cs.getParameterMetaData(), parameterMetaDataArray0);
        cs.close();
        stmt.execute("DROP PROCEDURE PMDC");
        stmt.close();
    }

    public void testParameterMetadataWithTimestampParameters() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("CREATE PROCEDURE PMDT(IN pmdI_1 TIMESTAMP, INOUT pmdI_2 TIMESTAMP, OUT pmdI_3 TIMESTAMP) language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyString'");
        CallableStatement cs = this.prepareCall("CALL PMDT(?, ?, ?)");
        cs.setTimestamp(1, new Timestamp(0L));
        Timestamp x = new Timestamp(2L);
        cs.setObject(2, (Object)x, 1);
        cs.registerOutParameter(2, 93);
        cs.registerOutParameter(3, 93);
        ParameterMetaData paramMetaData = cs.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)3, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "false", "29", "9", "93", "TIMESTAMP", "java.sql.Timestamp", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "29", "9", "93", "TIMESTAMP", "java.sql.Timestamp", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "false", "29", "9", "93", "TIMESTAMP", "java.sql.Timestamp", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(cs.getParameterMetaData(), parameterMetaDataArray0);
        cs.close();
        stmt.execute("DROP PROCEDURE PMDT");
        stmt.close();
    }

    public void testParameterMetadataWithDECIMALParameters() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL PMDD(?, ?, ?, ?)");
        cs.setBigDecimal(1, new BigDecimal("1"));
        cs.setBigDecimal(2, new BigDecimal("1"));
        BigDecimal x = new BigDecimal(1.1);
        cs.setObject(3, (Object)x, 3);
        cs.registerOutParameter(3, 3);
        cs.registerOutParameter(4, 3);
        ParameterMetaData paramMetaData = cs.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)4, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "true", "5", "3", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "4", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "9", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(cs.getParameterMetaData(), parameterMetaDataArray0);
        cs.close();
    }

    public void testParameterMetadataWithLITERALParameters() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL PMDD(32.4, ?, ?, ?)");
        cs.setBigDecimal(1, new BigDecimal("1"));
        BigDecimal x = new BigDecimal(1.1);
        cs.setObject(2, (Object)x, 3);
        cs.registerOutParameter(2, 3);
        cs.registerOutParameter(3, 3);
        ParameterMetaData paramMetaData = cs.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)3, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray0 = new String[][]{{"PARAMETER_NULLABLE", "true", "4", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "9", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(cs.getParameterMetaData(), parameterMetaDataArray0);
        cs.close();
        cs = this.prepareCall("CALL PMDD(32.4, 47.9, ?, ?)");
        BigDecimal y = new BigDecimal(1.1);
        cs.setObject(1, (Object)y, 3);
        cs.registerOutParameter(1, 3);
        cs.registerOutParameter(2, 3);
        paramMetaData = cs.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)2, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray1 = new String[][]{{"PARAMETER_NULLABLE", "true", "9", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(cs.getParameterMetaData(), parameterMetaDataArray1);
        cs.close();
        cs = this.prepareCall("CALL PMDD(?, 38.2, ?, ?)");
        cs.setBigDecimal(1, new BigDecimal("1"));
        BigDecimal z = new BigDecimal(1.1);
        cs.setObject(2, (Object)z, 3);
        cs.registerOutParameter(2, 3);
        cs.registerOutParameter(3, 3);
        paramMetaData = cs.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)3, (int)paramMetaData.getParameterCount());
        String[][] parameterMetaDataArray2 = new String[][]{{"PARAMETER_NULLABLE", "true", "5", "3", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "9", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(cs.getParameterMetaData(), parameterMetaDataArray2);
        cs.close();
    }

    static String parameterIsNullableInStringForm(int nullabilityValue) {
        if (nullabilityValue == 0) {
            return "PARAMETER_NO_NULLS";
        }
        if (nullabilityValue == 1) {
            return "PARAMETER_NULLABLE";
        }
        if (nullabilityValue == 2) {
            return "PARAMETER_NULLABLE_UNKNOWN";
        }
        return "ERROR: donot recognize this parameter isNullable() value";
    }

    static String parameterModeInStringForm(int mode) {
        if (mode == 1) {
            return "PARAMETER_MODE_IN";
        }
        if (mode == 2) {
            return "PARAMETER_MODE_IN_OUT";
        }
        if (mode == 4) {
            return "PARAMETER_MODE_OUT";
        }
        if (mode == 0) {
            return "PARAMETER_MODE_UNKNOWN";
        }
        return "ERROR: donot recognize this parameter mode";
    }

    static void testParameterMetaData(ParameterMetaData paramMetaData, String[][] paramMetaDataArray) throws SQLException {
        int numParam = paramMetaData.getParameterCount();
        int j = 0;
        for (int i = 0; i < numParam; ++i) {
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter isNullable", (String)paramMetaDataArray[i][j++], (String)ParameterMetaDataJdbc30Test.parameterIsNullableInStringForm(paramMetaData.isNullable(i + 1)));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter isSigned", (boolean)Boolean.valueOf(paramMetaDataArray[i][j++]), (boolean)paramMetaData.isSigned(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getPrecision", (int)Integer.parseInt(paramMetaDataArray[i][j++]), (int)paramMetaData.getPrecision(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getScale", (int)Integer.parseInt(paramMetaDataArray[i][j++]), (int)paramMetaData.getScale(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getParameterType", (int)Integer.parseInt(paramMetaDataArray[i][j++]), (int)paramMetaData.getParameterType(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getParameterTypeName", (String)paramMetaDataArray[i][j++], (String)paramMetaData.getParameterTypeName(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getParameterClassName", (String)paramMetaDataArray[i][j++], (String)paramMetaData.getParameterClassName(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getParameterMode", (String)paramMetaDataArray[i][j++], (String)ParameterMetaDataJdbc30Test.parameterModeInStringForm(paramMetaData.getParameterMode(i + 1)));
            j = 0;
        }
    }

    static void dumpParameterMetaDataNegative(ParameterMetaData paramMetaData) throws SQLException {
        int numParam = paramMetaData.getParameterCount();
        String expectedSQLState = ParameterMetaDataJdbc30Test.usingEmbedded() ? "XCL13" : "XCL14";
        try {
            paramMetaData.isNullable(-1);
            ParameterMetaDataJdbc30Test.fail((String)"parameterMetaData.isNullable(-1) should have failed");
        }
        catch (SQLException se) {
            ParameterMetaDataJdbc30Test.assertSQLState(expectedSQLState, se);
        }
        try {
            paramMetaData.isNullable(0);
            ParameterMetaDataJdbc30Test.fail((String)"parameterMetaData.isNullable(0) should have failed");
        }
        catch (SQLException se) {
            ParameterMetaDataJdbc30Test.assertSQLState(expectedSQLState, se);
        }
        try {
            paramMetaData.isNullable(numParam + 1);
            ParameterMetaDataJdbc30Test.fail((String)("parameterMetaData.isNullable(" + (numParam + 1) + ") should have failed"));
        }
        catch (SQLException se) {
            ParameterMetaDataJdbc30Test.assertSQLState(expectedSQLState, se);
        }
    }

    public static void dummyint(int in_param, int in_param2, int[] in_param3, int[] in_param4) throws SQLException {
        in_param4[0] = 11111;
    }

    public static void dummyint2(int in_param, int in_param2, int[] in_param3, int[] in_param4) throws SQLException {
        in_param4[0] = 22222;
    }

    public static void dummy_numeric_Proc(BigDecimal[] max_param, BigDecimal[] min_param) throws SQLException {
    }

    public static void dummyString(String in_param, String in_param2, String[] in_param3, String[] in_param4) {
    }

    public static void dummyString(Timestamp in_param1, Timestamp[] inout_param2, Timestamp[] out_param3) {
    }

    public static void dummyDecimal(BigDecimal in_param, BigDecimal in_param2, BigDecimal[] in_param3, BigDecimal[] in_param4) {
    }

    public static void booleanProc(boolean inarg, boolean[] outarg, boolean[] inoutarg) {
        outarg[0] = inarg;
        inoutarg[0] = !inoutarg[0];
    }
}

