/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CallableTest
extends BaseJDBCTestCase {
    private static final String[] ROUTINES = new String[]{"CREATE PROCEDURE TWO_IN_ONE_OUT_PROC (IN P1 INT, IN P2 INT, OUT P3 INT) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".twoInOneOutProc'", "CREATE FUNCTION ONE_IN_ONE_OUT_FUNC (P1 INT) RETURNS INT NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".oneInOneOutFunc'", "CREATE FUNCTION NO_IN_ONE_OUT_FUNC() RETURNS INT NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".noInOneOutFunc'", "CREATE PROCEDURE SYSTEM_OUT_PRINTLN_PROC() NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".systemOutPrintlnProc'", "CREATE PROCEDURE UPDATE_LONGVARBINARY_PROC (P1 VARCHAR(10000) FOR BIT DATA) MODIFIES SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".updateLongVarbinaryProc'", "CREATE PROCEDURE NUMERIC_BOUNDARIES_PROC (OUT P1 DECIMAL(31,15), OUT P2 DECIMAL(31,15), OUT P3 DECIMAL(31,15)) READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".numericBoundariesProc'", "CREATE PROCEDURE NUMERIC_TYPES_IN_AND_OUT_PROC (IN P1 SMALLINT, IN P2 INT, IN P3 BIGINT, IN P4 REAL, IN P5 DOUBLE, IN P6 DECIMAL(6,3), OUT O1 SMALLINT, OUT O2 INT, OUT O3 BIGINT, OUT O4 REAL, OUT O5 DOUBLE, OUT O6 DECIMAL(6,3) ) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".manyTypesInAndOutProc'", "CREATE PROCEDURE NON_NUMERIC_TYPES_IN_AND_OUT_PROC (IN P1 DATE, IN P2 TIME, IN P3 TIMESTAMP, IN P4 VARCHAR(20) FOR BIT DATA, OUT O1 DATE, OUT O2 TIME, OUT O3 TIMESTAMP, OUT O4 VARCHAR(20) FOR BIT DATA) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".manyTypesInAndOutProc'", "CREATE PROCEDURE MANY_TYPES_INOUT_PROC (IN P1 SMALLINT, INOUT P2 SMALLINT, IN P3 INT, INOUT P4 INT, IN P5 BIGINT, INOUT P6 BIGINT, IN P7 REAL, INOUT P8 REAL, IN P9 DOUBLE, INOUT P10 DOUBLE, IN P11 TIME, INOUT P12 TIME) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".manyTypesInoutProc'", "CREATE PROCEDURE BIGDECIMAL_IN_AND_OUT_PROC (IN P1 DECIMAL(14,4), OUT P2 DECIMAL(14,4), IN P3 DECIMAL(14,4), OUT P4 DECIMAL(14,4), OUT P5 DECIMAL(14,4), OUT P6 DECIMAL(14,4), OUT P7 DECIMAL(14,4), OUT P8 DECIMAL(14,4), OUT P9 DECIMAL(14,4)) EXTERNAL NAME '" + CallableTest.class.getName() + ".bigDecimalInAndOutProc' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA", "CREATE PROCEDURE BATCH_UPDATE_PROC (P1 INT, P2 INT) MODIFIES SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".batchUpdateProc'"};
    private static final String[][] TABLES = new String[][]{{"LONGVARBINARY_TABLE", "CREATE TABLE LONGVARBINARY_TABLE (lvbc Long varchar for bit data)"}, {"NUMERIC_BOUNDARIES_TABLE", "CREATE TABLE NUMERIC_BOUNDARIES_TABLE (maxcol NUMERIC(31,15), mincol NUMERIC(15,15), nulcol NUMERIC)"}, {"BATCH_TABLE", "CREATE TABLE BATCH_TABLE (id int, tag varchar(32), idval int constraint idval_ck check (idval >= 0))"}};

    public CallableTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("CallableTest");
        suite.addTest(CallableTest.baseSuite("CallableTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(CallableTest.baseSuite("CallableTest:client")));
        suite.addTest(TestConfiguration.clientServerDecorator(TestConfiguration.connectionCPDecorator(CallableTest.baseSuite("CallableTest:logical"))));
        suite.addTest(TestConfiguration.connectionXADecorator(CallableTest.baseSuite("CallableTest:brokered")));
        return suite;
    }

    private static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(CallableTest.class);
        if (JDBC.vmSupportsJDBC3()) {
            suite.addTest((Test)new CallableTest("xtestUpdateLongBinaryProc"));
            suite.addTest((Test)new CallableTest("xtestBatchUpdate"));
            suite.addTest((Test)new CallableTest("xtestBatchUpdateError"));
            suite.addTest((Test)new CallableTest("xtestBigDecimalInAndOutProc"));
            suite.addTest((Test)new CallableTest("xtestNumericTypesInAndOutProc"));
            suite.addTest((Test)new CallableTest("xtestNumericBoundariesProc"));
        }
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                int i;
                for (i = 0; i < ROUTINES.length; ++i) {
                    s.execute(ROUTINES[i]);
                }
                for (i = 0; i < TABLES.length; ++i) {
                    s.execute(TABLES[i][1]);
                }
            }
        };
    }

    public void setUp() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement s = this.createStatement();
        for (int i = 0; i < TABLES.length; ++i) {
            s.execute("DELETE FROM " + TABLES[i][0]);
        }
        s.close();
        conn.commit();
    }

    public void testTwoInOneOutProc() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        cs.setInt(1, 6);
        cs.setInt(2, 9);
        cs.registerOutParameter(3, 4);
        cs.execute();
        CallableTest.assertEquals((String)"Sum of 6 and 9", (int)15, (int)cs.getInt(3));
    }

    public void testOneInOneOutFunc() throws SQLException {
        CallableStatement cs = this.prepareCall("? = call ONE_IN_ONE_OUT_FUNC (?)");
        cs.registerOutParameter(1, 4);
        cs.setInt(2, 6);
        cs.execute();
        CallableTest.assertEquals((String)"Square of 6 then plus 6", (int)42, (int)cs.getInt(1));
    }

    public void testNoInOneOutFunc() throws SQLException {
        CallableStatement cs = this.prepareCall("? = call NO_IN_ONE_OUT_FUNC()");
        cs.registerOutParameter(1, 4);
        cs.execute();
        CallableTest.assertEquals((String)"NO_IN_ONE_OUT_FUNC output value", (int)55, (int)cs.getInt(1));
    }

    public void testIsolationLevelChangeAfterFunctionCall() throws SQLException {
        CallableStatement cs = this.prepareCall("? = CALL NO_IN_ONE_OUT_FUNC()");
        cs.registerOutParameter(1, 4);
        cs.execute();
        CallableTest.assertEquals((int)55, (int)cs.getInt(1));
        this.getConnection().setTransactionIsolation(8);
    }

    public void norun_testSystemOutPrintlnProc() throws SQLException {
        CallableStatement cs = this.prepareCall("call SYSTEM_OUT_PRINTLN_PROC()");
        cs.execute();
        cs.close();
    }

    public void xtestNumericTypesInAndOutProc() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        cs.setShort(1, (short)3);
        cs.setInt(2, 4);
        cs.setLong(3, 5L);
        cs.setFloat(4, 6.0f);
        cs.setDouble(5, 7.0);
        cs.setBigDecimal(6, new BigDecimal("88.88"));
        cs.registerOutParameter(7, 5);
        cs.registerOutParameter(8, 4);
        cs.registerOutParameter(9, -5);
        cs.registerOutParameter(10, 7);
        cs.registerOutParameter(11, 8);
        cs.registerOutParameter(12, 3);
        cs.execute();
        CallableTest.assertEquals((String)"OUT short", (short)3, (short)cs.getShort(7));
        CallableTest.assertEquals((String)"OUT int", (int)4, (int)cs.getInt(8));
        CallableTest.assertEquals((String)"OUT long", (long)5L, (long)cs.getLong(9));
        CallableTest.assertEquals((String)"OUT float", (double)6.0, (double)cs.getFloat(10), (double)1.0E-4);
        CallableTest.assertEquals((String)"OUT double", (double)7.0, (double)cs.getDouble(11), (double)1.0E-4);
        this.assertDecimalSameValue("OUT decimal", "88.88", cs.getBigDecimal(12));
        cs.setObject(3, (Object)new BigDecimal("10"));
        cs.execute();
        CallableTest.assertEquals((String)"OUT long", (long)10L, (long)cs.getLong(9));
        cs.setObject(3, (Object)new BigInteger("11"));
        cs.execute();
        CallableTest.assertEquals((String)"OUT long", (long)11L, (long)cs.getLong(9));
    }

    public void testNonNumericTypesInAndOutProc() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        cs.setDate(1, Date.valueOf("2002-05-12"));
        cs.setTime(2, Time.valueOf("10:05:02"));
        cs.setTimestamp(3, Timestamp.valueOf("2002-05-12 10:05:02.000000000"));
        byte[] ba = new byte[]{1, 2};
        cs.setBytes(4, ba);
        cs.registerOutParameter(5, 91);
        cs.registerOutParameter(6, 92);
        cs.registerOutParameter(7, 93);
        cs.registerOutParameter(8, -3);
        cs.execute();
        CallableTest.assertEquals((String)"OUT date", (Object)Date.valueOf("2002-05-12"), (Object)cs.getDate(5));
        CallableTest.assertEquals("OUT time", Time.valueOf("10:05:02"), cs.getTime(6));
        CallableTest.assertEquals((String)"OUT timestamp", (Object)Timestamp.valueOf("2002-05-12 10:05:02.000000000"), (Object)cs.getTimestamp(7));
        CallableTest.assertTrue((boolean)Arrays.equals(ba, cs.getBytes(8)));
    }

    public void testTimeAndDateWithCalendar() throws SQLException {
        int i;
        Calendar[] cal1 = new Calendar[]{Calendar.getInstance(), Calendar.getInstance(TimeZone.getTimeZone("GMT")), Calendar.getInstance(TimeZone.getTimeZone("Europe/Oslo")), Calendar.getInstance(TimeZone.getTimeZone("Asia/Hong_Kong"))};
        Calendar[] cal2 = (Calendar[])cal1.clone();
        for (i = 0; i < cal2.length; ++i) {
            cal2[i] = (Calendar)cal2[i].clone();
        }
        for (i = 0; i < cal1.length; ++i) {
            for (int j = 0; j < cal2.length; ++j) {
                this.testTimeAndDateWithCalendar(cal1[i], cal2[j]);
            }
        }
    }

    private void testTimeAndDateWithCalendar(Calendar cal1, Calendar cal2) throws SQLException {
        CallableTest.println("Running " + this.getName() + "() with " + cal1.getTimeZone().getDisplayName() + " and " + cal2.getTimeZone().getDisplayName());
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        Date d = Date.valueOf("2010-04-14");
        Time t = Time.valueOf("12:23:24");
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        ts.setNanos(123456789);
        cs.setDate(1, d, cal1);
        cs.setTime(2, t, cal1);
        cs.setTimestamp(3, ts, cal1);
        cs.setNull(4, -3);
        cs.registerOutParameter(5, 91);
        cs.registerOutParameter(6, 92);
        cs.registerOutParameter(7, 93);
        cs.registerOutParameter(8, -3);
        cs.execute();
        this.assertSameDate(d, cal1, cs.getDate(5, cal2), cal2);
        this.assertSameTime(t, cal1, cs.getTime(6, cal2), cal2);
        this.vetTimestamp(ts, cal1, cs.getTimestamp(7, cal2), cal2);
    }

    private void assertSameDate(java.util.Date expected, Calendar cal1, java.util.Date actual, Calendar cal2) {
        cal1.clear();
        cal1.setTime(expected);
        int expectedYear = cal1.get(1);
        int expectedMonth = cal1.get(2);
        int expectedDay = cal1.get(5);
        cal2.clear();
        cal2.setTime(actual);
        CallableTest.assertEquals((String)"year", (int)expectedYear, (int)cal2.get(1));
        CallableTest.assertEquals((String)"month", (int)expectedMonth, (int)cal2.get(2));
        CallableTest.assertEquals((String)"day", (int)expectedDay, (int)cal2.get(5));
    }

    private void assertSameTime(java.util.Date expected, Calendar cal1, java.util.Date actual, Calendar cal2) {
        cal1.clear();
        cal1.setTime(expected);
        int expectedHour = cal1.get(11);
        int expectedMinute = cal1.get(12);
        int expectedSecond = cal1.get(13);
        cal2.clear();
        cal2.setTime(actual);
        CallableTest.assertEquals((String)"hour", (int)expectedHour, (int)cal2.get(11));
        CallableTest.assertEquals((String)"minute", (int)expectedMinute, (int)cal2.get(12));
        CallableTest.assertEquals((String)"second", (int)expectedSecond, (int)cal2.get(13));
    }

    private void vetTimestamp(Timestamp original, Calendar cal1, Timestamp returned, Calendar cal2) {
        cal1.clear();
        cal1.setTime(original);
        Calendar intermediate = Calendar.getInstance();
        intermediate.set(cal1.get(1), cal1.get(2), cal1.get(5), cal1.get(11), cal1.get(12), cal1.get(13));
        cal2.clear();
        cal2.set(intermediate.get(1), intermediate.get(2), intermediate.get(5), intermediate.get(11), intermediate.get(12), intermediate.get(13));
        Timestamp expected = new Timestamp(cal2.getTimeInMillis());
        expected.setNanos(original.getNanos());
        CallableTest.assertEquals((Object)expected, (Object)returned);
    }

    public void testManyTypesInoutProc() throws SQLException {
        CallableStatement cs = this.prepareCall("call MANY_TYPES_INOUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        cs.registerOutParameter(2, 5);
        cs.registerOutParameter(4, 4);
        cs.registerOutParameter(6, -5);
        cs.registerOutParameter(8, 7);
        cs.registerOutParameter(10, 8);
        cs.registerOutParameter(12, 92);
        cs.setShort(1, (short)6);
        cs.setShort(2, (short)9);
        cs.setInt(3, 6);
        cs.setInt(4, 9);
        cs.setLong(5, 99999L);
        cs.setLong(6, 88888888L);
        cs.setFloat(7, 6.123453f);
        cs.setFloat(8, 77777.0f);
        cs.setDouble(9, 6.123453);
        cs.setDouble(10, 8.888888888888012E12);
        cs.setTime(11, Time.valueOf("11:06:03"));
        cs.setTime(12, Time.valueOf("10:05:02"));
        cs.execute();
        CallableTest.assertEquals((String)"Short: Sum of 6 + 9", (int)15, (int)cs.getShort(2));
        CallableTest.assertEquals((String)"Int: Sum of 6 + 9", (int)15, (int)cs.getInt(4));
        CallableTest.assertEquals((String)"Long: Sum of 99999 + 88888888", (long)88988887L, (long)cs.getLong(6));
        CallableTest.assertEquals((String)"Float: Sum of 6.123453 and 77777", (double)77783.125, (double)cs.getFloat(8), (double)1.0E-6);
        CallableTest.assertEquals((String)"Double: Sum of Sum of 6.987654 and 8888888888888.01234", (double)8.888888888894135E12, (double)cs.getDouble(10), (double)1.0E-6);
        CallableTest.assertEquals("Time: changed to", Time.valueOf("11:06:03"), cs.getTime(12));
    }

    public void xtestUpdateLongBinaryProc() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("INSERT INTO LONGVARBINARY_TABLE VALUES(X'010305')");
        int bytearrsize = 50;
        byte[] bytearr = new byte[bytearrsize];
        String sbyteval = null;
        for (int count = 0; count < bytearrsize; ++count) {
            sbyteval = Integer.toString(count % 255);
            bytearr[count] = Byte.parseByte(sbyteval);
        }
        CallableStatement cstmt = this.prepareCall("CALL UPDATE_LONGVARBINARY_PROC(?)");
        cstmt.setObject(1, (Object)bytearr, -4);
        cstmt.executeUpdate();
        ResultSet rs = stmt.executeQuery("SELECT LVBC FROM LONGVARBINARY_TABLE");
        CallableTest.assertNotNull((String)"SELECT from LONGVARBINARY_TABLE", (Object)rs);
        while (rs.next()) {
            byte[] retvalue = (byte[])rs.getObject(1);
            CallableTest.assertTrue((boolean)Arrays.equals(bytearr, retvalue));
        }
    }

    public void xtestBatchUpdate() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("INSERT INTO BATCH_TABLE VALUES(1, 'STRING_1',10)");
        stmt.executeUpdate("INSERT INTO BATCH_TABLE VALUES(2, 'STRING_2',0)");
        stmt.executeUpdate("INSERT INTO BATCH_TABLE VALUES(3, 'STRING_3',0)");
        stmt.executeUpdate("INSERT INTO BATCH_TABLE VALUES(4, 'STRING_4a',0)");
        stmt.executeUpdate("INSERT INTO BATCH_TABLE VALUES(4, 'STRING_4b',0)");
        CallableStatement cstmt = this.prepareCall("CALL BATCH_UPDATE_PROC(?,?)");
        cstmt.setInt(1, 2);
        cstmt.setInt(2, 20);
        cstmt.addBatch();
        cstmt.setInt(1, 3);
        cstmt.setInt(2, 30);
        cstmt.addBatch();
        cstmt.setInt(1, 4);
        cstmt.setInt(2, 40);
        cstmt.addBatch();
        cstmt.setInt(1, 5);
        cstmt.setInt(2, 50);
        cstmt.addBatch();
        int[] updateCount = null;
        try {
            updateCount = cstmt.executeBatch();
            CallableTest.assertEquals((String)"updateCount length", (int)4, (int)updateCount.length);
            for (int i = 0; i < updateCount.length; ++i) {
                if (CallableTest.usingEmbedded()) {
                    CallableTest.assertEquals((String)"Batch updateCount", (int)0, (int)updateCount[0]);
                    continue;
                }
                if (!CallableTest.usingDerbyNetClient()) continue;
                CallableTest.assertEquals((String)"Batch updateCount", (int)-1, (int)updateCount[0]);
            }
        }
        catch (BatchUpdateException b) {
            CallableTest.assertSQLState("Unexpected SQL State", b.getSQLState(), b);
        }
        ResultSet rs = stmt.executeQuery("SELECT id, tag, idval FROM BATCH_TABLE order by id, tag");
        CallableTest.assertNotNull((String)"SELECT from BATCH_TABLE", (Object)rs);
        while (rs.next()) {
            CallableTest.assertEquals((String)rs.getString(2), (int)(rs.getInt(1) * 10), (int)rs.getInt(3));
        }
    }

    public void xtestBatchUpdateError() throws SQLException {
        Statement stmt;
        block14: {
            stmt = this.createStatement();
            stmt.executeUpdate("INSERT INTO BATCH_TABLE VALUES(1, 'STRING_1',0)");
            stmt.executeUpdate("INSERT INTO BATCH_TABLE VALUES(2, 'STRING_2',0)");
            stmt.executeUpdate("INSERT INTO BATCH_TABLE VALUES(3, 'STRING_3',0)");
            stmt.executeUpdate("INSERT INTO BATCH_TABLE VALUES(4, 'STRING_4',0)");
            CallableStatement cstmt = this.prepareCall("CALL BATCH_UPDATE_PROC(?,?)");
            cstmt.setInt(1, 1);
            cstmt.setInt(2, 10);
            cstmt.addBatch();
            cstmt.setInt(1, 2);
            cstmt.setInt(2, -5);
            cstmt.addBatch();
            cstmt.setInt(1, 3);
            cstmt.setInt(2, 30);
            cstmt.addBatch();
            cstmt.setInt(1, 4);
            cstmt.setInt(2, 40);
            cstmt.addBatch();
            int[] updateCount = null;
            try {
                updateCount = cstmt.executeBatch();
                CallableTest.fail((String)"Expected batchExecute to fail");
            }
            catch (BatchUpdateException b) {
                if (CallableTest.usingEmbedded()) {
                    CallableTest.assertSQLState("38000", b.getSQLState(), b);
                } else if (CallableTest.usingDerbyNetClient()) {
                    CallableTest.assertSQLState("XJ208", b.getSQLState(), b);
                }
                updateCount = b.getUpdateCounts();
                if (CallableTest.usingEmbedded()) {
                    CallableTest.assertEquals((String)"updateCount length", (int)1, (int)updateCount.length);
                    CallableTest.assertEquals((String)"Batch updateCount", (int)0, (int)updateCount[0]);
                }
                if (!CallableTest.usingDerbyNetClient()) break block14;
                CallableTest.assertEquals((String)"updateCount length", (int)4, (int)updateCount.length);
                for (int i = 0; i < updateCount.length; ++i) {
                    if (i == 1) {
                        CallableTest.assertEquals((String)"Batch updateCount", (int)-3, (int)updateCount[i]);
                        continue;
                    }
                    CallableTest.assertEquals((String)"Batch updateCount", (int)-1, (int)updateCount[i]);
                }
            }
        }
        ResultSet rs = stmt.executeQuery("SELECT id, tag, idval FROM BATCH_TABLE order by id, tag");
        CallableTest.assertNotNull((String)"SELECT from BATCH_TABLE", (Object)rs);
        block7: while (rs.next()) {
            switch (rs.getInt(1)) {
                case 1: {
                    CallableTest.assertEquals((String)rs.getString(2), (int)10, (int)rs.getInt(3));
                    continue block7;
                }
                case 2: {
                    CallableTest.assertEquals((String)rs.getString(2), (int)0, (int)rs.getInt(3));
                    continue block7;
                }
            }
            if (CallableTest.usingEmbedded()) {
                CallableTest.assertEquals((String)rs.getString(2), (int)0, (int)rs.getInt(3));
                continue;
            }
            if (!CallableTest.usingDerbyNetClient()) continue;
            CallableTest.assertEquals((String)rs.getString(2), (int)(rs.getInt(1) * 10), (int)rs.getInt(3));
        }
    }

    public void xtestNumericBoundariesProc() throws SQLException {
        String SqlStatement = "insert into NUMERIC_BOUNDARIES_TABLE values(999999999999999, 0.000000000000001, null)";
        Statement stmt = this.createStatement();
        stmt.executeUpdate(SqlStatement);
        CallableStatement cstmt = this.prepareCall("CALL NUMERIC_BOUNDARIES_PROC(?,?,?)");
        cstmt.registerOutParameter(1, 2, 15);
        cstmt.registerOutParameter(2, 2, 15);
        cstmt.registerOutParameter(3, 2, 15);
        cstmt.execute();
        this.assertDecimalSameValue("OUT 1", "999999999999999.000000000000000", cstmt.getBigDecimal(1));
        this.assertDecimalSameValue("OUT 2", "0.000000000000001", cstmt.getBigDecimal(2));
        CallableTest.assertNull((String)"Expected OUT 3 to be null", (Object)cstmt.getBigDecimal(3));
    }

    public void xtestBigDecimalInAndOutProc() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL BIGDECIMAL_IN_AND_OUT_PROC (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        cs.setBigDecimal(1, new BigDecimal("33.333"));
        cs.registerOutParameter(2, 3);
        cs.setBigDecimal(3, new BigDecimal("-999.999999"));
        cs.registerOutParameter(4, 3);
        cs.registerOutParameter(5, 3);
        cs.registerOutParameter(6, 3);
        cs.registerOutParameter(7, 3);
        cs.registerOutParameter(8, 3);
        cs.registerOutParameter(9, 3);
        cs.execute();
        this.assertDecimalSameValue("OUT 2", "33.3330", cs.getBigDecimal(2));
        this.assertDecimalSameValue("OUT 4", "-33332.9966", cs.getBigDecimal(4));
        this.assertDecimalSameValue("OUT 5", "-966.6669", cs.getBigDecimal(5));
        this.assertDecimalSameValue("OUT 6", "0.0000", cs.getBigDecimal(6));
        this.assertDecimalSameValue("OUT 7", "0.0000", cs.getBigDecimal(7));
        this.assertDecimalSameValue("OUT 8", "99999999.0000", cs.getBigDecimal(8));
        this.assertDecimalSameValue("OUT 9", "-99999999.0000", cs.getBigDecimal(9));
    }

    public void assertDecimalSameValue(String message, String expected_s, BigDecimal actual) {
        BigDecimal expected = new BigDecimal(expected_s);
        CallableTest.assertTrue((String)(message + " expected:<" + expected + "> but was:<" + actual.toString() + ">"), (expected.compareTo(actual) == 0 ? 1 : 0) != 0);
    }

    public static int oneInOneOutFunc(int p1) {
        return p1 * p1 + p1;
    }

    public static void twoInOneOutProc(int p1, int p2, int[] p3) {
        p3[0] = p1 + p2;
    }

    public static int noInOneOutFunc() {
        return 55;
    }

    public static void systemOutPrintlnProc() {
        System.out.println("I'm doing something here...");
    }

    public static void updateLongVarbinaryProc(byte[] in_param) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("update LONGVARBINARY_TABLE set lvbc=?");
        ps.setBytes(1, in_param);
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public static void numericBoundariesProc(BigDecimal[] param1, BigDecimal[] param2, BigDecimal[] param3) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select maxcol, mincol, nulcol from NUMERIC_BOUNDARIES_TABLE");
        if (!rs.next()) {
            throw new SQLException("Data not found");
        }
        param1[0] = rs.getBigDecimal(1);
        param2[0] = rs.getBigDecimal(2);
        param3[0] = rs.getBigDecimal(3);
        rs.close();
        stmt.close();
        conn.close();
    }

    public static void bigDecimalInAndOutProc(BigDecimal bd1, BigDecimal[] bdr1, BigDecimal bd2, BigDecimal[] bdr2, BigDecimal[] bdr3, BigDecimal[] bdr4, BigDecimal[] bdr5, BigDecimal[] bdr6, BigDecimal[] bdr7) {
        bdr1[0] = bd1;
        bdr2[0] = bd1.multiply(bd2);
        bdr3[0] = bd1.add(bd2);
        bdr4[0] = new BigDecimal(".00000");
        bdr5[0] = new BigDecimal("-.00000");
        bdr6[0] = new BigDecimal("99999999.");
        bdr7[0] = new BigDecimal("-99999999.");
    }

    public static void manyTypesInAndOutProc(short s, int i, long l, float f, double d, BigDecimal bd, short[] sr, int[] ir, long[] lr, float[] fr, double[] dr, BigDecimal[] bdr) {
        sr[0] = s;
        ir[0] = i;
        lr[0] = l;
        fr[0] = f;
        dr[0] = d;
        bdr[0] = bd;
    }

    public static void manyTypesInAndOutProc(Date dt, Time t, Timestamp ts, byte[] ba, Date[] dtr, Time[] tr, Timestamp[] tsr, byte[][] bar) {
        dtr[0] = dt;
        tr[0] = t;
        tsr[0] = ts;
        bar[0] = ba;
    }

    public static void manyTypesInoutProc(short s1, short[] s2, int p1, int[] p2, long l1, long[] l2, float f1, float[] f2, double d1, double[] d2, Time t1, Time[] t2) {
        p2[0] = p1 + p2[0];
        s2[0] = (short)(s1 + s2[0]);
        l2[0] = l1 + l2[0];
        f2[0] = f1 + f2[0];
        d2[0] = d1 + d2[0];
        t2[0] = t1;
    }

    public static void batchUpdateProc(int id, int id_newval) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("update BATCH_TABLE set idval=? where id=?");
        ps.setInt(1, id_newval);
        ps.setInt(2, id);
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public void testsetURL() throws SQLException, MalformedURLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            URL domain = new URL("http://www.apache.org");
            cs.setURL("URL", domain);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetNull() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setNull("P1", 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetBoolean() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setBoolean("P1", true);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetByte() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?, ?,?,?,?,?,?)");
        try {
            cs.setByte("P1", (byte)1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetShort() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?, ?,?,?,?,?,?)");
        try {
            cs.setShort("P1", (short)1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetInt() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setInt("P1", 6);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetLong() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setLong("P1", 6000L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetFloat() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?, ?,?,?,?,?,?)");
        try {
            cs.setFloat("P1", 6.123453f);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetDouble() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?, ?,?,?,?,?,?)");
        try {
            cs.setDouble("P5", 6.123453);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetDecimal() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?, ?,?,?,?,?,?)");
        try {
            cs.setBigDecimal("P6", new BigDecimal("33.333"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetString() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setString("P4", "test");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetBytes() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setBytes("P1", new byte[]{-32, 79, -48, 32, -22, 58, 105, 16, -94, -40, 8, 0, 43, 48, 48, -99});
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetDate() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            cs.setDate("P1", Date.valueOf("2013-07-13"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetTime() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            cs.setTime("P2", Time.valueOf("10:05:02"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetTimestamp() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            cs.setTimestamp("P3", Timestamp.valueOf("2002-05-12 10:05:02.000000000"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetAsciiStream() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            cs.setAsciiStream("PAscii", (InputStream)is, 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetBinaryStream() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            cs.setBinaryStream("PBinary", (InputStream)is, 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetObject() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setObject("P1", (Object)"Object", 1, 2);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetObject1() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setObject("P1", (Object)"Object", 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetObject2() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setObject("P1", (Object)"Object");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetCharacterStream() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            cs.setCharacterStream("P1", (Reader)br, 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetDate1() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            cs.setDate("P1", Date.valueOf("2013-07-13"), Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetTime1() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            cs.setTime("P2", Time.valueOf("10:05:02"), Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetTimestamp1() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            cs.setTimestamp("P3", Timestamp.valueOf("2002-05-12 10:05:02.000000000"), Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetNull1() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setNull("P1", 1, "Null");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetString() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            cs.getString("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetBoolean() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            cs.getBoolean("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetByte() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            cs.getByte("P1");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetShort() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            cs.getShort("P1");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetInt() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            cs.getInt("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetLong() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            cs.getLong("P3");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetFloat() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            cs.getFloat("P5");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetDouble() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            cs.getDouble("P5");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetBytes() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            cs.getBytes("P1");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetDate() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            cs.getDate("P1");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetTime() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            cs.getTime("P2");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetTimestamp() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            cs.getTimestamp("P3");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetObject() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            cs.getObject("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetBigDecimal() throws SQLException {
        CallableStatement cs = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?, ?,?)");
        try {
            cs.getBigDecimal("P6");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetObject1() throws SQLException, MalformedURLException {
        HashMap format = new HashMap();
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.getObject("P1", format);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetRef() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            cs.getRef("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetBlob() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            cs.getBlob("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetClob1() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            cs.getClob("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetArray() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            cs.getArray("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetDate1() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            cs.getDate("P1", Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetTime1() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            cs.getTime("P2", Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetTimestamp1() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            cs.getTimestamp("P3", Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetURL() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?, ?, ?,?)");
        try {
            cs.getURL("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testregisterOutParameter() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.registerOutParameter("String", 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testregisterOutParameter1() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.registerOutParameter("String", 1, 2);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testregisterOutParameter2() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.registerOutParameter("String", 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testregisterOutParameter3() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.registerOutParameter("String1", 1, "String2");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetCharacterStream() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            cs.getCharacterStream("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetNCharacterStream() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?, ?, ?,?,?, ?, ?,?)");
        try {
            cs.getNCharacterStream("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetNString() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?, ?, ?,?,?, ?, ?,?)");
        try {
            cs.getNString("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetRowId() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?, ?, ?,?,?, ?, ?,?)");
        try {
            cs.getRowId("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetRowId() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setRowId("P1", cs.getRowId("P2"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetBlob() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setBlob("P1", cs.getBlob("P2"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetClob() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setClob("P1", cs.getClob("P2"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetNString() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setNString("P1", "value");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetNCharacterStream1() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            cs.setNCharacterStream("P1", (Reader)br);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetNCharacterStream2() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            cs.setNCharacterStream("P1", (Reader)br, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetNClob() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setNClob("P1", cs.getNClob(1));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetClob1() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            cs.setNClob("P1", (Reader)br);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetClob2() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            cs.setNClob("P1", (Reader)br, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetClobInputStream1() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            cs.setBlob("P1", (InputStream)is);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetClobInputStream2() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            cs.setBlob("P1", (InputStream)is, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetNClobInput1() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            cs.setNClob("P1", (Reader)br);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetNClobInput2() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            cs.setNClob("P1", (Reader)br, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetNClob() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            cs.getNClob("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetSQLXML() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            cs.setSQLXML("P1", cs.getSQLXML(1));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testgetSQLXML() throws SQLException {
        CallableStatement cs = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            cs.getSQLXML("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetAsciiStream1() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            cs.setAsciiStream("P1", (InputStream)is);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetAsciiStream2() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            cs.setAsciiStream("P1", (InputStream)is, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetBinaryStream1() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            cs.setBinaryStream("P1", (InputStream)is);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetBinaryStream2() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            cs.setBinaryStream("P1", (InputStream)is, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetCharacterStream1() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?,?,?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            cs.setCharacterStream("P1", (Reader)br);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }

    public void testsetCharacterStream2() throws SQLException {
        CallableStatement cs = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?,?,?)");
        try {
            String str = "This is a String";
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            cs.setCharacterStream("P1", (Reader)br, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException e) {
            CallableTest.assertSQLState("0A000", e);
        }
    }
}

