/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.UpdatableThetaSketch;

abstract class HeapUpdateSketch
extends UpdatableThetaSketch {
    final int lgNomLongs_;
    private final float p_;
    private final ResizeFactor rf_;

    HeapUpdateSketch(int lgNomLongs, long seed, float p, ResizeFactor rf) {
        super(seed);
        this.lgNomLongs_ = Math.max(lgNomLongs, 4);
        this.p_ = p;
        this.rf_ = rf;
    }

    @Override
    public int getCurrentBytes() {
        int preLongs = this.getCurrentPreambleLongs();
        int dataLongs = this.getCurrentDataLongs();
        return preLongs + dataLongs << 3;
    }

    @Override
    public final int getLgNomLongs() {
        return this.lgNomLongs_;
    }

    @Override
    float getP() {
        return this.p_;
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return this.rf_;
    }

    @Override
    short getSeedHash() {
        return Util.computeSeedHash(this.getSeed());
    }

    byte[] toByteArray(int preLongs, byte familyID) {
        if (this.isDirty()) {
            this.rebuild();
        }
        CompactOperations.checkIllegalCurCountAndEmpty(this.isEmpty(), this.getRetainedEntries(true));
        int preBytes = preLongs << 3 & 0x3F;
        int dataBytes = this.getCurrentDataLongs() << 3;
        byte[] byteArrOut = new byte[preBytes + dataBytes];
        MemorySegment segOut = MemorySegment.ofArray(byteArrOut);
        int lgRf = this.getResizeFactor().lg() & 3;
        PreambleUtil.insertPreLongs(segOut, preLongs);
        PreambleUtil.insertLgResizeFactor(segOut, lgRf);
        PreambleUtil.insertSerVer(segOut, 3);
        PreambleUtil.insertFamilyID(segOut, familyID);
        PreambleUtil.insertLgNomLongs(segOut, this.getLgNomLongs());
        PreambleUtil.insertLgArrLongs(segOut, this.getLgArrLongs());
        PreambleUtil.insertSeedHash(segOut, this.getSeedHash());
        PreambleUtil.insertCurCount(segOut, this.getRetainedEntries(true));
        PreambleUtil.insertP(segOut, this.getP());
        long thetaLong = CompactOperations.correctThetaOnCompact(this.isEmpty(), this.getRetainedEntries(true), this.getThetaLong());
        PreambleUtil.insertThetaLong(segOut, thetaLong);
        int flags = this.isEmpty() ? 4 : 0;
        PreambleUtil.insertFlags(segOut, flags);
        int arrLongs = 1 << this.getLgArrLongs();
        long[] cache = this.getCache();
        MemorySegment.copy(cache, 0, segOut, ValueLayout.JAVA_LONG_UNALIGNED, (long)preBytes, arrLongs);
        return byteArrOut;
    }
}

