/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SizeAndModeTransitions {
    static String hfmt = "%6s %7s %4s %10s %5s %10s %10s %10s %10s %10s %14s\n";
    static String dfmt = "%6s %7s %4d %,10d %5s %,10d %,10d %,10d %,10d %,10d %,14.3f\n";
    static String[] hdr = new String[]{"Type", "Store", "LgK", "N", "Mode", "ActCBytes", "CmpBytes", "ActUBytes", "UpdBytes", "MaxBytes", "Estimate"};

    @Test
    public void checkHLL8with_withoutSeg() {
        this.checkHLL8Heap(true);
        this.checkHLL8Heap(false);
    }

    private void checkHLL8Heap(boolean withSeg) {
        HllSketch sk;
        TgtHllType tgtHllType = TgtHllType.HLL_8;
        int lgK = 10;
        int N = 97;
        SizeAndModeTransitions.printf(hfmt, hdr);
        MemorySegment wseg = null;
        if (withSeg) {
            int maxBytes = HllSketch.getMaxUpdatableSerializationBytes((int)10, (TgtHllType)tgtHllType);
            wseg = MemorySegment.ofArray(new byte[maxBytes]);
            sk = new HllSketch(10, tgtHllType, wseg);
        } else {
            sk = new HllSketch(10, tgtHllType);
        }
        String store = withSeg ? "MemorySegment" : "Heap";
        for (int i = 1; i <= 97; ++i) {
            sk.update((long)i);
            if (i == 7) {
                SizeAndModeTransitions.checkAtN(sk, tgtHllType, store, 10, i, "LIST", 36, 40, 1064);
            }
            if (i == 8) {
                SizeAndModeTransitions.checkAtN(sk, tgtHllType, store, 10, i, "SET", 44, 140, 1064);
            }
            if (i == 24) {
                SizeAndModeTransitions.checkAtN(sk, tgtHllType, store, 10, i, "SET", 108, 140, 1064);
            }
            if (i == 25) {
                SizeAndModeTransitions.checkAtN(sk, tgtHllType, store, 10, i, "SET", 112, 268, 1064);
            }
            if (i == 48) {
                SizeAndModeTransitions.checkAtN(sk, tgtHllType, store, 10, i, "SET", 204, 268, 1064);
            }
            if (i == 49) {
                SizeAndModeTransitions.checkAtN(sk, tgtHllType, store, 10, i, "SET", 208, 524, 1064);
            }
            if (i == 96) {
                SizeAndModeTransitions.checkAtN(sk, tgtHllType, store, 10, i, "SET", 396, 524, 1064);
            }
            if (i != 97) continue;
            SizeAndModeTransitions.checkAtN(sk, tgtHllType, store, 10, i, "HLL", 1064, 1064, 1064);
        }
        SizeAndModeTransitions.println("");
    }

    private static void checkAtN(HllSketch sk, TgtHllType tgtHllType, String store, int lgK, int n, String trueMode, int cmpTrueBytes, int updTrueBytes, int maxTrueBytes) {
        int maxBytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)tgtHllType);
        String type = tgtHllType.toString();
        int cmpBytes = sk.getCompactSerializationBytes();
        int updBytes = sk.getUpdatableSerializationBytes();
        byte[] actCBytes = sk.toCompactByteArray();
        byte[] actUBytes = sk.toUpdatableByteArray();
        String mode = sk.getCurMode().toString();
        double est = sk.getEstimate();
        SizeAndModeTransitions.printf(dfmt, type, store, lgK, n, mode, actCBytes.length, cmpBytes, actUBytes.length, updBytes, maxBytes, est);
        Assert.assertEquals((String)mode, (String)trueMode);
        Assert.assertEquals((int)cmpBytes, (int)actCBytes.length);
        Assert.assertEquals((int)cmpBytes, (int)cmpTrueBytes);
        Assert.assertEquals((int)updBytes, (int)actUBytes.length);
        Assert.assertEquals((int)updBytes, (int)updTrueBytes);
        Assert.assertEquals((int)maxBytes, (int)maxTrueBytes);
    }

    @Test
    public void printlnTest() {
        SizeAndModeTransitions.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    static void printf(String fmt, Object ... args) {
    }
}

