<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Governance

## Overview

DataFusion is part of the [Apache Software Foundation] and is governed following
the [Apache Way] and [project management guidelines], [independently of
commercial interests].

[apache software foundation]: https://www.apache.org/
[apache way]: https://www.apache.org/theapacheway/
[project management guidelines]: https://www.apache.org/foundation/how-it-works.html#management
[independently of commercial interests]: https://community.apache.org/projectIndependence.html

As much as practicable, we strive to make decisions by consensus, and anyone in
the community is encouraged to propose ideas, start discussions, and contribute
to the project.

## People

DataFusion is currently governed by the following individuals

<!--

The following table can be updated by running the following script:

docs/scripts/update_committer_list.py

Notes:

* The script only updates the Name and Apache ID columns. The rest of the data
  is manually provided.

-->

<!-- Begin Auto-Generated Committer List -->

| Name                    | Apache ID        | github                                                  | Affiliation    | Role      |
| ----------------------- | ---------------- | ------------------------------------------------------- | -------------- | --------- |
| Andrew Lamb             | alamb            | [alamb](https://github.com/alamb)                       | InfluxData     | PMC Chair |
| Andrew Grove            | agrove           | [andygrove](https://github.com/andygrove)               | Apple          | PMC       |
| Mustafa Akur            | akurmustafa      | [akurmustafa](https://github.com/akurmustafa)           | OHSU           | PMC       |
| Berkay Şahin            | berkay           | [berkaysynnada](https://github.com/berkaysynnada)       | Synnada        | PMC       |
| Oleksandr Voievodin     | comphead         | [comphead](https://github.com/comphead)                 | Apple          | PMC       |
| Daniël Heres            | dheres           | [Dandandan](https://github.com/Dandandan)               |                | PMC       |
| QP Hou                  | houqp            | [houqp](https://github.com/houqp)                       |                | PMC       |
| Jie Wen                 | jakevin          | [jackwener](https://github.com/jackwener)               |                | PMC       |
| Jay Zhan                | jayzhan          | [jayzhan211](https://github.com/jayzhan211)             |                | PMC       |
| Jeffrey Vo              | jeffreyvo        | [Jefffrey](https://github.com/Jefffrey)                 |                | PMC       |
| Jonah Gao               | jonah            | [jonahgao](https://github.com/jonahgao)                 |                | PMC       |
| Kun Liu                 | liukun           | [liukun4515](https://github.com/liukun4515)             |                | PMC       |
| Mehmet Ozan Kabak       | ozankabak        | [ozankabak](https://github.com/ozankabak)               | Synnada, Inc   | PMC       |
| Tim Saucer              | timsaucer        | [timsaucer](https://github.com/timsaucer)               |                | PMC       |
| L. C. Hsieh             | viirya           | [viirya](https://github.com/viirya)                     | Databricks     | PMC       |
| Ruihang Xia             | wayne            | [waynexia](https://github.com/waynexia)                 | Greptime       | PMC       |
| Wes McKinney            | wesm             | [wesm](https://github.com/wesm)                         | Posit          | PMC       |
| Will Jones              | wjones127        | [wjones127](https://github.com/wjones127)               | LanceDB        | PMC       |
| Xudong Wang             | xudong963        | [xudong963](https://github.com/xudong963)               | Polygon.io     | PMC       |
| Yongting You            | ytyou            | [2010YOUY01](https://github.com/2010YOUY01)             | Independent    | PMC       |
| Adrian Garcia Badaracco | adriangb         | [adriangb](https://github.com/adriangb)                 | Pydantic       | Committer |
| Brent Gardner           | avantgardner     | [avantgardnerio](https://github.com/avantgardnerio)     | Coralogix      | Committer |
| Dmitrii Blaginin        | blaginin         | [blaginin](https://github.com/blaginin)                 | SpiralDB       | Committer |
| Piotr Findeisen         | findepi          | [findepi](https://github.com/findepi)                   | dbt Labs       | Committer |
| Gabriel Musat           | gabotechs        | [gabotechs](https://github.com/gabotechs)               | DataDog        | Committer |
| Jax Liu                 | goldmedal        | [goldmedal](https://github.com/goldmedal)               | Canner         | Committer |
| Huaxin Gao              | huaxingao        | [huaxingao](https://github.com/huaxingao)               |                | Committer |
| Ifeanyi Ubah            | iffyio           | [iffyio](https://github.com/iffyio)                     | Validio        | Committer |
| Liu Jiayu               | jiayuliu         | [jimexist](https://github.com/jimexist)                 |                | Committer |
| Ruiqiu Cao              | kamille          | [Rachelint](https://github.com/Rachelint)               | Tencent        | Committer |
| Kazuyuki Tanimura       | kazuyukitanimura | [kazuyukitanimura](https://github.com/kazuyukitanimura) |                | Committer |
| Eduard Karacharov       | korowa           | [korowa](https://github.com/korowa)                     |                | Committer |
| Siew Kam Onn            | kosiew           | [kosiew](https://github.com/kosiew)                     |                | Committer |
| Lewis Zhang             | linwei           | [lewiszlw](https://github.com/lewiszlw)                 | diit.cn        | Committer |
| Matt Butrovich          | mbutrovich       | [mbutrovich](https://github.com/mbutrovich)             | Apple          | Committer |
| Metehan Yildirim        | mete             | [metegenez](https://github.com/metegenez)               |                | Committer |
| Marko Milenković        | milenkovicm      | [milenkovicm](https://github.com/milenkovicm)           |                | Committer |
| Wang Mingming           | mingmwang        | [mingmwang](https://github.com/mingmwang)               |                | Committer |
| Michael Ward            | mjward           | [Michael-J-Ward ](https://github.com/Michael-J-Ward)    |                | Committer |
| Marco Neumann           | mneumann         | [crepererum](https://github.com/crepererum)             | InfluxData     | Committer |
| Zhong Yanghong          | nju_yaho         | [yahoNanJing](https://github.com/yahoNanJing)           |                | Committer |
| Paddy Horan             | paddyhoran       | [paddyhoran](https://github.com/paddyhoran)             | Assured Allies | Committer |
| Parth Chandra           | parthc           | [parthchandra](https://github.com/parthchandra)         | Apple          | Committer |
| Rémi Dettai             | rdettai          | [rdettai](https://github.com/rdettai)                   |                | Committer |
| Raz Luvaton             | rluvaton         | [rluvaton](https://github.com/rluvaton)                 |                | Committer |
| Chao Sun                | sunchao          | [sunchao](https://github.com/sunchao)                   | OpenAI         | Committer |
| Daniel Harris           | thinkharderdev   | [thinkharderdev](https://github.com/thinkharderdev)     | Coralogix      | Committer |
| Raphael Taylor-Davies   | tustvold         | [tustvold](https://github.com/tustvold)                 |                | Committer |
| Zhen Wang               | wangzhen         | [wForget](https://github.com/wForget)                   |                | Committer |
| Weijun Huang            | weijun           | [Weijun-H](https://github.com/Weijun-H)                 | OrbDB          | Committer |
| Yang Jiang              | yangjiang        | [Ted-jiang](https://github.com/Ted-jiang)               | Ebay           | Committer |
| Yoav Cohen              | ycohen           | [yoavcloud](https://github.com/yoavcloud)               |                | Committer |
| Yijie Shen              | yjshen           | [yjshen](https://github.com/yjshen)                     | DataPelago     | Committer |
| Qi Zhu                  | zhuqi            | [zhuqi-lucas](https://github.com/zhuqi-lucas)           | Polygon.io     | Committer |

<!-- End Auto-Generated Committer List -->

Note that the authoritative list of PMC and committers is the [Apache Phonebook]

[apache phonebook]: https://projects.apache.org/committee.html?datafusion

## Roles

- **Contributors**: Anyone who contributes to the project, whether it be code,
  documentation, testing, issue reports, code, or some other forms.

- **Committers**: Contributors who have been granted write access to the  
  project's source code repository. Committers are responsible for reviewing and
  merging pull requests. Committers are chosen by the PMC.

- **Project Management Committee (PMC)**: The PMC is responsible for the
  oversight of the project. The PMC is responsible for making decisions about the
  project, including the addition of new committers and PMC members. The PMC is
  also responsible for [voting] on releases and ensuring that the project follows
  the [Apache Way].

[voting]: https://www.apache.org/foundation/voting.html

## Becoming a Committer

Contributors with sustained, high-quality activity may be invited to become
committers by the PMC as a recognition of their contribution to the project and
their shared commitment. Committers have the significant responsibility of using
their status and access to improve the project for the entire community.

When considering inviting someone to be a committer, the PMC looks for
contributors who are already doing the work and exercising the judgment expected
of a committer. After all, any contributor can do all of the things a committer
does except for merge a PR. While there is no set list of requirements, nor a
checklist that entitles one to commit privileges, typical behaviors include:

- Contributions beyond pull requests, such as reviewing other pull requests,
  fixing bugs and documentation, triaging issues, answering community questions,
  improving usability, helping with CI, verifying releases, etc.

- Contributions that are consistent in quality and sustained
  over time, typically on the order of 6 months or more.

- Assistance growing the size and health of the community via constructive,
  respectful, and consensus driven interactions, as described in our [Code of
  Conduct] and the [Apache Way].

If you feel you should be offered committer privileges, but have not been, you
can reach out to one of the PMC members or the private@datafusion.apache.org mailing
list.

[code of conduct]: https://www.apache.org/foundation/policies/conduct.html

## Becoming a PMC Member

Committers with long term sustained contributions to the project may be invited
to join the PMC. This is a recognition of a significant contribution to growing
the community, improving the project, and helping to guide the project's
direction, typically over the course of a year or more.
