/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.federation.FederationStreamConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.core.server.federation.FederationConnection;
import org.apache.activemq.artemis.core.server.federation.FederationStream;
import org.apache.activemq.artemis.core.server.federation.address.FederatedAddress;
import org.apache.activemq.artemis.core.server.federation.queue.FederatedQueue;

public abstract class AbstractFederationStream
implements FederationStream {
    protected final ActiveMQServer server;
    protected final Federation federation;
    protected final SimpleString name;
    protected final FederationConnection connection;
    private FederationStreamConfiguration config;
    protected Map<String, FederatedQueue> federatedQueueMap = new HashMap<String, FederatedQueue>();
    protected Map<String, FederatedAddress> federatedAddressMap = new HashMap<String, FederatedAddress>();

    public AbstractFederationStream(ActiveMQServer server, Federation federation, String name, FederationStreamConfiguration config) {
        this(server, federation, name, config, null);
    }

    public AbstractFederationStream(ActiveMQServer server, Federation federation, String name, FederationStreamConfiguration config, FederationConnection connection) {
        this.server = server;
        this.federation = federation;
        Objects.requireNonNull(config.getName());
        this.name = SimpleString.toSimpleString((String)config.getName());
        this.config = config;
        this.connection = connection != null ? connection : new FederationConnection(server.getConfiguration(), name, config.getConnectionConfiguration());
    }

    @Override
    public synchronized void start() {
        if (this.connection != null) {
            this.connection.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    @Override
    public Federation getFederation() {
        return this.federation;
    }

    @Override
    public FederationStreamConfiguration getConfig() {
        return this.config;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public FederationConnection getConnection() {
        return this.connection;
    }

    @Override
    public String getUser() {
        String user = this.config.getConnectionConfiguration().getUsername();
        if (user == null || user.isEmpty()) {
            return this.federation.getFederationUser();
        }
        return user;
    }

    @Override
    public String getPassword() {
        String password = this.config.getConnectionConfiguration().getPassword();
        if (password == null || password.isEmpty()) {
            return this.federation.getFederationPassword();
        }
        return password;
    }

    @Override
    public int getPriorityAdjustment() {
        return this.config.getConnectionConfiguration().getPriorityAdjustment();
    }

    protected void callFederationStreamStartedPlugins() {
        if (this.server.hasBrokerFederationPlugins()) {
            try {
                this.server.callBrokerFederationPlugins(plugin -> plugin.federationStreamStarted(this));
            }
            catch (ActiveMQException t) {
                ActiveMQServerLogger.LOGGER.federationPluginExecutionError("federationStreamStarted", t);
                throw new IllegalStateException(t.getMessage(), t.getCause());
            }
        }
    }

    protected void callFederationStreamStoppedPlugins() {
        if (this.server.hasBrokerFederationPlugins()) {
            try {
                this.server.callBrokerFederationPlugins(plugin -> plugin.federationStreamStopped(this));
            }
            catch (ActiveMQException t) {
                ActiveMQServerLogger.LOGGER.federationPluginExecutionError("federationStreamStopped", t);
                throw new IllegalStateException(t.getMessage(), t.getCause());
            }
        }
    }
}

