/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.common;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.oidc.common.AggregatedClaims;
import org.apache.cxf.rs.security.oidc.common.DistributedClaimSource;
import org.apache.cxf.rs.security.oidc.common.DistributedClaims;
import org.apache.cxf.rs.security.oidc.common.UserAddress;

public abstract class AbstractUserInfo
extends JwtClaims {
    public static final String NAME_CLAIM = "name";
    public static final String GIVEN_NAME_CLAIM = "given_name";
    public static final String FAMILY_NAME_CLAIM = "family_name";
    public static final String MIDDLE_NAME_CLAIM = "middle_name";
    public static final String NICKNAME_CLAIM = "nickname";
    public static final String PREFERRED_USERNAME_CLAIM = "preferred_username";
    public static final String PROFILE_CLAIM = "profile";
    public static final String PICTURE_CLAIM = "picture";
    public static final String WEBSITE_CLAIM = "website";
    public static final String EMAIL_CLAIM = "email";
    public static final String EMAIL_VERIFIED_CLAIM = "email_verified";
    public static final String GENDER_CLAIM = "gender";
    public static final String ZONEINFO_CLAIM = "zoneinfo";
    public static final String LOCALE_CLAIM = "locale";
    public static final String BIRTHDATE_CLAIM = "birthdate";
    public static final String PHONE_CLAIM = "phone_number";
    public static final String PHONE_VERIFIED_CLAIM = "phone_number_verified";
    public static final String ADDRESS_CLAIM = "address";
    public static final String UPDATED_AT_CLAIM = "updated_at";
    private static final long serialVersionUID = 4554501320190745304L;

    public AbstractUserInfo() {
    }

    public AbstractUserInfo(JwtClaims claims) {
        this(claims.asMap());
    }

    public AbstractUserInfo(Map<String, Object> claims) {
        super(claims);
    }

    public void setName(String name) {
        this.setProperty(NAME_CLAIM, name);
    }

    public String getName() {
        return (String)this.getProperty(NAME_CLAIM);
    }

    public void setGivenName(String name) {
        this.setProperty(GIVEN_NAME_CLAIM, name);
    }

    public String getGivenName() {
        return (String)this.getProperty(GIVEN_NAME_CLAIM);
    }

    public void setFamilyName(String name) {
        this.setProperty(FAMILY_NAME_CLAIM, name);
    }

    public String getFamilyName() {
        return (String)this.getProperty(FAMILY_NAME_CLAIM);
    }

    public void setMiddleName(String name) {
        this.setProperty(MIDDLE_NAME_CLAIM, name);
    }

    public String getMiddleName() {
        return (String)this.getProperty(MIDDLE_NAME_CLAIM);
    }

    public void setNickName(String name) {
        this.setProperty(NICKNAME_CLAIM, name);
    }

    public String getNickName() {
        return (String)this.getProperty(NICKNAME_CLAIM);
    }

    public void setPreferredUserName(String name) {
        this.setProperty(PREFERRED_USERNAME_CLAIM, name);
    }

    public String getPreferredUserName() {
        return (String)this.getProperty(PREFERRED_USERNAME_CLAIM);
    }

    public void setProfile(String name) {
        this.setProperty(PROFILE_CLAIM, name);
    }

    public String getProfile() {
        return (String)this.getProperty(PROFILE_CLAIM);
    }

    public void setPicture(String name) {
        this.setProperty(PICTURE_CLAIM, name);
    }

    public String getPicture() {
        return (String)this.getProperty(PICTURE_CLAIM);
    }

    public void setWebsite(String name) {
        this.setProperty(WEBSITE_CLAIM, name);
    }

    public String getWebsite() {
        return (String)this.getProperty(WEBSITE_CLAIM);
    }

    public void setGender(String name) {
        this.setProperty(GENDER_CLAIM, name);
    }

    public String getGender() {
        return (String)this.getProperty(GENDER_CLAIM);
    }

    public void setZoneInfo(String name) {
        this.setProperty(ZONEINFO_CLAIM, name);
    }

    public String getZoneInfo() {
        return (String)this.getProperty(ZONEINFO_CLAIM);
    }

    public void setLocale(String name) {
        this.setProperty(LOCALE_CLAIM, name);
    }

    public String getLocale() {
        return (String)this.getProperty(LOCALE_CLAIM);
    }

    public void setEmail(String name) {
        this.setProperty(EMAIL_CLAIM, name);
    }

    public String getEmail() {
        return (String)this.getProperty(EMAIL_CLAIM);
    }

    public void setEmailVerified(Boolean verified) {
        this.setProperty(EMAIL_VERIFIED_CLAIM, verified);
    }

    public Boolean getEmailVerified() {
        return this.getBooleanProperty(EMAIL_VERIFIED_CLAIM);
    }

    public void setBirthDate(String date) {
        this.setProperty(BIRTHDATE_CLAIM, date);
    }

    public String getBirthDate() {
        return (String)this.getProperty(BIRTHDATE_CLAIM);
    }

    public String getPhoneNumber() {
        return (String)this.getProperty(PHONE_CLAIM);
    }

    public void setPhoneNumber(String name) {
        this.setProperty(PHONE_CLAIM, name);
    }

    public void setPhoneVerified(Boolean verified) {
        this.setProperty(PHONE_VERIFIED_CLAIM, verified);
    }

    public Boolean getPhoneVerified() {
        return this.getBooleanProperty(PHONE_VERIFIED_CLAIM);
    }

    public UserAddress getUserAddress() {
        Object value = this.getProperty(ADDRESS_CLAIM);
        if (value instanceof UserAddress) {
            return (UserAddress)((Object)value);
        }
        if (value instanceof Map) {
            Map map = CastUtils.cast((Map)((Map)value));
            return new UserAddress(map);
        }
        return null;
    }

    public void setUserAddress(UserAddress address) {
        this.setProperty(ADDRESS_CLAIM, (Object)address);
    }

    public void setUpdatedAt(Long time) {
        this.setProperty(UPDATED_AT_CLAIM, time);
    }

    public Long getUpdatedAt() {
        return this.getLongProperty(UPDATED_AT_CLAIM);
    }

    public void setAggregatedClaims(AggregatedClaims claims) {
        this.setAddClaimNames(claims.getClaimNames());
        LinkedHashMap<String, Map<String, String>> sources = new LinkedHashMap<String, Map<String, String>>();
        for (Map.Entry<String, String> entry : claims.getClaimNames().entrySet()) {
            String source = entry.getValue();
            String jwt = claims.getClaimSources().get(source);
            sources.put(source, Collections.singletonMap("JWT", jwt));
        }
        this.setAddClaimSources(sources);
    }

    private void setAddClaimSources(Map<String, Map<String, String>> newSources) {
        Map sources = CastUtils.cast((Map)((Map)this.getProperty("_claim_sources")));
        if (sources == null) {
            this.setProperty("_claim_sources", sources);
        } else {
            sources.putAll(newSources);
        }
    }

    private void setAddClaimNames(Map<String, String> claimNames) {
        Map names = CastUtils.cast((Map)((Map)this.getProperty("_claim_names")));
        if (names == null) {
            this.setProperty("_claim_names", claimNames);
        } else {
            names.putAll(claimNames);
        }
    }

    public AggregatedClaims getAggregatedClaims() {
        Map names = CastUtils.cast((Map)((Map)this.getProperty("_claim_names")));
        Map sources = CastUtils.cast((Map)((Map)this.getProperty("_claim_sources")));
        if (names == null || sources == null) {
            return null;
        }
        AggregatedClaims claims = new AggregatedClaims();
        LinkedHashMap<String, String> namesMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> sourcesMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : names.entrySet()) {
            String source = (String)entry.getValue();
            Map sourceValue = (Map)sources.get(source);
            if (sourceValue == null || !sourceValue.containsKey("JWT")) continue;
            namesMap.put((String)entry.getKey(), source);
            String jwt = (String)sourceValue.values().iterator().next();
            sourcesMap.put(source, jwt);
        }
        claims.setClaimNames(namesMap);
        claims.setClaimSources(sourcesMap);
        return claims;
    }

    public void setDistributedClaims(DistributedClaims claims) {
        this.setAddClaimNames(claims.getClaimNames());
        LinkedHashMap<String, Map<String, String>> sources = new LinkedHashMap<String, Map<String, String>>();
        for (Map.Entry<String, String> entry : claims.getClaimNames().entrySet()) {
            String source = entry.getValue();
            DistributedClaimSource distSource = claims.getClaimSources().get(source);
            LinkedHashMap<String, String> mapSource = new LinkedHashMap<String, String>();
            mapSource.put("endpoint", distSource.getEndpoint());
            if (distSource.getAccessToken() != null) {
                mapSource.put("access_token", distSource.getAccessToken());
            }
            sources.put(source, mapSource);
        }
        this.setAddClaimSources(sources);
    }

    public DistributedClaims getDistributedClaims() {
        Map names = CastUtils.cast((Map)((Map)this.getProperty("_claim_names")));
        Map sources = CastUtils.cast((Map)((Map)this.getProperty("_claim_sources")));
        if (names == null || sources == null) {
            return null;
        }
        DistributedClaims claims = new DistributedClaims();
        LinkedHashMap<String, String> namesMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, DistributedClaimSource> sourcesMap = new LinkedHashMap<String, DistributedClaimSource>();
        for (Map.Entry entry : names.entrySet()) {
            String source = (String)entry.getValue();
            Map sourceValue = (Map)sources.get(source);
            if (sourceValue == null || sourceValue.containsKey("JWT")) continue;
            namesMap.put((String)entry.getKey(), source);
            DistributedClaimSource distSource = new DistributedClaimSource();
            distSource.setEndpoint((String)sourceValue.get("endpoint"));
            distSource.setAccessToken((String)sourceValue.get("access_token"));
            sourcesMap.put(source, distSource);
        }
        claims.setClaimNames(namesMap);
        claims.setClaimSources(sourcesMap);
        return claims;
    }
}

