/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim.nonlinear.scalar.noderiv;

import java.util.Comparator;
import java.util.function.DoublePredicate;
import java.util.function.UnaryOperator;
import org.apache.commons.math4.legacy.analysis.MultivariateFunction;
import org.apache.commons.math4.legacy.optim.PointValuePair;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.noderiv.Simplex;

public class NelderMeadTransform
implements Simplex.TransformFactory {
    private static final double DEFAULT_ALPHA = 1.0;
    private static final double DEFAULT_GAMMA = 2.0;
    private static final double DEFAULT_RHO = 0.5;
    private static final double DEFAULT_SIGMA = 0.5;
    private final double alpha;
    private final double gamma;
    private final double rho;
    private final double sigma;

    public NelderMeadTransform(double alpha, double gamma, double rho, double sigma) {
        this.alpha = alpha;
        this.gamma = gamma;
        this.rho = rho;
        this.sigma = sigma;
    }

    public NelderMeadTransform() {
        this(1.0, 2.0, 0.5, 0.5);
    }

    @Override
    public UnaryOperator<Simplex> create(MultivariateFunction evaluationFunction, Comparator<PointValuePair> comparator, DoublePredicate sa) {
        return original -> {
            int n = original.getDimension();
            PointValuePair best = original.get(0);
            PointValuePair secondWorst = original.get(n - 1);
            PointValuePair worst = original.get(n);
            double[] xWorst = worst.getPoint();
            double[] centroid = Simplex.centroid(original.asList().subList(0, n));
            PointValuePair reflected = Simplex.newPoint(centroid, -this.alpha, xWorst, evaluationFunction);
            if (comparator.compare(reflected, secondWorst) < 0 && comparator.compare(best, reflected) <= 0) {
                return original.replaceLast(reflected);
            }
            if (comparator.compare(reflected, best) < 0) {
                PointValuePair expanded = Simplex.newPoint(centroid, -this.gamma, xWorst, evaluationFunction);
                if (comparator.compare(expanded, reflected) < 0 || sa != null && sa.test((Double)expanded.getValue() - (Double)reflected.getValue())) {
                    return original.replaceLast(expanded);
                }
                return original.replaceLast(reflected);
            }
            if (comparator.compare(reflected, worst) < 0) {
                PointValuePair contracted = Simplex.newPoint(centroid, this.rho, reflected.getPoint(), evaluationFunction);
                if (comparator.compare(contracted, reflected) < 0) {
                    return original.replaceLast(contracted);
                }
            } else {
                PointValuePair contracted = Simplex.newPoint(centroid, this.rho, xWorst, evaluationFunction);
                if (comparator.compare(contracted, worst) < 0) {
                    return original.replaceLast(contracted);
                }
            }
            return original.shrink(this.sigma, evaluationFunction);
        };
    }

    public String toString() {
        return "Nelder-Mead [a=" + this.alpha + " g=" + this.gamma + " r=" + this.rho + " s=" + this.sigma + "]";
    }
}

