/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.distribution;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.core.Pair;
import org.apache.commons.math4.legacy.exception.MathArithmeticException;
import org.apache.commons.math4.legacy.exception.NotANumberException;
import org.apache.commons.math4.legacy.exception.NotFiniteNumberException;
import org.apache.commons.math4.legacy.exception.NotPositiveException;
import org.apache.commons.math4.legacy.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.DiscreteProbabilityCollectionSampler;

public class EnumeratedDistribution<T> {
    private final List<T> singletons;
    private final double[] probabilities;
    private final double[] cumulativeProbabilities;

    public EnumeratedDistribution(List<Pair<T, Double>> pmf) throws NotPositiveException, MathArithmeticException, NotFiniteNumberException, NotANumberException {
        this.singletons = new ArrayList<T>(pmf.size());
        double[] probs = new double[pmf.size()];
        int count = 0;
        for (Pair<T, Double> sample : pmf) {
            this.singletons.add(sample.getKey());
            double p = (Double)sample.getValue();
            if (p < 0.0) {
                throw new NotPositiveException((Number)sample.getValue());
            }
            if (Double.isInfinite(p)) {
                throw new NotFiniteNumberException((Number)p, new Object[0]);
            }
            if (Double.isNaN(p)) {
                throw new NotANumberException();
            }
            probs[count++] = p;
        }
        this.probabilities = MathArrays.normalizeArray((double[])probs, (double)1.0);
        this.cumulativeProbabilities = new double[this.probabilities.length];
        double sum = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            this.cumulativeProbabilities[i] = sum += this.probabilities[i];
        }
    }

    double probability(T x) {
        double probability = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            if ((x != null || this.singletons.get(i) != null) && (x == null || !x.equals(this.singletons.get(i)))) continue;
            probability += this.probabilities[i];
        }
        return probability;
    }

    public List<Pair<T, Double>> getPmf() {
        ArrayList<Pair<T, Double>> samples = new ArrayList<Pair<T, Double>>(this.probabilities.length);
        for (int i = 0; i < this.probabilities.length; ++i) {
            samples.add(new Pair(this.singletons.get(i), (Object)this.probabilities[i]));
        }
        return samples;
    }

    public Sampler createSampler(UniformRandomProvider rng) {
        return new Sampler(rng);
    }

    public class Sampler {
        private final DiscreteProbabilityCollectionSampler<T> sampler;

        Sampler(UniformRandomProvider rng) {
            this.sampler = new DiscreteProbabilityCollectionSampler(rng, EnumeratedDistribution.this.singletons, EnumeratedDistribution.this.probabilities);
        }

        public T sample() {
            return this.sampler.sample();
        }

        public Object[] sample(int sampleSize) throws NotStrictlyPositiveException {
            if (sampleSize <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, (Number)sampleSize);
            }
            Object[] out = new Object[sampleSize];
            for (int i = 0; i < sampleSize; ++i) {
                out[i] = this.sample();
            }
            return out;
        }

        public T[] sample(int sampleSize, T[] array) throws NotStrictlyPositiveException {
            Object[] out;
            if (sampleSize <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, (Number)sampleSize);
            }
            if (array == null) {
                throw new NullArgumentException((Localizable)LocalizedFormats.INPUT_ARRAY, new Object[0]);
            }
            if (array.length < sampleSize) {
                Object[] unchecked = (Object[])Array.newInstance(array.getClass().getComponentType(), sampleSize);
                out = unchecked;
            } else {
                out = array;
            }
            for (int i = 0; i < sampleSize; ++i) {
                out[i] = this.sample();
            }
            return out;
        }
    }
}

