/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.AbstractToModelToken;
import org.apache.cayenne.map.Procedure;

public class DropProcedureToModel
extends AbstractToModelToken {
    private Procedure procedure;

    public DropProcedureToModel(Procedure procedure) {
        super("Drop procedure to model", 60);
        this.procedure = procedure;
    }

    @Override
    public String getTokenValue() {
        return this.procedure.getName();
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createAddProcedureToDb(this.procedure);
    }

    @Override
    public void execute(MergerContext context) {
        if (this.procedure == null) {
            return;
        }
        context.getDataMap().removeProcedure(this.procedure.getName());
        context.getDelegate().procedureRemoved(this.procedure);
    }
}

