/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.dbimport.AddCatalogAction;
import org.apache.cayenne.modeler.action.dbimport.AddExcludeColumnAction;
import org.apache.cayenne.modeler.action.dbimport.AddExcludeProcedureAction;
import org.apache.cayenne.modeler.action.dbimport.AddExcludeTableAction;
import org.apache.cayenne.modeler.action.dbimport.AddIncludeColumnAction;
import org.apache.cayenne.modeler.action.dbimport.AddIncludeProcedureAction;
import org.apache.cayenne.modeler.action.dbimport.AddIncludeTableAction;
import org.apache.cayenne.modeler.action.dbimport.AddSchemaAction;
import org.apache.cayenne.modeler.action.dbimport.MoveImportNodeAction;
import org.apache.cayenne.modeler.action.dbimport.MoveInvertNodeAction;
import org.apache.cayenne.modeler.action.dbimport.TreeManipulationAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.dialog.db.load.TransferableNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportModel;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;
import org.apache.cayenne.modeler.editor.dbimport.tree.ColorTreeRenderer;
import org.apache.cayenne.modeler.util.CayenneAction;

public class DraggableTreePanel
extends JScrollPane {
    private static final int ROOT_LEVEL = 14;
    private static final int FIRST_LEVEL = 11;
    private static final int SECOND_LEVEL = 8;
    private static final int THIRD_LEVEL = 5;
    private static final int FOURTH_LEVEL = 2;
    private static final int FIFTH_LEVEL = 3;
    private static final String MOVE_BUTTON_LABEL = "Include";
    private static final String MOVE_INV_BUTTON_LABEL = "Exclude";
    private final ProjectController projectController;
    private final DbImportTree sourceTree;
    private final DbImportTree targetTree;
    private final Map<DataMap, ReverseEngineering> databaseStructures;
    private final Map<Class<?>, Integer> levels;
    private final Map<Class<?>, List<Class<?>>> insertableLevels;
    private final Map<Class<?>, Class<? extends TreeManipulationAction>> actions;
    private CayenneAction.CayenneToolbarButton moveButton;
    private CayenneAction.CayenneToolbarButton moveInvertButton;

    public DraggableTreePanel(ProjectController projectController, DbImportTree sourceTree, DbImportTree targetTree) {
        super(sourceTree);
        this.targetTree = targetTree;
        this.sourceTree = sourceTree;
        this.projectController = projectController;
        this.databaseStructures = new HashMap<DataMap, ReverseEngineering>();
        this.levels = new HashMap();
        this.insertableLevels = new HashMap();
        this.actions = new HashMap();
        this.initLevels();
        this.initElement();
        this.initActions();
        this.initListeners();
    }

    private void initActions() {
        this.actions.put(Catalog.class, AddCatalogAction.class);
        this.actions.put(Schema.class, AddSchemaAction.class);
        this.actions.put(IncludeTable.class, AddIncludeTableAction.class);
        this.actions.put(ExcludeTable.class, AddExcludeTableAction.class);
        this.actions.put(IncludeColumn.class, AddIncludeColumnAction.class);
        this.actions.put(ExcludeColumn.class, AddExcludeColumnAction.class);
        this.actions.put(IncludeProcedure.class, AddIncludeProcedureAction.class);
        this.actions.put(ExcludeProcedure.class, AddExcludeProcedureAction.class);
    }

    public void updateTree(DataMap dataMap) {
        DbImportModel model = (DbImportModel)this.sourceTree.getModel();
        model.reload();
        if (this.databaseStructures.get(dataMap) != null) {
            this.sourceTree.setReverseEngineering(this.databaseStructures.get(dataMap));
            this.sourceTree.translateReverseEngineeringToTree(this.databaseStructures.get(dataMap), true);
            this.sourceTree.setEnabled(true);
        } else {
            this.sourceTree.setEnabled(false);
        }
    }

    private void initListeners() {
        this.sourceTree.addKeyListener(new SourceTreeKeyListener());
        this.sourceTree.setTransferHandler(new SourceTreeTransferHandler());
        this.sourceTree.addTreeSelectionListener(new SourceTreeSelectionListener());
        this.sourceTree.addMouseListener(new ResetFocusMouseAdapter());
        this.targetTree.addKeyListener(new TargetTreeKeyListener());
        this.targetTree.setTransferHandler(new TargetTreeTransferHandler());
        this.targetTree.addTreeSelectionListener(new TargetTreeSelectionListener());
        this.targetTree.setDragEnabled(true);
    }

    private boolean canBeInverted() {
        DbImportTreeNode selectedElement = this.sourceTree.getSelectedNode();
        if (selectedElement == null) {
            return false;
        }
        return this.levels.get(selectedElement.getUserObject().getClass()) < 8;
    }

    private void initElement() {
        this.sourceTree.setDragEnabled(true);
        this.sourceTree.setCellRenderer(new ColorTreeRenderer());
        this.sourceTree.setDropMode(DropMode.INSERT);
        MoveImportNodeAction action = this.projectController.getApplication().getActionManager().getAction(MoveImportNodeAction.class);
        action.setPanel(this);
        action.setSourceTree(this.sourceTree);
        action.setTargetTree(this.targetTree);
        this.moveButton = (CayenneAction.CayenneToolbarButton)action.buildButton();
        this.moveButton.setShowingText(true);
        this.moveButton.setText(MOVE_BUTTON_LABEL);
        MoveInvertNodeAction actionInv = this.projectController.getApplication().getActionManager().getAction(MoveInvertNodeAction.class);
        actionInv.setPanel(this);
        actionInv.setSourceTree(this.sourceTree);
        actionInv.setTargetTree(this.targetTree);
        this.moveInvertButton = (CayenneAction.CayenneToolbarButton)actionInv.buildButton();
        this.moveInvertButton.setShowingText(true);
        this.moveInvertButton.setText(MOVE_INV_BUTTON_LABEL);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.sourceTree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
    }

    private void initLevels() {
        this.levels.put(ReverseEngineering.class, 14);
        this.levels.put(Catalog.class, 11);
        this.levels.put(Schema.class, 8);
        this.levels.put(IncludeTable.class, 5);
        this.levels.put(IncludeColumn.class, 2);
        this.levels.put(ExcludeColumn.class, 2);
        this.levels.put(ExcludeTable.class, 3);
        this.levels.put(IncludeProcedure.class, 3);
        this.levels.put(ExcludeProcedure.class, 3);
        this.insertableLevels.put(ReverseEngineering.class, Arrays.asList(Catalog.class, Schema.class, IncludeTable.class, ExcludeTable.class, IncludeColumn.class, ExcludeColumn.class, IncludeProcedure.class, ExcludeProcedure.class));
        this.insertableLevels.put(Catalog.class, Arrays.asList(Schema.class, IncludeTable.class, ExcludeTable.class, IncludeColumn.class, ExcludeColumn.class, IncludeProcedure.class, ExcludeProcedure.class));
        this.insertableLevels.put(Schema.class, Arrays.asList(IncludeTable.class, ExcludeTable.class, IncludeColumn.class, ExcludeColumn.class, IncludeProcedure.class, ExcludeProcedure.class));
        this.insertableLevels.put(IncludeTable.class, Arrays.asList(IncludeColumn.class, ExcludeColumn.class));
    }

    private boolean canBeMoved() {
        DbImportTreeNode parent;
        DbImportTreeNode node;
        DbImportTreeNode selectedElement = this.sourceTree.getSelectedNode();
        if (selectedElement == null) {
            return false;
        }
        if ((selectedElement.isIncludeColumn() || selectedElement.isExcludeColumn()) && (node = this.targetTree.findNode(this.targetTree.getRootNode(), selectedElement.getParent(), 0)) != null && node.isExcludeTable()) {
            return false;
        }
        Class<?> draggableElementClass = selectedElement.getUserObject().getClass();
        Class reverseEngineeringElementClass = this.targetTree.getSelectionPath() != null ? ((parent = (selectedElement = this.targetTree.getSelectedNode()).getParent()) != null ? parent.getUserObject().getClass() : selectedElement.getUserObject().getClass()) : ReverseEngineering.class;
        List<Class<?>> containsList = this.insertableLevels.get(reverseEngineeringElementClass);
        return containsList.contains(draggableElementClass);
    }

    public JButton getMoveButton() {
        return this.moveButton;
    }

    public JButton getMoveInvertButton() {
        return this.moveInvertButton;
    }

    public TreeManipulationAction getActionByNodeType(Class<?> nodeType) {
        Class<? extends TreeManipulationAction> actionClass = this.actions.get(nodeType);
        if (actionClass == null) {
            return null;
        }
        return this.projectController.getApplication().getActionManager().getAction(actionClass);
    }

    public void bindReverseEngineeringToDatamap(DataMap dataMap, ReverseEngineering reverseEngineering) {
        this.databaseStructures.put(dataMap, reverseEngineering);
    }

    public DbImportTree getSourceTree() {
        return this.sourceTree;
    }

    private class SourceTreeKeyListener
    implements KeyListener {
        private SourceTreeKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                DraggableTreePanel.this.sourceTree.setSelectionRow(-1);
                DraggableTreePanel.this.moveButton.setEnabled(false);
                DraggableTreePanel.this.moveInvertButton.setEnabled(false);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private static class SourceTreeTransferHandler
    extends TransferHandler {
        private SourceTreeTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            JTree tree = (JTree)c;
            TreePath[] paths = tree.getSelectionPaths();
            int pathLength = paths == null ? 0 : paths.length;
            final DbImportTreeNode[] nodes = new DbImportTreeNode[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                nodes[i] = (DbImportTreeNode)paths[i].getLastPathComponent();
            }
            return new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return TransferableNode.flavors;
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return true;
                }

                @Override
                public Object getTransferData(DataFlavor flavor) {
                    return nodes;
                }
            };
        }
    }

    private class SourceTreeSelectionListener
    implements TreeSelectionListener {
        private SourceTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (DraggableTreePanel.this.sourceTree.getLastSelectedPathComponent() != null) {
                boolean canBeMoved = DraggableTreePanel.this.canBeMoved();
                DraggableTreePanel.this.moveButton.setEnabled(canBeMoved);
                DraggableTreePanel.this.moveInvertButton.setEnabled(canBeMoved && DraggableTreePanel.this.canBeInverted());
            }
        }
    }

    private class ResetFocusMouseAdapter
    extends MouseAdapter {
        private ResetFocusMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (DraggableTreePanel.this.sourceTree.getRowForLocation(e.getX(), e.getY()) == -1) {
                DraggableTreePanel.this.sourceTree.setSelectionRow(-1);
                DraggableTreePanel.this.moveInvertButton.setEnabled(false);
                DraggableTreePanel.this.moveButton.setEnabled(false);
            }
        }
    }

    private class TargetTreeKeyListener
    implements KeyListener {
        private TargetTreeKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                DraggableTreePanel.this.targetTree.setSelectionRow(-1);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class TargetTreeTransferHandler
    extends TransferHandler {
        private TargetTreeTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDrop();
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            if (!DraggableTreePanel.this.canBeMoved()) {
                return false;
            }
            Transferable transferable = support.getTransferable();
            DbImportTreeNode[] transferData = null;
            try {
                for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
                    transferData = (DbImportTreeNode[])transferable.getTransferData(dataFlavor);
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
            if (transferData != null) {
                MoveImportNodeAction action = DraggableTreePanel.this.projectController.getApplication().getActionManager().getAction(MoveImportNodeAction.class);
                action.setSourceTree(DraggableTreePanel.this.sourceTree);
                action.setTargetTree(DraggableTreePanel.this.targetTree);
                action.setPanel(DraggableTreePanel.this);
                action.performAction(null);
                return true;
            }
            return false;
        }
    }

    private class TargetTreeSelectionListener
    implements TreeSelectionListener {
        private TargetTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DbImportModel model = (DbImportModel)DraggableTreePanel.this.sourceTree.getModel();
            DbImportTreeNode root = (DbImportTreeNode)model.getRoot();
            DraggableTreePanel.this.sourceTree.repaint();
            if (root.getChildCount() > 0) {
                model.nodesChanged(root, new int[]{root.getChildCount() - 1});
            }
            boolean canBeMoved = DraggableTreePanel.this.canBeMoved();
            DraggableTreePanel.this.moveButton.setEnabled(canBeMoved);
            DraggableTreePanel.this.moveInvertButton.setEnabled(canBeMoved && DraggableTreePanel.this.canBeInverted());
        }
    }
}

