/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.concurrent.ConcurrentMap;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.db.load.DbLoadResultDialog;

public class DbImportController {
    private static final String DIALOG_TITLE = "Db Import Result";
    private DbLoadResultDialog dbLoadResultDialog;
    private boolean globalImport;

    public DbLoadResultDialog createDialog() {
        if (this.dbLoadResultDialog == null) {
            this.dbLoadResultDialog = new DbLoadResultDialog(DIALOG_TITLE);
        }
        return this.dbLoadResultDialog;
    }

    public void showDialog() {
        this.dbLoadResultDialog.pack();
        this.dbLoadResultDialog.setVisible(true);
    }

    public void setGlobalImport(boolean globalImport) {
        this.globalImport = globalImport;
    }

    public boolean isGlobalImport() {
        return this.globalImport;
    }

    public void resetDialog() {
        ConcurrentMap<DataMap, JTable> tableMap = this.dbLoadResultDialog.getTableForMap();
        for (DataMap dataMap : tableMap.keySet()) {
            this.clearTable(dataMap);
        }
        this.dbLoadResultDialog.getTableForMap().clear();
        this.dbLoadResultDialog.removeListenersFromButtons();
        this.dbLoadResultDialog.getTablePanel().removeAll();
    }

    public void clearTable(DataMap dataMap) {
        JTable table = (JTable)this.dbLoadResultDialog.getTableForMap().get(dataMap);
        if (table == null) {
            return;
        }
        DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
        int rowCount = tableModel.getRowCount();
        for (int i = rowCount - 1; i >= 0; --i) {
            tableModel.removeRow(i);
        }
    }

    public void fireDataMapChangeEvent(DataMap dataMap) {
        Application.getInstance().getFrameController().getProjectController().fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }
}

