/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.dbsync.model.DetectedDbEntity;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.PerEntityLoader;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrimaryKeyLoader
extends PerEntityLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLoader.class);

    PrimaryKeyLoader(DbLoaderConfiguration config, DbLoaderDelegate delegate) {
        super(null, config, delegate);
    }

    @Override
    ResultSet getResultSet(DbEntity dbEntity, DatabaseMetaData metaData) throws SQLException {
        return metaData.getPrimaryKeys(dbEntity.getCatalog(), dbEntity.getSchema(), dbEntity.getName());
    }

    @Override
    void processResultSet(DbEntity dbEntity, DbLoadDataStore map, ResultSet rs) throws SQLException {
        String columnName = rs.getString("COLUMN_NAME");
        DbAttribute attribute = dbEntity.getAttribute(columnName);
        if (attribute == null) {
            LOGGER.warn("Can't locate attribute for primary key: " + columnName);
            return;
        }
        attribute.setPrimaryKey(true);
        ((DetectedDbEntity)dbEntity).setPrimaryKeyName(rs.getString("PK_NAME"));
    }
}

