/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.hierarchical.model;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.hierarchical.model.JGraphAbstractHierarchyCell;
import com.jgraph.layout.hierarchical.model.JGraphHierarchyEdge;
import com.jgraph.layout.hierarchical.model.JGraphHierarchyNode;
import com.jgraph.layout.hierarchical.model.JGraphHierarchyRank;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JGraphHierarchyModel {
    protected boolean scanRanksFromSinks = true;
    public int maxRank;
    protected Map vertexMapper = null;
    protected Map edgeMapper = null;
    public Map ranks = null;
    public Object[] roots = null;
    protected int dfsCount = 0;
    protected boolean deterministic = false;
    private final int SOURCESCANSTARTRANK = 100000000;

    public JGraphHierarchyModel(JGraphFacade jGraphFacade) {
        this(jGraphFacade, jGraphFacade.getVertices().toArray(), false, false, true);
    }

    public JGraphHierarchyModel(JGraphFacade jGraphFacade, Object[] objectArray, boolean bl, boolean bl2, boolean bl3) {
        this.deterministic = bl2;
        this.scanRanksFromSinks = bl3;
        this.roots = jGraphFacade.getRoots().toArray();
        if (bl) {
            this.formOrderedHierarchy(jGraphFacade, objectArray);
        } else {
            if (objectArray == null) {
                objectArray = jGraphFacade.getVertices().toArray();
            }
            this.vertexMapper = new Hashtable(objectArray.length);
            this.edgeMapper = new Hashtable(objectArray.length);
            this.maxRank = bl3 ? 0 : 100000000;
            JGraphHierarchyNode[] jGraphHierarchyNodeArray = new JGraphHierarchyNode[objectArray.length];
            this.createInternalCells(jGraphFacade, objectArray, jGraphHierarchyNodeArray);
            for (int i = 0; i < objectArray.length; ++i) {
                Collection collection = jGraphHierarchyNodeArray[i].connectsAsSource;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e;
                    Object object;
                    JGraphHierarchyNode jGraphHierarchyNode;
                    JGraphHierarchyEdge jGraphHierarchyEdge = (JGraphHierarchyEdge)iterator.next();
                    List list = jGraphHierarchyEdge.edges;
                    Iterator iterator2 = list.iterator();
                    if (!iterator2.hasNext() || (jGraphHierarchyNode = (JGraphHierarchyNode)this.vertexMapper.get(object = jGraphFacade.getTarget(e = iterator2.next()))) == null || jGraphHierarchyNodeArray[i] == jGraphHierarchyNode) continue;
                    jGraphHierarchyEdge.target = jGraphHierarchyNode;
                    if (jGraphHierarchyNode.connectsAsTarget.size() == 0) {
                        jGraphHierarchyNode.connectsAsTarget = new LinkedHashSet(4);
                    }
                    jGraphHierarchyNode.connectsAsTarget.add(jGraphHierarchyEdge);
                }
                jGraphHierarchyNodeArray[i].temp[0] = 1;
            }
        }
    }

    public void formOrderedHierarchy(JGraphFacade jGraphFacade, Object[] objectArray) {
        if (objectArray == null) {
            objectArray = jGraphFacade.getVertices().toArray();
        }
        this.vertexMapper = new Hashtable(objectArray.length * 2);
        this.edgeMapper = new Hashtable(objectArray.length);
        this.maxRank = 0;
        JGraphHierarchyNode[] jGraphHierarchyNodeArray = new JGraphHierarchyNode[objectArray.length];
        this.createInternalCells(jGraphFacade, objectArray, jGraphHierarchyNodeArray);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Collection collection = jGraphHierarchyNodeArray[i].connectsAsSource;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e;
                Object object2;
                JGraphHierarchyNode jGraphHierarchyNode;
                object = (JGraphHierarchyEdge)iterator.next();
                List list = ((JGraphHierarchyEdge)object).edges;
                Iterator iterator2 = list.iterator();
                if (!iterator2.hasNext() || (jGraphHierarchyNode = (JGraphHierarchyNode)this.vertexMapper.get(object2 = jGraphFacade.getTarget(e = iterator2.next()))) == null || jGraphHierarchyNodeArray[i] == jGraphHierarchyNode) continue;
                ((JGraphHierarchyEdge)object).target = jGraphHierarchyNode;
                if (jGraphHierarchyNode.connectsAsTarget.size() == 0) {
                    jGraphHierarchyNode.connectsAsTarget = new ArrayList(4);
                }
                if (jGraphHierarchyNode.temp[0] == 1) {
                    ((JGraphHierarchyEdge)object).invert();
                    jGraphHierarchyNode.connectsAsSource.add(object);
                    arrayList.add(object);
                    jGraphHierarchyNodeArray[i].connectsAsTarget.add(object);
                    continue;
                }
                jGraphHierarchyNode.connectsAsTarget.add(object);
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                jGraphHierarchyNodeArray[i].connectsAsSource.remove(object.next());
            }
            arrayList.clear();
            jGraphHierarchyNodeArray[i].temp[0] = 1;
        }
    }

    protected void createInternalCells(JGraphFacade jGraphFacade, Object[] objectArray, JGraphHierarchyNode[] jGraphHierarchyNodeArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            jGraphHierarchyNodeArray[i] = new JGraphHierarchyNode(objectArray[i]);
            this.vertexMapper.put(objectArray[i], jGraphHierarchyNodeArray[i]);
            List list = jGraphFacade.getNeighbours(objectArray[i], this.deterministic);
            jGraphHierarchyNodeArray[i].connectsAsSource = new LinkedHashSet(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray2;
                Object e = iterator.next();
                if (e == objectArray[i] || !jGraphFacade.isVertex(e) || (objectArray2 = jGraphFacade.getEdgesBetween(objectArray[i], e, true)) == null || objectArray2.length <= 0) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>(objectArray2.length);
                for (int j = 0; j < objectArray2.length; ++j) {
                    arrayList.add(objectArray2[j]);
                }
                JGraphHierarchyEdge jGraphHierarchyEdge = new JGraphHierarchyEdge(arrayList);
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    this.edgeMapper.put(iterator2.next(), jGraphHierarchyEdge);
                }
                jGraphHierarchyEdge.source = jGraphHierarchyNodeArray[i];
                jGraphHierarchyNodeArray[i].connectsAsSource.add(jGraphHierarchyEdge);
            }
            jGraphHierarchyNodeArray[i].temp[0] = 0;
        }
    }

    public void initialRank() {
        Object object;
        Iterator iterator;
        Object object2;
        JGraphHierarchyNode jGraphHierarchyNode;
        Object object3;
        Collection collection = this.vertexMapper.values();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (!this.scanRanksFromSinks && this.roots != null) {
            for (int i = 0; i < this.roots.length; ++i) {
                object3 = this.vertexMapper.get(this.roots[i]);
                if (object3 == null) continue;
                linkedList.add(object3);
            }
        }
        if (this.scanRanksFromSinks) {
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                object3 = (JGraphHierarchyNode)iterator2.next();
                if (((JGraphHierarchyNode)object3).connectsAsSource != null && !((JGraphHierarchyNode)object3).connectsAsSource.isEmpty()) continue;
                linkedList.add(object3);
            }
        }
        if (linkedList.isEmpty()) {
            Iterator iterator3 = collection.iterator();
            while (iterator3.hasNext()) {
                object3 = (JGraphHierarchyNode)iterator3.next();
                if (((JGraphHierarchyNode)object3).connectsAsTarget != null && !((JGraphHierarchyNode)object3).connectsAsTarget.isEmpty()) continue;
                linkedList.add(object3);
            }
        }
        Iterator iterator4 = collection.iterator();
        while (iterator4.hasNext()) {
            object3 = (JGraphHierarchyNode)iterator4.next();
            ((JGraphHierarchyNode)object3).temp[0] = -1;
        }
        object3 = new ArrayList(linkedList);
        while (!linkedList.isEmpty()) {
            JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell;
            Collection collection2;
            jGraphHierarchyNode = (JGraphHierarchyNode)linkedList.getFirst();
            if (this.scanRanksFromSinks) {
                object2 = jGraphHierarchyNode.connectsAsSource;
                collection2 = jGraphHierarchyNode.connectsAsTarget;
            } else {
                object2 = jGraphHierarchyNode.connectsAsTarget;
                collection2 = jGraphHierarchyNode.connectsAsSource;
            }
            boolean bl = true;
            iterator = object2.iterator();
            int n = 0;
            if (!this.scanRanksFromSinks) {
                n = 100000000;
            }
            while (bl && iterator.hasNext()) {
                object = (JGraphHierarchyEdge)iterator.next();
                if (((JGraphHierarchyEdge)object).temp[0] == 5270620) {
                    jGraphAbstractHierarchyCell = this.scanRanksFromSinks ? ((JGraphHierarchyEdge)object).target : ((JGraphHierarchyEdge)object).source;
                    if (this.scanRanksFromSinks) {
                        n = Math.max(n, jGraphAbstractHierarchyCell.temp[0] + 1);
                        continue;
                    }
                    n = Math.min(n, jGraphAbstractHierarchyCell.temp[0] - 1);
                    continue;
                }
                bl = false;
            }
            if (bl) {
                jGraphHierarchyNode.temp[0] = n;
                this.maxRank = this.scanRanksFromSinks ? Math.max(this.maxRank, n) : Math.min(this.maxRank, n);
                if (collection2 != null) {
                    object = collection2.iterator();
                    while (object.hasNext()) {
                        jGraphAbstractHierarchyCell = (JGraphHierarchyEdge)object.next();
                        ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).temp[0] = 5270620;
                        JGraphHierarchyNode jGraphHierarchyNode2 = this.scanRanksFromSinks ? ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).source : ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).target;
                        if (jGraphHierarchyNode2.temp[0] != -1) continue;
                        linkedList.addLast(jGraphHierarchyNode2);
                        jGraphHierarchyNode2.temp[0] = -2;
                    }
                }
                linkedList.removeFirst();
                continue;
            }
            object = linkedList.removeFirst();
            linkedList.addLast(jGraphHierarchyNode);
            if (object != jGraphHierarchyNode || linkedList.size() != 1) continue;
        }
        if (this.scanRanksFromSinks) {
            for (int i = 0; i < object3.size(); ++i) {
                object2 = (JGraphHierarchyNode)object3.get(i);
                int n = 1000000;
                Collection collection3 = ((JGraphHierarchyNode)object2).connectsAsTarget;
                iterator = collection3.iterator();
                while (iterator.hasNext()) {
                    JGraphHierarchyEdge jGraphHierarchyEdge = (JGraphHierarchyEdge)iterator.next();
                    object = jGraphHierarchyEdge.source;
                    ((JGraphHierarchyNode)object2).temp[0] = Math.min(n, ((JGraphHierarchyNode)object).temp[0] - 1);
                    n = ((JGraphHierarchyNode)object2).temp[0];
                }
            }
        } else {
            iterator4 = collection.iterator();
            while (iterator4.hasNext()) {
                jGraphHierarchyNode = (JGraphHierarchyNode)iterator4.next();
                jGraphHierarchyNode.temp[0] = jGraphHierarchyNode.temp[0] - this.maxRank;
            }
            this.maxRank = 100000000 - this.maxRank;
        }
    }

    public void fixRanks() {
        final Collection[] collectionArray = new JGraphHierarchyRank[this.maxRank + 1];
        this.ranks = new LinkedHashMap(this.maxRank + 1);
        for (int i = 0; i < this.maxRank + 1; ++i) {
            collectionArray[i] = new JGraphHierarchyRank();
            this.ranks.put(new Integer(i), collectionArray[i]);
        }
        Object[] objectArray = null;
        if (this.roots != null) {
            objectArray = new Object[this.roots.length];
            for (int i = 0; i < this.roots.length; ++i) {
                Object object = this.roots[i];
                JGraphHierarchyNode jGraphHierarchyNode = (JGraphHierarchyNode)this.vertexMapper.get(object);
                objectArray[i] = jGraphHierarchyNode;
            }
        }
        this.dfs(new JGraphFacade.CellVisitor(){

            public void visit(Object object, Object object2, Object object3, int n, int n2) {
                int n3;
                JGraphHierarchyNode jGraphHierarchyNode = (JGraphHierarchyNode)object2;
                if (n2 == 0 && jGraphHierarchyNode.maxRank < 0 && jGraphHierarchyNode.minRank < 0) {
                    collectionArray[jGraphHierarchyNode.temp[0]].add(object2);
                    jGraphHierarchyNode.maxRank = jGraphHierarchyNode.temp[0];
                    jGraphHierarchyNode.minRank = jGraphHierarchyNode.temp[0];
                    jGraphHierarchyNode.temp[0] = collectionArray[jGraphHierarchyNode.maxRank].size() - 1;
                }
                if (object != null && object3 != null && (n3 = ((JGraphHierarchyNode)object).maxRank - jGraphHierarchyNode.maxRank) > 1) {
                    JGraphHierarchyEdge jGraphHierarchyEdge = (JGraphHierarchyEdge)object3;
                    jGraphHierarchyEdge.maxRank = ((JGraphHierarchyNode)object).maxRank;
                    jGraphHierarchyEdge.minRank = ((JGraphHierarchyNode)object2).maxRank;
                    jGraphHierarchyEdge.temp = new int[n3 - 1];
                    jGraphHierarchyEdge.x = new double[n3 - 1];
                    jGraphHierarchyEdge.y = new double[n3 - 1];
                    for (int i = jGraphHierarchyEdge.minRank + 1; i < jGraphHierarchyEdge.maxRank; ++i) {
                        collectionArray[i].add(jGraphHierarchyEdge);
                        jGraphHierarchyEdge.setGeneralPurposeVariable(i, collectionArray[i].size() - 1);
                    }
                }
            }
        }, objectArray, false, null);
    }

    public void dfs(JGraphFacade.CellVisitor cellVisitor, Object[] objectArray, boolean bl, Set hashSet) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                JGraphHierarchyNode jGraphHierarchyNode = (JGraphHierarchyNode)objectArray[i];
                if (jGraphHierarchyNode == null) continue;
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                if (bl) {
                    jGraphHierarchyNode.hashCode = new int[2];
                    jGraphHierarchyNode.hashCode[0] = this.dfsCount;
                    jGraphHierarchyNode.hashCode[1] = i;
                    this.dfs(null, jGraphHierarchyNode, null, cellVisitor, hashSet, jGraphHierarchyNode.hashCode, i, 0);
                    continue;
                }
                this.dfs(null, jGraphHierarchyNode, null, cellVisitor, hashSet, 0);
            }
            ++this.dfsCount;
        }
    }

    public void dfs(JGraphHierarchyNode jGraphHierarchyNode, JGraphHierarchyNode jGraphHierarchyNode2, JGraphHierarchyEdge jGraphHierarchyEdge, JGraphFacade.CellVisitor cellVisitor, Set set, int n) {
        if (jGraphHierarchyNode2 != null) {
            if (!set.contains(jGraphHierarchyNode2)) {
                cellVisitor.visit(jGraphHierarchyNode, jGraphHierarchyNode2, jGraphHierarchyEdge, n, 0);
                set.add(jGraphHierarchyNode2);
                Object[] objectArray = jGraphHierarchyNode2.connectsAsSource.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    JGraphHierarchyEdge jGraphHierarchyEdge2 = (JGraphHierarchyEdge)objectArray[i];
                    JGraphHierarchyNode jGraphHierarchyNode3 = jGraphHierarchyEdge2.target;
                    this.dfs(jGraphHierarchyNode2, jGraphHierarchyNode3, jGraphHierarchyEdge2, cellVisitor, set, n + 1);
                }
            } else {
                cellVisitor.visit(jGraphHierarchyNode, jGraphHierarchyNode2, jGraphHierarchyEdge, n, 1);
            }
        }
    }

    public void dfs(JGraphHierarchyNode jGraphHierarchyNode, JGraphHierarchyNode jGraphHierarchyNode2, JGraphHierarchyEdge jGraphHierarchyEdge, JGraphFacade.CellVisitor cellVisitor, Set set, int[] nArray, int n, int n2) {
        if (jGraphHierarchyNode2 != null) {
            if (jGraphHierarchyNode != null && (jGraphHierarchyNode2.hashCode == null || jGraphHierarchyNode2.hashCode[0] != jGraphHierarchyNode.hashCode[0])) {
                int n3 = jGraphHierarchyNode.hashCode.length + 1;
                jGraphHierarchyNode2.hashCode = new int[n3];
                System.arraycopy(jGraphHierarchyNode.hashCode, 0, jGraphHierarchyNode2.hashCode, 0, jGraphHierarchyNode.hashCode.length);
                jGraphHierarchyNode2.hashCode[n3 - 1] = n;
            }
            if (!set.contains(jGraphHierarchyNode2)) {
                cellVisitor.visit(jGraphHierarchyNode, jGraphHierarchyNode2, jGraphHierarchyEdge, n2, 0);
                set.add(jGraphHierarchyNode2);
                Object[] objectArray = jGraphHierarchyNode2.connectsAsSource.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    JGraphHierarchyEdge jGraphHierarchyEdge2 = (JGraphHierarchyEdge)objectArray[i];
                    JGraphHierarchyNode jGraphHierarchyNode3 = jGraphHierarchyEdge2.target;
                    this.dfs(jGraphHierarchyNode2, jGraphHierarchyNode3, jGraphHierarchyEdge2, cellVisitor, set, jGraphHierarchyNode2.hashCode, i, n2 + 1);
                }
            } else {
                cellVisitor.visit(jGraphHierarchyNode, jGraphHierarchyNode2, jGraphHierarchyEdge, n2, 1);
            }
        }
    }

    public Map getVertexMapping() {
        if (this.vertexMapper == null) {
            this.vertexMapper = new Hashtable();
        }
        return this.vertexMapper;
    }

    public void setVertexMapping(Map map) {
        this.vertexMapper = map;
    }

    public Map getEdgeMapper() {
        return this.edgeMapper;
    }

    public void setEdgeMapper(Map map) {
        this.edgeMapper = map;
    }

    public int getDfsCount() {
        return this.dfsCount;
    }

    public void setDfsCount(int n) {
        this.dfsCount = n;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean bl) {
        this.deterministic = bl;
    }

    public boolean isSinksAtLayerZero() {
        return this.scanRanksFromSinks;
    }

    public void setSinksAtLayerZero(boolean bl) {
        this.scanRanksFromSinks = bl;
    }
}

