/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.reflect.AbstractCallback;
import org.apache.cayenne.reflect.CallbackOnEntity;
import org.apache.cayenne.reflect.CallbackOnListener;

class LifecycleCallbackEventHandler {
    private Map<String, Collection<AbstractCallback>> listeners = new HashMap<String, Collection<AbstractCallback>>();
    private Collection<AbstractCallback> defaultListeners = new ArrayList<AbstractCallback>();

    LifecycleCallbackEventHandler() {
    }

    boolean isEmpty() {
        return this.listeners.isEmpty() && this.defaultListeners.isEmpty();
    }

    void clear() {
        this.listeners.clear();
        this.defaultListeners.clear();
    }

    int defaultListenersSize() {
        return this.defaultListeners.size();
    }

    int listenersSize() {
        return this.listeners.size();
    }

    void addDefaultListener(Object listener, String methodName) {
        CallbackOnListener callback = new CallbackOnListener(listener, methodName);
        this.addDefaultCallback(callback);
    }

    private void addDefaultCallback(AbstractCallback callback) {
        this.defaultListeners.add(callback);
    }

    void addListener(Class<?> entityClass, String methodName) {
        this.addCallback(entityClass, new CallbackOnEntity(entityClass, methodName));
    }

    void addListener(Class<?> entityClass, Method method) {
        this.addCallback(entityClass, new CallbackOnEntity(method));
    }

    void addListener(Class<?> entityClass, Object listener, String methodName) {
        CallbackOnListener callback = new CallbackOnListener(listener, methodName, entityClass);
        this.addCallback(entityClass, callback);
    }

    void addListener(Class<?> entityClass, Object listener, Method method) {
        CallbackOnListener callback = new CallbackOnListener(listener, method, entityClass);
        this.addCallback(entityClass, callback);
    }

    private void addCallback(Class<?> entityClass, AbstractCallback callback) {
        Collection entityListeners = this.listeners.computeIfAbsent(entityClass.getName(), k -> new ArrayList(3));
        entityListeners.add(callback);
    }

    void performCallbacks(Persistent object) {
        if (object == null) {
            return;
        }
        if (!this.defaultListeners.isEmpty()) {
            for (AbstractCallback listener : this.defaultListeners) {
                listener.performCallback(object);
            }
        }
        this.performCallbacks(object, object.getClass());
    }

    void performCallbacks(Collection<?> objects) {
        for (Object object : objects) {
            this.performCallbacks((Persistent)object);
        }
    }

    private void performCallbacks(Persistent object, Class<?> callbackEntityClass) {
        if (callbackEntityClass == null || Object.class.equals(callbackEntityClass)) {
            return;
        }
        this.performCallbacks(object, callbackEntityClass.getSuperclass());
        String key = callbackEntityClass.getName();
        Collection<AbstractCallback> entityListeners = this.listeners.get(key);
        if (entityListeners != null) {
            for (AbstractCallback listener : entityListeners) {
                listener.performCallback(object);
            }
        }
    }
}

