package org.apache.cayenne.testdo.cay_2641.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.Fault;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.cay_2641.PaintingLazy;

/**
 * Class _ArtistLazy was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _ArtistLazy extends BaseDataObject {

    private static final long serialVersionUID = 1L; 

    public static final String ID_PK_COLUMN = "ID";

    public static final StringProperty<String> NAME = PropertyFactory.createString("name", String.class);
    public static final StringProperty<String> SURNAME = PropertyFactory.createString("surname", String.class);
    public static final ListProperty<PaintingLazy> PAINTINGS = PropertyFactory.createList("paintings", PaintingLazy.class);

    protected Object name;
    protected String surname;

    protected Object paintings;

    public void setName(String name) {
        beforePropertyWrite("name", this.name, name);
        this.name = name;
    }

    public String getName() {
        beforePropertyRead("name");
        if(this.name instanceof Fault) {
            this.name = ((Fault) this.name).resolveFault(this, "name");
        }
        return (String)this.name;
    }

    public void setSurname(String surname) {
        beforePropertyWrite("surname", this.surname, surname);
        this.surname = surname;
    }

    public String getSurname() {
        beforePropertyRead("surname");
        return this.surname;
    }

    public void addToPaintings(PaintingLazy obj) {
        addToManyTarget("paintings", obj, true);
    }

    public void removeFromPaintings(PaintingLazy obj) {
        removeToManyTarget("paintings", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<PaintingLazy> getPaintings() {
        return (List<PaintingLazy>)readProperty("paintings");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "name":
                return this.name;
            case "surname":
                return this.surname;
            case "paintings":
                return this.paintings;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "name":
                this.name = val;
                break;
            case "surname":
                this.surname = (String)val;
                break;
            case "paintings":
                this.paintings = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.name);
        out.writeObject(this.surname);
        out.writeObject(this.paintings);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.name = in.readObject();
        this.surname = (String)in.readObject();
        this.paintings = in.readObject();
    }

}
