/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/
package org.apache.cayenne.dbsync.reverse.filters;

/**
* @since 4.0.
*/
public class SchemaFilter {
    public final String name;
    public final TableFilter tables;
    public final PatternFilter procedures;

    public SchemaFilter(String name, TableFilter tables, PatternFilter procedures) {
        this.name = name;
        this.tables = tables;
        this.procedures = procedures;
    }

    protected StringBuilder toString(StringBuilder res, String prefix) {
        res.append(prefix).append("Schema: ").append(name).append("\n");
        tables.toString(res, prefix + "  ");

        res.append(prefix).append("  Procedures: ");
        procedures.toString(res).append("\n");

        return res;
    }
}
