/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

class DataNodeQueryAction {
    OperationObserver observer;
    DataNode node;

    public DataNodeQueryAction(DataNode node, OperationObserver observer) {
        this.observer = observer;
        this.node = node;
    }

    public void runQuery(Connection connection, final Query originalQuery) throws SQLException, Exception {
        OperationObserver wrapper = new OperationObserver(){

            @Override
            public void nextBatchCount(Query query, int[] resultCount) {
                DataNodeQueryAction.this.observer.nextBatchCount(originalQuery, resultCount);
            }

            @Override
            public void nextCount(Query query, int resultCount) {
                DataNodeQueryAction.this.observer.nextCount(originalQuery, resultCount);
            }

            @Override
            public void nextRows(Query query, List<?> dataRows) {
                DataNodeQueryAction.this.observer.nextRows(originalQuery, dataRows);
            }

            public void nextRows(Query q, ResultIterator it) {
                DataNodeQueryAction.this.observer.nextRows(originalQuery, it);
            }

            public void nextGeneratedRows(Query query, ResultIterator keys, ObjectId idToUpdate) {
                DataNodeQueryAction.this.observer.nextGeneratedRows(originalQuery, keys, idToUpdate);
            }

            @Override
            public void nextGlobalException(Exception ex) {
                DataNodeQueryAction.this.observer.nextGlobalException(ex);
            }

            @Override
            public void nextQueryException(Query query, Exception ex) {
                DataNodeQueryAction.this.observer.nextQueryException(originalQuery, ex);
            }

            @Override
            public boolean isIteratedResult() {
                return DataNodeQueryAction.this.observer.isIteratedResult();
            }
        };
        SQLAction action = this.node.getAdapter().getAction(originalQuery, this.node);
        action.performAction(connection, wrapper);
    }
}

