/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class ObjectContextDeleteAction {
    private ObjectContext context;

    ObjectContextDeleteAction(ObjectContext context) {
        this.context = context;
    }

    boolean performDelete(Persistent object) throws DeleteDenyException {
        int oldState = object.getPersistenceState();
        if (oldState == 1 || oldState == 6) {
            return false;
        }
        if (object.getObjectContext() == null) {
            throw new CayenneRuntimeException("Attempt to delete unregistered non-TRANSIENT object: %s", object);
        }
        if (object.getObjectContext() != this.context) {
            throw new CayenneRuntimeException("Attempt to delete object regsitered in a different ObjectContext. Object: %s, context: %s", object, this.context);
        }
        this.context.prepareForAccess(object, null, false);
        if (oldState == 2) {
            this.deleteNew(object);
        } else {
            this.deletePersistent(object);
        }
        return true;
    }

    private void deleteNew(Persistent object) throws DeleteDenyException {
        object.setPersistenceState(1);
        this.processDeleteRules(object, 2);
        this.context.getGraphManager().unregisterNode(object.getObjectId());
    }

    private void deletePersistent(Persistent object) throws DeleteDenyException {
        this.context.getEntityResolver().getCallbackRegistry().performCallbacks(LifecycleEvent.PRE_REMOVE, object);
        int oldState = object.getPersistenceState();
        object.setPersistenceState(6);
        this.processDeleteRules(object, oldState);
        this.context.getGraphManager().nodeRemoved(object.getObjectId());
    }

    private Collection<Persistent> toCollection(Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (object instanceof Collection) {
            return new ArrayList<Persistent>((Collection)object);
        }
        if (object instanceof Map) {
            return new ArrayList<Persistent>(((Map)object).values());
        }
        return Collections.singleton((Persistent)object);
    }

    private void processDeleteRules(final Persistent object, int oldState) throws DeleteDenyException {
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(object.getObjectId().getEntityName());
        block5: for (ObjRelationship relationship : descriptor.getEntity().getRelationships()) {
            ArcProperty property;
            Collection<Persistent> relatedObjects;
            boolean processFlattened;
            boolean bl = processFlattened = relationship.isFlattened() && relationship.isToDependentEntity() && !relationship.isReadOnly();
            if (relationship.getDeleteRule() == 0 && !processFlattened || (relatedObjects = this.toCollection((property = (ArcProperty)descriptor.getProperty(relationship.getName())).readProperty(object))).size() == 0) continue;
            if (relationship.getDeleteRule() == 3) {
                object.setPersistenceState(oldState);
                String message = relatedObjects.size() == 1 ? "1 related object" : relatedObjects.size() + " related objects";
                throw new DeleteDenyException(object, relationship.getName(), message);
            }
            if (processFlattened) {
                for (Persistent relatedObject : relatedObjects) {
                    this.context.getGraphManager().arcDeleted(object.getObjectId(), relatedObject.getObjectId(), relationship.getName());
                }
            }
            switch (relationship.getDeleteRule()) {
                case 0: {
                    break;
                }
                case 1: {
                    ArcProperty reverseArc = property.getComplimentaryReverseArc();
                    if (reverseArc == null) break;
                    reverseArc.visit(new PropertyVisitor(){

                        @Override
                        public boolean visitAttribute(AttributeProperty property) {
                            return false;
                        }

                        @Override
                        public boolean visitToMany(ToManyProperty property) {
                            for (Persistent relatedObject : relatedObjects) {
                                property.removeTarget(relatedObject, object, true);
                            }
                            return false;
                        }

                        @Override
                        public boolean visitToOne(ToOneProperty property) {
                            for (Persistent relatedObject : relatedObjects) {
                                property.setTarget(relatedObject, null, true);
                            }
                            return false;
                        }
                    });
                    break;
                }
                case 2: {
                    for (Persistent relatedObject : relatedObjects) {
                        this.performDelete(relatedObject);
                    }
                    continue block5;
                }
                default: {
                    object.setPersistenceState(oldState);
                    throw new CayenneRuntimeException("Invalid delete rule %s", relationship.getDeleteRule());
                }
            }
        }
    }
}

