/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.LoadDbSchemaAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.dialog.db.load.TransferableNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportModel;

public class DbImportTree
extends JTree {
    private boolean isTransferable;
    private ReverseEngineering reverseEngineering;

    public DbImportTree(TreeNode node) {
        super(node);
        this.createTreeExpandListener();
    }

    public void translateReverseEngineeringToTree(ReverseEngineering reverseEngineering, boolean isTransferable) {
        this.isTransferable = isTransferable;
        this.reverseEngineering = reverseEngineering;
        DbImportModel model = (DbImportModel)this.getModel();
        DbImportTreeNode root = (DbImportTreeNode)model.getRoot();
        root.removeAllChildren();
        root.setUserObject(reverseEngineering);
        this.printCatalogs(reverseEngineering.getCatalogs(), root);
        this.printSchemas(reverseEngineering.getSchemas(), root);
        this.printIncludeTables(reverseEngineering.getIncludeTables(), root);
        this.printParams(reverseEngineering.getExcludeTables(), root);
        this.printParams(reverseEngineering.getIncludeColumns(), root);
        this.printParams(reverseEngineering.getExcludeColumns(), root);
        this.printParams(reverseEngineering.getIncludeProcedures(), root);
        this.printParams(reverseEngineering.getExcludeProcedures(), root);
        model.reload();
    }

    public void updateTableColumns(ReverseEngineering reverseEngineering) {
        DbImportModel model = (DbImportModel)this.getModel();
        DbImportTreeNode root = (DbImportTreeNode)model.getRoot();
        List<Catalog> catalogs = reverseEngineering.getCatalogs();
        if (!catalogs.isEmpty()) {
            catalogs.forEach(catalog -> {
                List<Schema> schemas = catalog.getSchemas();
                if (!schemas.isEmpty()) {
                    DbImportTreeNode currentRoot = this.findNodeInParent(root, catalog);
                    schemas.forEach(schema -> this.packNextFilter((FilterContainer)schema, currentRoot, model));
                } else {
                    this.packNextFilter((FilterContainer)catalog, root, model);
                }
            });
        } else {
            reverseEngineering.getSchemas().forEach(schema -> this.packNextFilter((FilterContainer)schema, root, model));
        }
    }

    private void packNextFilter(FilterContainer filterContainer, DbImportTreeNode root, DbImportModel model) {
        DbImportTreeNode container = this.findNodeInParent(root, filterContainer);
        if (container == null) {
            return;
        }
        this.packTables(filterContainer, container, model);
    }

    private void packTables(FilterContainer filterContainer, DbImportTreeNode root, DbImportModel model) {
        filterContainer.getIncludeTables().forEach(tableFilter -> {
            DbImportTreeNode container = this.findNodeInParent(root, tableFilter);
            if (container == null) {
                return;
            }
            if (container.getChildCount() != 0) {
                container.removeAllChildren();
            }
            this.packColumns((IncludeTable)tableFilter, container);
            container.setLoaded(true);
            model.reload(container);
        });
    }

    private void packColumns(IncludeTable includeTable, DbImportTreeNode tableNode) {
        includeTable.getIncludeColumns().forEach(column -> tableNode.add(new DbImportTreeNode(column)));
    }

    private DbImportTreeNode findNodeInParent(DbImportTreeNode parent, Object object) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            PatternParam currentTable;
            PatternParam table;
            DbImportTreeNode node = (DbImportTreeNode)parent.getChildAt(i);
            Object userObject = node.getUserObject();
            if (object instanceof Catalog) {
                Catalog catalog = (Catalog)object;
                if (!(userObject instanceof Catalog)) continue;
                Catalog currentCatalog = (Catalog)userObject;
                if (currentCatalog.getName().equals(catalog.getName())) {
                    return node;
                }
            }
            if (object instanceof Schema) {
                Schema schema = (Schema)object;
                if (!(userObject instanceof Schema)) continue;
                Schema currentSchema = (Schema)userObject;
                if (currentSchema.getName().equals(schema.getName())) {
                    return node;
                }
            }
            if (object instanceof IncludeTable) {
                table = (IncludeTable)object;
                if (!(userObject instanceof IncludeTable)) continue;
                currentTable = (IncludeTable)userObject;
                if (currentTable.getPattern().equals(table.getPattern())) {
                    return node;
                }
            }
            if (!(object instanceof ExcludeTable)) continue;
            table = (ExcludeTable)object;
            if (!(userObject instanceof ExcludeTable) || !(currentTable = (ExcludeTable)userObject).getPattern().equals(table.getPattern())) continue;
            return node;
        }
        return null;
    }

    public DbImportTreeNode findNodeByParentsChain(DbImportTreeNode rootNode, DbImportTreeNode movedNode, int depth) {
        String parentName = ((DbImportTreeNode)movedNode.getParent()).getSimpleNodeName();
        if (rootNode.parentsIsEqual((DbImportTreeNode)movedNode.getParent()) && rootNode.getSimpleNodeName().equals(parentName) && (rootNode.isCatalog() || rootNode.isSchema() || rootNode.isIncludeTable())) {
            return rootNode;
        }
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DbImportTreeNode childNode = (DbImportTreeNode)rootNode.getChildAt(i);
            DbImportTreeNode node = this.findNodeByParentsChain(childNode, movedNode, depth++);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public DbImportTreeNode findNode(DbImportTreeNode rootNode, DbImportTreeNode movedNode, int depth) {
        String parentName = movedNode.getSimpleNodeName();
        if (rootNode.parentsIsEqual(movedNode) && rootNode.getSimpleNodeName().equals(parentName)) {
            return rootNode;
        }
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DbImportTreeNode childNode = (DbImportTreeNode)rootNode.getChildAt(i);
            DbImportTreeNode node = this.findNode(childNode, movedNode, depth++);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private ArrayList<DbImportTreeNode> createTreeExpandList(DbImportTreeNode rootNode, ArrayList<DbImportTreeNode> resultList) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DbImportTreeNode childNode = (DbImportTreeNode)rootNode.getChildAt(i);
            TreePath childPath = new TreePath(childNode.getPath());
            if (this.isExpanded(childPath)) {
                resultList.add(childNode);
            }
            if (childNode.getChildCount() <= 0) continue;
            this.createTreeExpandList(childNode, resultList);
        }
        return resultList;
    }

    public ArrayList<DbImportTreeNode> getTreeExpandList() {
        ArrayList<DbImportTreeNode> resultList = new ArrayList<DbImportTreeNode>();
        return this.createTreeExpandList(this.getRootNode(), resultList);
    }

    private void expandBeginningWithNode(DbImportTreeNode rootNode, ArrayList<DbImportTreeNode> list) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DbImportTreeNode childNode = (DbImportTreeNode)rootNode.getChildAt(i);
            list.forEach(element -> {
                if (element.equals(childNode)) {
                    this.expandPath(new TreePath(childNode.getPath()));
                }
            });
            if (childNode.getChildCount() <= 0) continue;
            this.expandBeginningWithNode(childNode, list);
        }
    }

    public void expandTree(ArrayList<DbImportTreeNode> expandIndexesList) {
        this.expandBeginningWithNode(this.getRootNode(), expandIndexesList);
    }

    private <T extends PatternParam> void printParams(Collection<T> collection, DbImportTreeNode parent) {
        for (PatternParam element : collection) {
            DbImportTreeNode node = !this.isTransferable ? new DbImportTreeNode(element) : new TransferableNode(element);
            if (node.getSimpleNodeName().equals("")) continue;
            parent.add(node);
        }
    }

    private void printIncludeTables(Collection<IncludeTable> collection, DbImportTreeNode parent) {
        for (IncludeTable includeTable : collection) {
            DbImportTreeNode node = !this.isTransferable ? new DbImportTreeNode(includeTable) : new TransferableNode(includeTable);
            if (node.getSimpleNodeName().equals("")) continue;
            if (this.isTransferable && includeTable.getIncludeColumns().isEmpty() && includeTable.getExcludeColumns().isEmpty()) {
                this.printParams(Collections.singletonList(new IncludeColumn("Loading...")), node);
            }
            this.printParams(includeTable.getIncludeColumns(), node);
            this.printParams(includeTable.getExcludeColumns(), node);
            parent.add(node);
        }
    }

    private void printChildren(FilterContainer container, DbImportTreeNode parent) {
        this.printIncludeTables(container.getIncludeTables(), parent);
        this.printParams(container.getExcludeTables(), parent);
        this.printParams(container.getIncludeColumns(), parent);
        this.printParams(container.getExcludeColumns(), parent);
        this.printParams(container.getIncludeProcedures(), parent);
        this.printParams(container.getExcludeProcedures(), parent);
    }

    private void printSchemas(Collection<Schema> schemas, DbImportTreeNode parent) {
        for (Schema schema : schemas) {
            DbImportTreeNode node = !this.isTransferable ? new DbImportTreeNode(schema) : new TransferableNode(schema);
            if (node.getSimpleNodeName().equals("")) continue;
            this.printChildren(schema, node);
            parent.add(node);
        }
    }

    private void printCatalogs(Collection<Catalog> catalogs, DbImportTreeNode parent) {
        for (Catalog catalog : catalogs) {
            DbImportTreeNode node = !this.isTransferable ? new DbImportTreeNode(catalog) : new TransferableNode(catalog);
            if (node.getSimpleNodeName().equals("")) continue;
            this.printSchemas(catalog.getSchemas(), node);
            this.printChildren(catalog, node);
            parent.add(node);
        }
    }

    private void createTreeExpandListener() {
        TreeExpansionListener treeExpansionListener = new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object lastPathComponent = path.getLastPathComponent();
                if (!(lastPathComponent instanceof TransferableNode)) {
                    return;
                }
                DbImportTreeNode node = (DbImportTreeNode)lastPathComponent;
                if (node.isIncludeTable() && !node.isLoaded()) {
                    LoadDbSchemaAction action = Application.getInstance().getActionManager().getAction(LoadDbSchemaAction.class);
                    action.performAction(null, path);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        };
        this.addTreeExpansionListener(treeExpansionListener);
    }

    public DbImportTreeNode getSelectedNode() {
        return (DbImportTreeNode)this.getSelectionPath().getLastPathComponent();
    }

    public DbImportTreeNode getRootNode() {
        return (DbImportTreeNode)this.getModel().getRoot();
    }

    public ReverseEngineering getReverseEngineering() {
        return this.reverseEngineering;
    }

    public void setReverseEngineering(ReverseEngineering reverseEngineering) {
        this.reverseEngineering = reverseEngineering;
    }

    public boolean isTransferable() {
        return this.isTransferable;
    }
}

