/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.WarningDialogByDbTargetChange;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.project.extension.info.ObjectInfo;

public class DbRelationshipTableModel
extends CayenneTableModel<DbRelationship> {
    static final int NAME = 0;
    static final int TARGET = 1;
    static final int TO_DEPENDENT_KEY = 2;
    static final int CARDINALITY = 3;
    static final int COMMENTS = 4;
    protected DbEntity entity;

    public DbRelationshipTableModel(DbEntity entity, ProjectController mediator, Object eventSource) {
        super(mediator, eventSource, new ArrayList<DbRelationship>(entity.getRelationships()));
        this.entity = entity;
    }

    @Override
    public Class getElementsClass() {
        return DbRelationship.class;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Target";
            }
            case 2: {
                return "To Dep PK";
            }
            case 3: {
                return "To Many";
            }
            case 4: {
                return "Comment";
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 1: {
                return DbEntity.class;
            }
            case 2: 
            case 3: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public DbRelationship getRelationship(int row) {
        return row >= 0 && row < this.objectList.size() ? (DbRelationship)this.objectList.get(row) : null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        DbRelationship rel = this.getRelationship(row);
        if (rel == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return rel.getName();
            }
            case 1: {
                return rel.getTargetEntity();
            }
            case 2: {
                return rel.isToDependentPK() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return rel.isToMany() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getComment(rel);
            }
        }
        return null;
    }

    private String getComment(DbRelationship rel) {
        return ObjectInfo.getFromMetaData(this.mediator.getApplication().getMetaData(), rel, "comment");
    }

    private void setComment(String newVal, DbRelationship rel) {
        ObjectInfo.putToMetaData(this.mediator.getApplication().getMetaData(), rel, "comment", newVal);
    }

    @Override
    public void setUpdatedValueAt(Object aValue, int row, int column) {
        DbRelationship rel = this.getRelationship(row);
        if (column == 0) {
            RelationshipEvent e = new RelationshipEvent(this.eventSource, (Relationship)rel, (Entity)this.entity, rel.getName());
            rel.setName((String)aValue);
            this.mediator.fireDbRelationshipEvent(e);
            this.fireTableCellUpdated(row, column);
        } else if (column == 1) {
            DbEntity target = (DbEntity)aValue;
            if (WarningDialogByDbTargetChange.showWarningDialog(this.mediator, rel)) {
                rel.removeAllJoins();
                rel.setTargetEntityName(target);
            }
            this.mediator.fireDbRelationshipEvent(new RelationshipEvent(this.eventSource, rel, this.entity));
        } else if (column == 2) {
            DbRelationship reverse;
            boolean flag = (Boolean)aValue;
            if (flag && (reverse = rel.getReverseRelationship()) != null && reverse.isToDependentPK()) {
                String message = "Unset reverse relationship's \"To Dep PK\" setting?";
                int answer = JOptionPane.showConfirmDialog(Application.getFrame(), message);
                if (answer != 0) {
                    return;
                }
                reverse.setToDependentPK(false);
            }
            rel.setToDependentPK(flag);
            this.mediator.fireDbRelationshipEvent(new RelationshipEvent(this.eventSource, rel, this.entity));
        } else if (column == 3) {
            rel.setToMany((Boolean)aValue);
            this.mediator.fireDbRelationshipEvent(new RelationshipEvent(this.eventSource, rel, this.entity));
            this.updateDependentObjRelationships(rel);
        } else if (column == 4) {
            this.setComment((String)aValue, rel);
            this.mediator.fireDbRelationshipEvent(new RelationshipEvent(this.eventSource, rel, this.entity));
        }
        this.fireTableRowsUpdated(row, row);
    }

    void removeRelationship(DbRelationship rel) {
        this.objectList.remove(rel);
        this.fireTableDataChanged();
    }

    void updateDependentObjRelationships(DbRelationship relationship) {
        Collection<ObjRelationship> objRelationshipsForDbRelationship = ProjectUtil.findObjRelationshipsForDbRelationship(this.mediator, relationship);
        for (ObjRelationship objRelationship : objRelationshipsForDbRelationship) {
            objRelationship.recalculateToManyValue();
            objRelationship.recalculateReadOnlyValue();
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        DbRelationship rel = this.getRelationship(row);
        if (rel == null) {
            return false;
        }
        if (col == 2) {
            return rel.isValidForDepPk();
        }
        return true;
    }

    @Override
    public boolean isColumnSortable(int sortCol) {
        return true;
    }

    @Override
    public void sortByColumn(int sortCol, boolean isAscent) {
        switch (sortCol) {
            case 0: {
                this.sortByElementProperty("name", isAscent);
                break;
            }
            case 1: {
                this.sortByElementProperty("targetEntityName", isAscent);
                break;
            }
            case 2: {
                this.sortByElementProperty("toDependentPK", isAscent);
                break;
            }
            case 3: {
                this.sortByElementProperty("toMany", isAscent);
            }
        }
    }
}

