/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.io.File;
import java.util.function.Predicate;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.editor.cgen.GeneratorControllerPanel;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.CodeValidationUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public abstract class GeneratorController
extends CayenneController {
    protected String mode = ArtifactsGenerationMode.ENTITY.getLabel();
    protected CgenConfiguration cgenConfiguration;

    public GeneratorController(CodeGeneratorControllerBase parent) {
        super(parent);
        this.createView();
        this.initBindings(new BindingBuilder(this.getApplication().getBindingFactory(), this));
    }

    protected void initBindings(BindingBuilder bindingBuilder) {
        JButton outputSelect = ((GeneratorControllerPanel)this.getView()).getSelectOutputFolder();
        bindingBuilder.bindToAction(outputSelect, "selectOutputFolderAction()");
    }

    protected CodeGeneratorControllerBase getParentController() {
        return (CodeGeneratorControllerBase)this.getParent();
    }

    protected abstract GeneratorControllerPanel createView();

    protected void initForm(CgenConfiguration cgenConfiguration) {
        this.cgenConfiguration = cgenConfiguration;
        ((GeneratorControllerPanel)this.getView()).getOutputFolder().setText(cgenConfiguration.buildPath().toString());
        if (cgenConfiguration.getArtifactsGenerationMode().equalsIgnoreCase("all")) {
            ((CodeGeneratorControllerBase)this.parent).setCurrentClass(cgenConfiguration.getDataMap());
            ((CodeGeneratorControllerBase)this.parent).setSelected(true);
        }
    }

    public abstract void updateConfiguration(CgenConfiguration var1);

    public void validateEmbeddable(ValidationResult validationBuffer, Embeddable embeddable) {
        ValidationFailure embeddableFailure = this.validateEmbeddable(embeddable);
        if (embeddableFailure != null) {
            validationBuffer.addFailure(embeddableFailure);
            return;
        }
        for (EmbeddableAttribute attribute : embeddable.getAttributes()) {
            ValidationFailure failure = this.validateEmbeddableAttribute(attribute);
            if (failure == null) continue;
            validationBuffer.addFailure(failure);
            return;
        }
    }

    private ValidationFailure validateEmbeddableAttribute(EmbeddableAttribute attribute) {
        return this.validateAttribute(attribute.getEmbeddable().getClassName(), attribute.getName(), attribute.getType());
    }

    private ValidationFailure validateAttribute(String objectName, String attributeName, String attributeType) {
        ValidationFailure emptyName = BeanValidationFailure.validateNotEmpty((Object)objectName, "attribute.name", attributeName);
        if (emptyName != null) {
            return emptyName;
        }
        ValidationFailure badName = CodeValidationUtil.validateJavaIdentifier(objectName, "attribute.name", attributeName);
        if (badName != null) {
            return badName;
        }
        ValidationFailure emptyType = BeanValidationFailure.validateNotEmpty((Object)objectName, "attribute.type", attributeType);
        if (emptyType != null) {
            return emptyType;
        }
        return BeanValidationFailure.validateJavaClassName(objectName, "attribute.type", attributeType);
    }

    private ValidationFailure validateEmbeddable(Embeddable embeddable) {
        String name = embeddable.getClassName();
        ValidationFailure emptyClass = BeanValidationFailure.validateNotEmpty((Object)name, "className", embeddable.getClassName());
        if (emptyClass != null) {
            return emptyClass;
        }
        return BeanValidationFailure.validateJavaClassName(name, "className", embeddable.getClassName());
    }

    public void validateEntity(ValidationResult validationBuffer, ObjEntity entity, boolean clientValidation) {
        ValidationFailure failure;
        ValidationFailure entityFailure = this.validateEntity(clientValidation ? entity.getClientEntity() : entity);
        if (entityFailure != null) {
            validationBuffer.addFailure(entityFailure);
            return;
        }
        for (ObjAttribute attribute : entity.getAttributes()) {
            if (attribute instanceof EmbeddedAttribute) {
                EmbeddedAttribute embeddedAttribute = (EmbeddedAttribute)attribute;
                for (ObjAttribute subAttribute : embeddedAttribute.getAttributes()) {
                    ValidationFailure failure2 = this.validateEmbeddedAttribute(subAttribute);
                    if (failure2 == null) continue;
                    validationBuffer.addFailure(failure2);
                    return;
                }
                continue;
            }
            failure = this.validateAttribute(attribute);
            if (failure == null) continue;
            validationBuffer.addFailure(failure);
            return;
        }
        for (ObjRelationship rel : entity.getRelationships()) {
            failure = this.validateRelationship(rel, clientValidation);
            if (failure == null) continue;
            validationBuffer.addFailure(failure);
            return;
        }
    }

    private ValidationFailure validateEntity(ObjEntity entity) {
        String name = entity.getName();
        if (entity.isGeneric()) {
            return new SimpleValidationFailure(name, "Generic class");
        }
        ValidationFailure emptyClass = BeanValidationFailure.validateNotEmpty((Object)name, "className", entity.getClassName());
        if (emptyClass != null) {
            return emptyClass;
        }
        ValidationFailure badClass = BeanValidationFailure.validateJavaClassName(name, "className", entity.getClassName());
        if (badClass != null) {
            return badClass;
        }
        if (entity.getSuperClassName() != null) {
            return BeanValidationFailure.validateJavaClassName(name, "superClassName", entity.getSuperClassName());
        }
        return null;
    }

    private ValidationFailure validateAttribute(ObjAttribute attribute) {
        return this.validateAttribute(attribute.getEntity().getName(), attribute.getName(), attribute.getType());
    }

    private ValidationFailure validateEmbeddedAttribute(ObjAttribute attribute) {
        String name = attribute.getEntity().getName();
        String[] attributes = attribute.getName().split("\\.");
        String nameEmbeddedAttribute = attributes[0];
        int beginIndex = attributes[0].length();
        String attr = attribute.getName().substring(beginIndex + 1);
        ValidationFailure emptyEmbeddedName = BeanValidationFailure.validateNotEmpty((Object)name, "attribute.name", nameEmbeddedAttribute);
        if (emptyEmbeddedName != null) {
            return emptyEmbeddedName;
        }
        ValidationFailure badEmbeddedName = CodeValidationUtil.validateJavaIdentifier(name, "attribute.name", nameEmbeddedAttribute);
        if (badEmbeddedName != null) {
            return badEmbeddedName;
        }
        return this.validateAttribute(name, attr, attribute.getType());
    }

    private ValidationFailure validateRelationship(ObjRelationship relationship, boolean clientValidation) {
        String name = relationship.getSourceEntity().getName();
        ValidationFailure emptyName = BeanValidationFailure.validateNotEmpty((Object)name, "relationship.name", relationship.getName());
        if (emptyName != null) {
            return emptyName;
        }
        ValidationFailure badName = CodeValidationUtil.validateJavaIdentifier(name, "relationship.name", relationship.getName());
        if (badName != null) {
            return badName;
        }
        if (!relationship.isToMany()) {
            ObjEntity targetEntity = relationship.getTargetEntity();
            if (clientValidation && targetEntity != null) {
                targetEntity = targetEntity.getClientEntity();
            }
            if (targetEntity == null) {
                return new BeanValidationFailure(name, "relationship.targetEntity", "No target entity");
            }
            if (!targetEntity.isGeneric()) {
                ValidationFailure emptyClass = BeanValidationFailure.validateNotEmpty((Object)name, "relationship.targetEntity.className", targetEntity.getClassName());
                if (emptyClass != null) {
                    return emptyClass;
                }
                return BeanValidationFailure.validateJavaClassName(name, "relationship.targetEntity.className", targetEntity.getClassName());
            }
        }
        return null;
    }

    public Predicate<Object> getDefaultClassFilter() {
        return object -> {
            if (object instanceof ObjEntity) {
                return this.getParentController().getProblem(((ObjEntity)object).getName()) == null;
            }
            if (object instanceof Embeddable) {
                return this.getParentController().getProblem(((Embeddable)object).getClassName()) == null;
            }
            return false;
        };
    }

    public void selectOutputFolderAction() {
        TextAdapter outputFolder = ((GeneratorControllerPanel)this.getView()).getOutputFolder();
        String currentDir = outputFolder.getComponent().getText();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogType(0);
        if (!Util.isEmptyString(currentDir)) {
            chooser.setCurrentDirectory(new File(currentDir));
        } else {
            FSPath lastDir = Application.getInstance().getFrameController().getLastDirectory();
            lastDir.updateChooser(chooser);
        }
        int result = chooser.showOpenDialog(this.getView());
        if (result == 0) {
            File selected = chooser.getSelectedFile();
            String path = selected.getAbsolutePath();
            ((GeneratorControllerPanel)this.getView()).getOutputFolder().setText(path);
            ((GeneratorControllerPanel)this.getView()).getOutputFolder().updateModel();
        }
    }
}

