/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactoryProvider;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.DBWizardAction;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.dialog.db.DbActionOptionsDialog;
import org.apache.cayenne.modeler.dialog.db.merge.MergerOptions;

public class MigrateAction
extends DBWizardAction<DbActionOptionsDialog> {
    private boolean dialogShown;

    public MigrateAction(Application application) {
        super(MigrateAction.getActionName(), application);
    }

    public static String getActionName() {
        return "Migrate Database Schema";
    }

    @Override
    public void performAction(ActionEvent e) {
        DataSourceWizard connectWizard = this.dataSourceWizardDialog("Migrate DB Schema: Connect to Database");
        if (connectWizard == null) {
            return;
        }
        DataMap map = this.getProjectController().getCurrentDataMap();
        if (map == null) {
            throw new IllegalStateException("No current DataMap selected.");
        }
        this.dialogShown = false;
        Object optionsDialog = this.loaderOptionDialog(connectWizard);
        if (this.dialogShown && optionsDialog == null) {
            return;
        }
        String selectedCatalog = optionsDialog == null ? null : ((DbActionOptionsDialog)optionsDialog).getSelectedCatalog();
        String selectedSchema = optionsDialog == null ? null : ((DbActionOptionsDialog)optionsDialog).getSelectedSchema();
        MergerTokenFactoryProvider mergerTokenFactoryProvider = this.getApplication().getInjector().getInstance(MergerTokenFactoryProvider.class);
        new MergerOptions(this.getProjectController(), "Migrate DB Schema: Options", connectWizard.getConnectionInfo(), map, selectedCatalog, selectedSchema, mergerTokenFactoryProvider).startupAction();
    }

    @Override
    protected DbActionOptionsDialog createDialog(Collection<String> catalogs, Collection<String> schemas, String currentCatalog, String currentSchema, int command) {
        this.dialogShown = true;
        switch (command) {
            case 1: {
                return new DbActionOptionsDialog(Application.getFrame(), "Migrate DB Schema: Select Catalog and Schema", catalogs, schemas, currentCatalog, currentSchema);
            }
        }
        return null;
    }
}

