/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sybase;

import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTExtract;
import org.apache.cayenne.exp.parser.ASTFunctionCall;

public class SybaseQualifierTranslator
extends QualifierTranslator {
    public SybaseQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "MOD": 
            case "CONCAT": {
                break;
            }
            case "LENGTH": {
                this.out.append("LEN");
                break;
            }
            case "LOCATE": {
                this.out.append("CHARINDEX");
                break;
            }
            default: {
                super.appendFunction(functionExpression);
            }
        }
    }

    @Override
    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "MOD": {
                this.out.append(" % ");
                break;
            }
            case "CONCAT": {
                this.out.append(" + ");
                break;
            }
            default: {
                super.appendFunctionArgDivider(functionExpression);
            }
        }
    }

    @Override
    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "MOD": 
            case "CONCAT": {
                this.out.delete(this.out.length() - 3, this.out.length());
                break;
            }
            default: {
                super.clearLastFunctionArgDivider(functionExpression);
            }
        }
        if (functionExpression instanceof ASTExtract) {
            this.out.append(")");
        }
    }

    @Override
    protected boolean parenthesisNeeded(Expression node, Expression parentNode) {
        if (node.getType() == 45 && node instanceof ASTExtract) {
            return false;
        }
        return super.parenthesisNeeded(node, parentNode);
    }

    @Override
    protected void appendExtractFunction(ASTExtract functionExpression) {
        this.out.append("datepart(");
        switch (functionExpression.getPart()) {
            case DAY_OF_MONTH: {
                this.out.append("day");
                break;
            }
            case DAY_OF_WEEK: {
                this.out.append("weekday");
                break;
            }
            case DAY_OF_YEAR: {
                this.out.append("dayofyear");
                break;
            }
            default: {
                this.out.append(functionExpression.getPart().name().toLowerCase());
            }
        }
        this.out.append(" , ");
    }
}

