/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import org.apache.cayenne.access.translator.procedure.ProcedureTranslator;
import org.apache.cayenne.map.Procedure;

public class HSQLDBProcedureTranslator
extends ProcedureTranslator {
    @Override
    protected String createSqlString() {
        Procedure procedure = this.getProcedure();
        StringBuilder buf = new StringBuilder();
        int totalParams = this.callParams.size();
        if (procedure.isReturningValue()) {
            --totalParams;
            buf.append("{?= call ");
        } else {
            buf.append("{call ");
        }
        if (procedure.getFullyQualifiedName().indexOf(46) > -1) {
            buf.append("\"").append(procedure.getFullyQualifiedName()).append("\"");
        } else {
            buf.append(procedure.getFullyQualifiedName());
        }
        if (totalParams > 0) {
            buf.append("(?");
            for (int i = 1; i < totalParams; ++i) {
                buf.append(", ?");
            }
            buf.append(")");
        }
        buf.append("}");
        return buf.toString();
    }
}

