/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache.invalidation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.annotation.PrePersist;
import org.apache.cayenne.annotation.PreRemove;
import org.apache.cayenne.annotation.PreUpdate;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.invalidation.CacheGroupDescriptor;
import org.apache.cayenne.cache.invalidation.InvalidationFunction;
import org.apache.cayenne.cache.invalidation.InvalidationHandler;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.query.Query;

public class CacheInvalidationFilter
implements DataChannelFilter {
    private final Provider<QueryCache> cacheProvider;
    private final List<InvalidationHandler> handlers;
    private final Map<Class<? extends Persistent>, InvalidationFunction> mappedHandlers = new ConcurrentHashMap<Class<? extends Persistent>, InvalidationFunction>();
    private final InvalidationFunction skipHandler = new InvalidationFunction(){

        @Override
        public Collection<CacheGroupDescriptor> apply(Persistent p) {
            return Collections.emptyList();
        }
    };
    private final ThreadLocal<Set<CacheGroupDescriptor>> groups = new ThreadLocal();

    public CacheInvalidationFilter(@Inject Provider<QueryCache> cacheProvider, @Inject List<InvalidationHandler> handlers) {
        this.cacheProvider = cacheProvider;
        this.handlers = handlers;
    }

    public void init(DataChannel channel) {
    }

    public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
        return filterChain.onQuery(originatingContext, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelFilterChain filterChain) {
        try {
            GraphDiff result = filterChain.onSync(originatingContext, changes, syncType);
            Collection groupSet = this.groups.get();
            if (groupSet != null && !groupSet.isEmpty()) {
                QueryCache cache = (QueryCache)this.cacheProvider.get();
                for (CacheGroupDescriptor group : groupSet) {
                    if (group.getKeyType() != Void.class) {
                        cache.removeGroup(group.getCacheGroupName(), group.getKeyType(), group.getValueType());
                        continue;
                    }
                    cache.removeGroup(group.getCacheGroupName());
                }
            }
            GraphDiff graphDiff = result;
            return graphDiff;
        }
        finally {
            this.groups.set(null);
        }
    }

    @PrePersist
    @PreRemove
    @PreUpdate
    protected void preCommit(Object object) {
        Collection<CacheGroupDescriptor> objectGroups;
        Persistent p = (Persistent)object;
        InvalidationFunction invalidationFunction = this.mappedHandlers.get(p.getClass());
        if (invalidationFunction == null) {
            invalidationFunction = this.skipHandler;
            for (InvalidationHandler handler : this.handlers) {
                InvalidationFunction function = handler.canHandle(p.getClass());
                if (function == null) continue;
                invalidationFunction = function;
                break;
            }
            this.mappedHandlers.put(p.getClass(), invalidationFunction);
        }
        if (!(objectGroups = invalidationFunction.apply(p)).isEmpty()) {
            this.getOrCreateTxGroups().addAll(objectGroups);
        }
    }

    protected Set<CacheGroupDescriptor> getOrCreateTxGroups() {
        Set<CacheGroupDescriptor> txGroups = this.groups.get();
        if (txGroups == null) {
            txGroups = new HashSet<CacheGroupDescriptor>();
            this.groups.set(txGroups);
        }
        return txGroups;
    }
}

