/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaUtils {
    private static final Logger logger = LoggerFactory.getLogger(JavaUtils.class);

    public static boolean supportExitOnOutOfMemory(String jreVersion) {
        try {
            int version = JavaUtils.parseJavaVersion(jreVersion);
            if (version > 8) {
                return true;
            }
            int update = JavaUtils.parseUpdateForPre9Versions(jreVersion);
            return version == 7 && update >= 101 || version == 8 && update >= 92;
        }
        catch (Exception e) {
            logger.error("Some JRE information could not be retrieved for the JRE version: " + jreVersion, (Throwable)e);
            return true;
        }
    }

    private static int parseJavaVersion(String jreVersion) {
        String version;
        if (jreVersion.startsWith("1.")) {
            version = jreVersion.substring(2, 3);
        } else {
            int index = jreVersion.indexOf(46);
            if (index < 0 && (index = jreVersion.indexOf(45)) < 0) {
                index = jreVersion.length();
            }
            version = jreVersion.substring(0, index);
        }
        return Integer.parseInt(version);
    }

    private static int parseUpdateForPre9Versions(String jreVersion) {
        int updateSeparatorIndex;
        int dashSeparatorIndex = jreVersion.indexOf(45);
        if (dashSeparatorIndex > 0) {
            jreVersion = jreVersion.substring(0, dashSeparatorIndex);
        }
        if ((updateSeparatorIndex = jreVersion.indexOf(95)) < 0) {
            return 0;
        }
        return Integer.parseInt(jreVersion.substring(updateSeparatorIndex + 1));
    }

    private JavaUtils() {
    }
}

