/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.stress.util.SampleOfLongs;

public final class TimingInterval {
    private final long start;
    private final long end;
    public final long maxLatency;
    public final long pauseLength;
    public final long pauseStart;
    public final long totalLatency;
    public final long partitionCount;
    public final long rowCount;
    public final long operationCount;
    public final long errorCount;
    final SampleOfLongs sample;

    public String toString() {
        return String.format("Start: %d end: %d maxLatency: %d pauseLength: %d pauseStart: %d totalLatency: %d pCount: %d rcount: %d opCount: %d errors: %d", this.start, this.end, this.maxLatency, this.pauseLength, this.pauseStart, this.totalLatency, this.partitionCount, this.rowCount, this.operationCount, this.errorCount);
    }

    TimingInterval(long time) {
        this.start = this.end = time;
        this.totalLatency = 0L;
        this.maxLatency = 0L;
        this.errorCount = 0L;
        this.operationCount = 0L;
        this.rowCount = 0L;
        this.partitionCount = 0L;
        this.pauseLength = 0L;
        this.pauseStart = 0L;
        this.sample = new SampleOfLongs(new long[0], 1.0);
    }

    TimingInterval(long start, long end, long maxLatency, long pauseStart, long pauseLength, long partitionCount, long rowCount, long totalLatency, long operationCount, long errorCount, SampleOfLongs sample) {
        this.start = start;
        this.end = Math.max(end, start);
        this.maxLatency = maxLatency;
        this.partitionCount = partitionCount;
        this.rowCount = rowCount;
        this.totalLatency = totalLatency;
        this.errorCount = errorCount;
        this.operationCount = operationCount;
        this.pauseStart = pauseStart;
        this.pauseLength = pauseLength;
        this.sample = sample;
    }

    static TimingInterval merge(Iterable<TimingInterval> intervals, int maxSamples, long start) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long operationCount = 0L;
        long partitionCount = 0L;
        long rowCount = 0L;
        long errorCount = 0L;
        long maxLatency = 0L;
        long totalLatency = 0L;
        ArrayList<SampleOfLongs> latencies = new ArrayList<SampleOfLongs>();
        long end = 0L;
        long pauseStart = 0L;
        long pauseEnd = Long.MAX_VALUE;
        for (TimingInterval interval : intervals) {
            if (interval == null) continue;
            end = Math.max(end, interval.end);
            operationCount += interval.operationCount;
            maxLatency = Math.max(interval.maxLatency, maxLatency);
            totalLatency += interval.totalLatency;
            partitionCount += interval.partitionCount;
            rowCount += interval.rowCount;
            errorCount += interval.errorCount;
            latencies.addAll(Arrays.asList(interval.sample));
            if (interval.pauseLength <= 0L) continue;
            pauseStart = Math.max(pauseStart, interval.pauseStart);
            pauseEnd = Math.min(pauseEnd, interval.pauseStart + interval.pauseLength);
        }
        if (pauseEnd < pauseStart || pauseStart <= 0L) {
            pauseStart = 0L;
            pauseEnd = 0L;
        }
        return new TimingInterval(start, end, maxLatency, pauseStart, pauseEnd - pauseStart, partitionCount, rowCount, totalLatency, operationCount, errorCount, SampleOfLongs.merge(rnd, latencies, maxSamples));
    }

    public double opRate() {
        return (double)this.operationCount / ((double)(this.end - this.start) * 1.0E-9);
    }

    public double adjustedRowRate() {
        return (double)this.rowCount / ((double)(this.end - (this.start + this.pauseLength)) * 1.0E-9);
    }

    public double partitionRate() {
        return (double)this.partitionCount / ((double)(this.end - this.start) * 1.0E-9);
    }

    public double rowRate() {
        return (double)this.rowCount / ((double)(this.end - this.start) * 1.0E-9);
    }

    public double meanLatency() {
        return (double)this.totalLatency / (double)this.operationCount * 1.0E-6;
    }

    public double maxLatency() {
        return (double)this.maxLatency * 1.0E-6;
    }

    public double medianLatency() {
        return this.sample.medianLatency();
    }

    public double rankLatency(float rank) {
        return this.sample.rankLatency(rank);
    }

    public long runTime() {
        return (this.end - this.start) / 1000000L;
    }

    public final long endNanos() {
        return this.end;
    }

    public long startNanos() {
        return this.start;
    }

    String getStringValue(TimingParameter value) {
        return this.getStringValue(value, Float.NaN);
    }

    String getStringValue(TimingParameter value, float rank) {
        switch (value) {
            case OPRATE: {
                return String.format("%.0f", this.opRate());
            }
            case ROWRATE: {
                return String.format("%.0f", this.rowRate());
            }
            case ADJROWRATE: {
                return String.format("%.0f", this.adjustedRowRate());
            }
            case PARTITIONRATE: {
                return String.format("%.0f", this.partitionRate());
            }
            case MEANLATENCY: {
                return String.format("%.1f", this.meanLatency());
            }
            case MAXLATENCY: {
                return String.format("%.1f", this.maxLatency());
            }
            case MEDIANLATENCY: {
                return String.format("%.1f", this.medianLatency());
            }
            case RANKLATENCY: {
                return String.format("%.1f", this.rankLatency(rank));
            }
            case ERRORCOUNT: {
                return String.format("%d", this.errorCount);
            }
            case PARTITIONCOUNT: {
                return String.format("%d", this.partitionCount);
            }
        }
        throw new IllegalStateException();
    }

    public static enum TimingParameter {
        OPRATE,
        ROWRATE,
        ADJROWRATE,
        PARTITIONRATE,
        MEANLATENCY,
        MAXLATENCY,
        MEDIANLATENCY,
        RANKLATENCY,
        ERRORCOUNT,
        PARTITIONCOUNT;

    }
}

