/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.datastructures;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Preconditions;

public class AbstractLongListUtil {
    public static boolean isSorted(LongArrayList l, boolean unique) {
        for (int i = 1; i < l.size(); ++i) {
            if (l.get(i) >= l.get(i - 1) && (!unique || l.get(i) != l.get(i - 1))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(LongArrayList l) {
        return AbstractLongListUtil.isSorted(l, false);
    }

    public static LongArrayList mergeSort(LongArrayList a, LongArrayList b) {
        int posa = 0;
        int posb = 0;
        LongArrayList result = new LongArrayList(a.size() + b.size());
        while (posa < a.size() || posb < b.size()) {
            long next = posa >= a.size() ? b.get(posb++) : (posb >= b.size() ? a.get(posa++) : (a.get(posa) <= b.get(posb) ? a.get(posa++) : b.get(posb++)));
            Preconditions.checkArgument((result.isEmpty() || result.get(result.size() - 1) <= next ? 1 : 0) != 0, (Object)"The input lists are not sorted");
            result.add(next);
        }
        return result;
    }

    public static LongArrayList mergeJoin(LongArrayList a, LongArrayList b, boolean unique) {
        assert (AbstractLongListUtil.isSorted(a)) : a.toString();
        assert (AbstractLongListUtil.isSorted(b)) : b.toString();
        int counterA = 0;
        int counterB = 0;
        int sizeA = a.size();
        int sizeB = b.size();
        LongArrayList merge = new LongArrayList(Math.min(sizeA, sizeB));
        int resultSize = 0;
        while (counterA < sizeA && counterB < sizeB) {
            if (a.get(counterA) == b.get(counterB)) {
                long value = a.get(counterA);
                if (!unique) {
                    merge.add(value);
                    ++resultSize;
                } else if (resultSize <= 0 || merge.get(resultSize - 1) != value) {
                    merge.add(value);
                    ++resultSize;
                }
                ++counterA;
                ++counterB;
                continue;
            }
            if (a.get(counterA) < b.get(counterB)) {
                ++counterA;
                continue;
            }
            assert (a.get(counterA) > b.get(counterB));
            ++counterB;
        }
        return merge;
    }

    public static LongArrayList singleton(long el) {
        LongArrayList l = new LongArrayList(1);
        l.add(el);
        return l;
    }
}

