/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.system;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.types.system.EmptyRelationType;
import com.thinkaurelius.titan.graphdb.types.system.SystemRelationType;
import org.apache.commons.lang.StringUtils;

public abstract class BaseRelationType
extends EmptyRelationType
implements SystemRelationType {
    private final String name;
    private final long id;

    BaseRelationType(String name, long id, TitanSchemaCategory type) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        this.name = "system%&%" + name;
        this.id = BaseRelationType.getSystemTypeId(id, type);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getLongId() {
        return this.id;
    }

    @Override
    public boolean hasId() {
        return true;
    }

    @Override
    public void setId(long id) {
        throw new IllegalStateException("SystemType has already been assigned an id");
    }

    @Override
    public ConsistencyModifier getConsistencyModifier() {
        return ConsistencyModifier.LOCK;
    }

    @Override
    public boolean isHiddenType() {
        return true;
    }

    static long getSystemTypeId(long id, TitanSchemaCategory type) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)type.isRelationType());
        switch (type) {
            case EDGELABEL: {
                return IDManager.getSchemaId(IDManager.VertexIDType.SystemEdgeLabel, id);
            }
            case PROPERTYKEY: {
                return IDManager.getSchemaId(IDManager.VertexIDType.SystemPropertyKey, id);
            }
        }
        throw new AssertionError((Object)("Illegal argument: " + (Object)((Object)type)));
    }
}

