/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.indextype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.types.IndexField;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.SchemaSource;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.tinkerpop.blueprints.Direction;
import java.util.Map;

public abstract class IndexTypeWrapper
implements IndexType {
    protected final SchemaSource base;
    private volatile Map<PropertyKey, IndexField> fieldMap = null;
    private volatile boolean cachedTypeConstraint = false;
    private volatile TitanSchemaType schemaTypeConstraint = null;

    public IndexTypeWrapper(SchemaSource base) {
        Preconditions.checkNotNull((Object)base);
        this.base = base;
    }

    public SchemaSource getSchemaBase() {
        return this.base;
    }

    @Override
    public ElementCategory getElement() {
        return this.base.getDefinition().getValue(TypeDefinitionCategory.ELEMENT_CATEGORY, ElementCategory.class);
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        IndexTypeWrapper other = (IndexTypeWrapper)oth;
        return this.base.equals(other.base);
    }

    public String toString() {
        return this.base.getName();
    }

    @Override
    public String getName() {
        return this.base.getName();
    }

    @Override
    public IndexField getField(PropertyKey key) {
        ImmutableMap result = this.fieldMap;
        if (result == null) {
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (IndexField f : this.getFieldKeys()) {
                b.put((Object)f.getFieldKey(), (Object)f);
            }
            this.fieldMap = result = b.build();
        }
        assert (result != null);
        return result.get(key);
    }

    @Override
    public boolean hasSchemaTypeConstraint() {
        return this.getSchemaTypeConstraint() != null;
    }

    @Override
    public TitanSchemaType getSchemaTypeConstraint() {
        TitanSchemaType constraint;
        if (!this.cachedTypeConstraint) {
            Iterable<SchemaSource.Entry> related = this.base.getRelated(TypeDefinitionCategory.INDEX_SCHEMA_CONSTRAINT, Direction.OUT);
            if (Iterables.isEmpty(related)) {
                constraint = null;
            } else {
                constraint = (TitanSchemaType)((Object)((SchemaSource.Entry)Iterables.getOnlyElement(related, null)).getSchemaType());
                assert (constraint != null);
            }
            this.schemaTypeConstraint = constraint;
            this.cachedTypeConstraint = true;
        } else {
            constraint = this.schemaTypeConstraint;
        }
        return constraint;
    }

    @Override
    public void resetCache() {
        this.base.resetCache();
        this.fieldMap = null;
    }

    @Override
    public boolean indexesKey(PropertyKey key) {
        return this.getField(key) != null;
    }

    @Override
    public String getBackingIndexName() {
        return this.base.getDefinition().getValue(TypeDefinitionCategory.BACKING_INDEX, String.class);
    }
}

