/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;

public class TypeDefinitionDescription {
    private TypeDefinitionCategory category;
    private Object modifier;

    private TypeDefinitionDescription() {
    }

    public TypeDefinitionDescription(TypeDefinitionCategory category, Object modifier) {
        Preconditions.checkNotNull((Object)((Object)category));
        if (category.isProperty()) {
            Preconditions.checkArgument((modifier == null ? 1 : 0) != 0);
        } else {
            Preconditions.checkArgument((boolean)category.isEdge());
            if (category.hasDataType()) {
                Preconditions.checkArgument((modifier == null || modifier.getClass().equals(category.getDataType()) ? 1 : 0) != 0);
            } else {
                Preconditions.checkArgument((modifier == null ? 1 : 0) != 0);
            }
        }
        this.category = category;
        this.modifier = modifier;
    }

    public static TypeDefinitionDescription of(TypeDefinitionCategory category) {
        return new TypeDefinitionDescription(category, null);
    }

    public TypeDefinitionCategory getCategory() {
        return this.category;
    }

    public Object getModifier() {
        return this.modifier;
    }
}

