/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.graphdb.internal.AbstractElement;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.tinkerpop.blueprints.Direction;
import java.util.Comparator;

public class RelationComparator
implements Comparator<InternalRelation> {
    private final StandardTitanTx tx;
    private final InternalVertex vertex;
    private final OrderList orders;

    public RelationComparator(InternalVertex v) {
        this(v, OrderList.NO_ORDER);
    }

    public RelationComparator(InternalVertex v, OrderList orders) {
        Preconditions.checkArgument((v != null && orders != null ? 1 : 0) != 0);
        this.vertex = v;
        this.tx = v.tx();
        this.orders = orders;
    }

    @Override
    public int compare(InternalRelation r1, InternalRelation r2) {
        int i;
        InternalRelationType t2;
        int reltypecompare;
        if (r1.equals(r2)) {
            return 0;
        }
        if (!this.orders.isEmpty()) {
            for (OrderList.OrderEntry order : this.orders) {
                int orderCompare = this.compareOnKey((TitanRelation)r1, (TitanRelation)r2, order.getKey(), order.getOrder());
                if (orderCompare == 0) continue;
                return orderCompare;
            }
        }
        if ((reltypecompare = (r1.isProperty() ? 1 : 2) - (r2.isProperty() ? 1 : 2)) != 0) {
            return reltypecompare;
        }
        InternalRelationType t1 = (InternalRelationType)r1.getType();
        int typecompare = AbstractElement.compare(t1, t2 = (InternalRelationType)r2.getType());
        if (typecompare != 0) {
            return typecompare;
        }
        assert (t1.equals(t2));
        Direction dir1 = null;
        Direction dir2 = null;
        for (i = 0; i < r1.getLen(); ++i) {
            if (!r1.getVertex(i).equals(this.vertex)) continue;
            dir1 = EdgeDirection.fromPosition(i);
            break;
        }
        for (i = 0; i < r2.getLen(); ++i) {
            if (!r2.getVertex(i).equals(this.vertex)) continue;
            dir2 = EdgeDirection.fromPosition(i);
            break;
        }
        assert (dir1 != null && dir2 != null);
        int dirCompare = EdgeDirection.position(dir1) - EdgeDirection.position(dir2);
        if (dirCompare != 0) {
            return dirCompare;
        }
        if (t1.getMultiplicity().isUnique(dir1)) {
            return 0;
        }
        for (long typeid : t1.getSortKey()) {
            int keycompare = this.compareOnKey((TitanRelation)r1, (TitanRelation)r2, typeid, t1.getSortOrder());
            if (keycompare == 0) continue;
            return keycompare;
        }
        if (r1.isProperty()) {
            Object o1 = ((TitanProperty)((Object)r1)).getValue();
            Object o2 = ((TitanProperty)((Object)r2)).getValue();
            Preconditions.checkArgument((o1 != null && o2 != null ? 1 : 0) != 0);
            if (!o1.equals(o2)) {
                int objectcompare = 0;
                objectcompare = Comparable.class.isAssignableFrom(((PropertyKey)((Object)t1)).getDataType()) ? ((Comparable)o1).compareTo(o2) : System.identityHashCode(o1) - System.identityHashCode(o2);
                if (objectcompare != 0) {
                    return objectcompare;
                }
            }
        } else {
            Preconditions.checkArgument((r1.isEdge() && r2.isEdge() ? 1 : 0) != 0);
            int vertexcompare = AbstractElement.compare(r1.getVertex(EdgeDirection.position(dir1.opposite())), r2.getVertex(EdgeDirection.position(dir1.opposite())));
            if (vertexcompare != 0) {
                return vertexcompare;
            }
        }
        if (t1.getMultiplicity().isConstrained()) {
            return 0;
        }
        return AbstractElement.compare(r1, r2);
    }

    public static int compareValues(Object v1, Object v2, Order order) {
        return RelationComparator.compareValues(v1, v2) * (order == Order.DESC ? -1 : 1);
    }

    public static int compareValues(Object v1, Object v2) {
        if (v1 == null || v2 == null) {
            if (v1 != null) {
                return -1;
            }
            if (v2 != null) {
                return 1;
            }
            return 0;
        }
        Preconditions.checkArgument((v1 instanceof Comparable && v2 instanceof Comparable ? 1 : 0) != 0, (Object)"Encountered invalid values");
        return ((Comparable)v1).compareTo(v2);
    }

    private int compareOnKey(TitanRelation r1, TitanRelation r2, long typeid, Order order) {
        return this.compareOnKey(r1, r2, this.tx.getExistingRelationType(typeid), order);
    }

    private int compareOnKey(TitanRelation r1, TitanRelation r2, RelationType type, Order order) {
        Object v2;
        Object v1;
        if (type.isPropertyKey()) {
            PropertyKey key = (PropertyKey)type;
            v1 = r1.getProperty(key);
            v2 = r2.getProperty(key);
        } else {
            EdgeLabel label = (EdgeLabel)type;
            v1 = r1.getProperty(label);
            v2 = r2.getProperty(label);
        }
        return RelationComparator.compareValues(v1, v2, order);
    }
}

