/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.graphdb.database.serialize.kryo.KryoInstanceCache;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CHMKryos
implements KryoInstanceCache {
    private final Function<Kryo, ?> configurer;
    private final ConcurrentHashMap<Thread, Kryo> kryos;
    private final String selfID;
    private static final Logger log = LoggerFactory.getLogger(CHMKryos.class);

    public CHMKryos(Function<Kryo, ?> configurer) {
        this.configurer = configurer;
        this.kryos = new ConcurrentHashMap();
        this.selfID = String.format("0x%-8s", Integer.toHexString(this.hashCode()));
        log.debug("[{}] Finishing construction", (Object)this.selfID);
    }

    @Override
    public Kryo get() {
        Thread currentThread = Thread.currentThread();
        Kryo k = this.kryos.get(currentThread);
        if (null == k) {
            k = new Kryo();
            this.configurer.apply((Object)k);
            Kryo shouldBeNull = this.kryos.putIfAbsent(currentThread, k);
            Preconditions.checkState((null == shouldBeNull ? 1 : 0) != 0);
            log.debug("[{}] Returning new Kryo instance {} for thread {}", new Object[]{this.selfID, k, currentThread});
        } else {
            log.debug("[{}] Returning cached Kryo instance {} for thread {}", new Object[]{this.selfID, k, currentThread});
        }
        return k;
    }

    @Override
    public void close() {
        int sizeEstimate = this.kryos.size();
        this.kryos.clear();
        log.debug("[{}] Cleared approximately {} cached Kryo instance(s)", (Object)this.selfID, (Object)sizeEstimate);
    }
}

