/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.TemporaryBackendException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendOperation {
    private static final Logger log = LoggerFactory.getLogger(BackendOperation.class);
    private static final Random random = new Random();
    private static final Duration BASE_REATTEMPT_TIME = new StandardDuration(50L, TimeUnit.MILLISECONDS);
    private static final double PERTURBATION_PERCENTAGE = 0.2;

    private static final Duration pertubateTime(Duration duration) {
        Duration newDuration = duration.multiply(1.0 + (random.nextDouble() * 2.0 - 1.0) * 0.2);
        assert (!duration.isZeroLength()) : duration;
        return newDuration;
    }

    public static final <V> V execute(Callable<V> exe, Duration totalWaitTime) throws TitanException {
        try {
            return BackendOperation.executeDirect(exe, totalWaitTime);
        }
        catch (BackendException e) {
            throw new TitanException("Could not execute operation due to backend exception", e);
        }
    }

    public static final <V> V executeDirect(Callable<V> exe, Duration totalWaitTime) throws BackendException {
        Preconditions.checkArgument((!totalWaitTime.isZeroLength() ? 1 : 0) != 0, (String)"Need to specify a positive waitTime: %s", (Object[])new Object[]{totalWaitTime});
        long maxTime = System.currentTimeMillis() + totalWaitTime.getLength(TimeUnit.MILLISECONDS);
        Duration waitTime = BackendOperation.pertubateTime(BASE_REATTEMPT_TIME);
        while (true) {
            try {
                return exe.call();
            }
            catch (Throwable e) {
                Throwable ex = e;
                BackendException storeEx = null;
                do {
                    if (!(ex instanceof BackendException)) continue;
                    storeEx = (BackendException)ex;
                } while ((ex = ex.getCause()) != null);
                if (storeEx == null || !(storeEx instanceof TemporaryBackendException)) {
                    if (e instanceof BackendException) {
                        throw (BackendException)e;
                    }
                    throw new PermanentBackendException("Permanent exception while executing backend operation " + exe.toString(), e);
                }
                BackendException lastException = storeEx;
                assert (lastException != null);
                if (System.currentTimeMillis() + waitTime.getLength(TimeUnit.MILLISECONDS) < maxTime) {
                    log.info("Temporary exception during backend operation [" + exe.toString() + "]. Attempting backoff retry.", (Throwable)lastException);
                    try {
                        Thread.sleep(waitTime.getLength(TimeUnit.MILLISECONDS));
                    }
                    catch (InterruptedException r) {
                        throw new PermanentBackendException("Interrupted while waiting to retry failed backend operation", r);
                    }
                    waitTime = BackendOperation.pertubateTime(waitTime.multiply(2.0));
                    continue;
                }
                throw new TemporaryBackendException("Could not successfully complete backend operation due to repeated temporary exceptions after " + totalWaitTime, lastException);
            }
            break;
        }
    }

    public static <R> R execute(Transactional<R> exe, TransactionalProvider provider, TimestampProvider times) throws BackendException {
        StoreTransaction txh = null;
        try {
            txh = provider.openTx();
            if (!txh.getConfiguration().hasCommitTime()) {
                txh.getConfiguration().setCommitTime(times.getTime());
            }
            R r = exe.call(txh);
            return r;
        }
        catch (BackendException e) {
            if (txh != null) {
                txh.rollback();
            }
            txh = null;
            throw e;
        }
        finally {
            if (txh != null) {
                txh.commit();
            }
        }
    }

    public static <R> R execute(final Transactional<R> exe, final TransactionalProvider provider, final TimestampProvider times, Duration maxTime) throws TitanException {
        return (R)BackendOperation.execute(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return BackendOperation.execute(exe, provider, times);
            }

            public String toString() {
                return exe.toString();
            }
        }, maxTime);
    }

    public static interface TransactionalProvider {
        public StoreTransaction openTx() throws BackendException;

        public void close() throws BackendException;
    }

    public static interface Transactional<R> {
        public R call(StoreTransaction var1) throws BackendException;
    }
}

