/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum StandardIndexProvider {
    LUCENE("com.thinkaurelius.titan.diskstorage.lucene.LuceneIndex", "lucene"),
    ELASTICSEARCH("com.thinkaurelius.titan.diskstorage.es.ElasticSearchIndex", (ImmutableList<String>)ImmutableList.of((Object)"elasticsearch", (Object)"es")),
    SOLR("com.thinkaurelius.titan.diskstorage.solr.SolrIndex", "solr"),
    SOLR5("com.thinkaurelius.titan.diskstorage.solr.Solr5Index", "solr5");

    private final String providerName;
    private final ImmutableList<String> shorthands;
    private static final ImmutableList<String> ALL_SHORTHANDS;
    private static final ImmutableMap<String, String> ALL_MANAGER_CLASSES;

    private StandardIndexProvider(String providerName, String shorthand) {
        this(providerName, (ImmutableList<String>)ImmutableList.of((Object)shorthand));
    }

    private StandardIndexProvider(String providerName, ImmutableList<String> shorthands) {
        this.providerName = providerName;
        this.shorthands = shorthands;
    }

    public List<String> getShorthands() {
        return this.shorthands;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public static final List<String> getAllShorthands() {
        return ALL_SHORTHANDS;
    }

    public static final Map<String, String> getAllProviderClasses() {
        return ALL_MANAGER_CLASSES;
    }

    static {
        StandardIndexProvider[] backends = StandardIndexProvider.values();
        ArrayList<String> tempShorthands = new ArrayList<String>();
        HashMap<String, String> tempClassMap = new HashMap<String, String>();
        for (int i = 0; i < backends.length; ++i) {
            tempShorthands.addAll(backends[i].getShorthands());
            for (String shorthand : backends[i].getShorthands()) {
                tempClassMap.put(shorthand, backends[i].getProviderName());
            }
        }
        ALL_SHORTHANDS = ImmutableList.copyOf(tempShorthands);
        ALL_MANAGER_CLASSES = ImmutableMap.copyOf(tempClassMap);
    }
}

