// Code generated by _tmpl/utils.h.tmpl. DO NOT EDIT.

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// clang-format off
//go:build driverlib
// clang-format on

#pragma once

#include <stdlib.h>
#include "../../drivermgr/arrow-adbc/adbc.h"

struct AdbcError* DatabricksErrorFromArrayStream(struct ArrowArrayStream*,
                                                 AdbcStatusCode*);
AdbcStatusCode DatabricksDatabaseGetOption(struct AdbcDatabase*, const char*, char*,
                                           size_t*, struct AdbcError*);
AdbcStatusCode DatabricksDatabaseGetOptionBytes(struct AdbcDatabase*, const char*,
                                                uint8_t*, size_t*, struct AdbcError*);
AdbcStatusCode DatabricksDatabaseGetOptionDouble(struct AdbcDatabase*, const char*,
                                                 double*, struct AdbcError*);
AdbcStatusCode DatabricksDatabaseGetOptionInt(struct AdbcDatabase*, const char*, int64_t*,
                                              struct AdbcError*);
AdbcStatusCode DatabricksDatabaseInit(struct AdbcDatabase* db, struct AdbcError* err);
AdbcStatusCode DatabricksDatabaseNew(struct AdbcDatabase* db, struct AdbcError* err);
AdbcStatusCode DatabricksDatabaseRelease(struct AdbcDatabase* db, struct AdbcError* err);
AdbcStatusCode DatabricksDatabaseSetOption(struct AdbcDatabase* db, const char* key,
                                           const char* value, struct AdbcError* err);
AdbcStatusCode DatabricksDatabaseSetOptionBytes(struct AdbcDatabase*, const char*,
                                                const uint8_t*, size_t,
                                                struct AdbcError*);
AdbcStatusCode DatabricksDatabaseSetOptionDouble(struct AdbcDatabase*, const char*,
                                                 double, struct AdbcError*);
AdbcStatusCode DatabricksDatabaseSetOptionInt(struct AdbcDatabase*, const char*, int64_t,
                                              struct AdbcError*);

AdbcStatusCode DatabricksConnectionCancel(struct AdbcConnection*, struct AdbcError*);
AdbcStatusCode DatabricksConnectionCommit(struct AdbcConnection* cnxn,
                                          struct AdbcError* err);
AdbcStatusCode DatabricksConnectionGetInfo(struct AdbcConnection* cnxn,
                                           const uint32_t* codes, size_t len,
                                           struct ArrowArrayStream* out,
                                           struct AdbcError* err);
AdbcStatusCode DatabricksConnectionGetObjects(
    struct AdbcConnection* cnxn, int depth, const char* catalog, const char* dbSchema,
    const char* tableName, const char** tableType, const char* columnName,
    struct ArrowArrayStream* out, struct AdbcError* err);
AdbcStatusCode DatabricksConnectionGetOption(struct AdbcConnection*, const char*, char*,
                                             size_t*, struct AdbcError*);
AdbcStatusCode DatabricksConnectionGetOptionBytes(struct AdbcConnection*, const char*,
                                                  uint8_t*, size_t*, struct AdbcError*);
AdbcStatusCode DatabricksConnectionGetOptionDouble(struct AdbcConnection*, const char*,
                                                   double*, struct AdbcError*);
AdbcStatusCode DatabricksConnectionGetOptionInt(struct AdbcConnection*, const char*,
                                                int64_t*, struct AdbcError*);
AdbcStatusCode DatabricksConnectionGetStatistics(struct AdbcConnection*, const char*,
                                                 const char*, const char*, char,
                                                 struct ArrowArrayStream*,
                                                 struct AdbcError*);
AdbcStatusCode DatabricksConnectionGetStatisticNames(struct AdbcConnection*,
                                                     struct ArrowArrayStream*,
                                                     struct AdbcError*);
AdbcStatusCode DatabricksConnectionGetTableSchema(
    struct AdbcConnection* cnxn, const char* catalog, const char* dbSchema,
    const char* tableName, struct ArrowSchema* schema, struct AdbcError* err);
AdbcStatusCode DatabricksConnectionGetTableTypes(struct AdbcConnection* cnxn,
                                                 struct ArrowArrayStream* out,
                                                 struct AdbcError* err);
AdbcStatusCode DatabricksConnectionInit(struct AdbcConnection* cnxn,
                                        struct AdbcDatabase* db, struct AdbcError* err);
AdbcStatusCode DatabricksConnectionNew(struct AdbcConnection* cnxn,
                                       struct AdbcError* err);
AdbcStatusCode DatabricksConnectionReadPartition(struct AdbcConnection* cnxn,
                                                 const uint8_t* serialized,
                                                 size_t serializedLen,
                                                 struct ArrowArrayStream* out,
                                                 struct AdbcError* err);
AdbcStatusCode DatabricksConnectionRelease(struct AdbcConnection* cnxn,
                                           struct AdbcError* err);
AdbcStatusCode DatabricksConnectionRollback(struct AdbcConnection* cnxn,
                                            struct AdbcError* err);
AdbcStatusCode DatabricksConnectionSetOption(struct AdbcConnection* cnxn, const char* key,
                                             const char* val, struct AdbcError* err);
AdbcStatusCode DatabricksConnectionSetOptionBytes(struct AdbcConnection*, const char*,
                                                  const uint8_t*, size_t,
                                                  struct AdbcError*);
AdbcStatusCode DatabricksConnectionSetOptionDouble(struct AdbcConnection*, const char*,
                                                   double, struct AdbcError*);
AdbcStatusCode DatabricksConnectionSetOptionInt(struct AdbcConnection*, const char*,
                                                int64_t, struct AdbcError*);

AdbcStatusCode DatabricksStatementBind(struct AdbcStatement* stmt,
                                       struct ArrowArray* values,
                                       struct ArrowSchema* schema, struct AdbcError* err);
AdbcStatusCode DatabricksStatementBindStream(struct AdbcStatement* stmt,
                                             struct ArrowArrayStream* stream,
                                             struct AdbcError* err);
AdbcStatusCode DatabricksStatementCancel(struct AdbcStatement*, struct AdbcError*);
AdbcStatusCode DatabricksStatementExecuteQuery(struct AdbcStatement* stmt,
                                               struct ArrowArrayStream* out,
                                               int64_t* affected, struct AdbcError* err);
AdbcStatusCode DatabricksStatementExecutePartitions(struct AdbcStatement* stmt,
                                                    struct ArrowSchema* schema,
                                                    struct AdbcPartitions* partitions,
                                                    int64_t* affected,
                                                    struct AdbcError* err);
AdbcStatusCode DatabricksStatementExecutePartitionsTrampoline(
    struct AdbcStatement* stmt, struct ArrowSchema* schema,
    struct AdbcPartitions* partitions, int64_t* affected, struct AdbcError* err);
AdbcStatusCode DatabricksStatementExecuteSchema(struct AdbcStatement*,
                                                struct ArrowSchema*, struct AdbcError*);
AdbcStatusCode DatabricksStatementGetOption(struct AdbcStatement*, const char*, char*,
                                            size_t*, struct AdbcError*);
AdbcStatusCode DatabricksStatementGetOptionBytes(struct AdbcStatement*, const char*,
                                                 uint8_t*, size_t*, struct AdbcError*);
AdbcStatusCode DatabricksStatementGetOptionDouble(struct AdbcStatement*, const char*,
                                                  double*, struct AdbcError*);
AdbcStatusCode DatabricksStatementGetOptionInt(struct AdbcStatement*, const char*,
                                               int64_t*, struct AdbcError*);
AdbcStatusCode DatabricksStatementGetParameterSchema(struct AdbcStatement* stmt,
                                                     struct ArrowSchema* schema,
                                                     struct AdbcError* err);
AdbcStatusCode DatabricksStatementNew(struct AdbcConnection* cnxn,
                                      struct AdbcStatement* stmt, struct AdbcError* err);
AdbcStatusCode DatabricksStatementPrepare(struct AdbcStatement* stmt,
                                          struct AdbcError* err);
AdbcStatusCode DatabricksStatementRelease(struct AdbcStatement* stmt,
                                          struct AdbcError* err);
AdbcStatusCode DatabricksStatementSetOption(struct AdbcStatement* stmt, const char* key,
                                            const char* value, struct AdbcError* err);
AdbcStatusCode DatabricksStatementSetOptionBytes(struct AdbcStatement*, const char*,
                                                 const uint8_t*, size_t,
                                                 struct AdbcError*);
AdbcStatusCode DatabricksStatementSetOptionDouble(struct AdbcStatement*, const char*,
                                                  double, struct AdbcError*);
AdbcStatusCode DatabricksStatementSetOptionInt(struct AdbcStatement*, const char*,
                                               int64_t, struct AdbcError*);
AdbcStatusCode DatabricksStatementSetSqlQuery(struct AdbcStatement* stmt,
                                              const char* query, struct AdbcError* err);
AdbcStatusCode DatabricksStatementSetSubstraitPlan(struct AdbcStatement* stmt,
                                                   const uint8_t* plan, size_t length,
                                                   struct AdbcError* err);

AdbcStatusCode AdbcDriverDatabricksInit(int version, void* rawDriver,
                                        struct AdbcError* err);

static inline void DatabrickserrRelease(struct AdbcError* error) {
  if (error->release) {
    error->release(error);
    error->release = NULL;
  }
}

void Databricks_release_error(struct AdbcError* error);

struct DatabricksError {
  char* message;
  char** keys;
  uint8_t** values;
  size_t* lengths;
  int count;
};

void DatabricksReleaseErrWithDetails(struct AdbcError* error);

int DatabricksErrorGetDetailCount(const struct AdbcError* error);
struct AdbcErrorDetail DatabricksErrorGetDetail(const struct AdbcError* error, int index);

int DatabricksArrayStreamGetSchemaTrampoline(struct ArrowArrayStream* stream,
                                             struct ArrowSchema* out);
int DatabricksArrayStreamGetNextTrampoline(struct ArrowArrayStream* stream,
                                           struct ArrowArray* out);
