/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.email.parser;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.gfac.core.monitor.EmailParser;
import org.apache.airavata.gfac.core.monitor.JobStatusResult;
import org.apache.airavata.model.status.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSFEmailParser
implements EmailParser {
    private static final Logger log = LoggerFactory.getLogger(LSFEmailParser.class);
    private static final String REGEX = "[a-zA-Z]+\\s+(?<jobId>[\\d]+):\\s+<(?<jobName>[a-zA-Z0-9]+)>\\s+(?<status>[a-zA-Z]+)";
    public static final String STARTED = "started";
    public static final String COMPLETE = "Done";
    public static final String FAILED = "Exited";

    public JobStatusResult parseEmail(Message message) throws MessagingException, AiravataException {
        JobStatusResult jobStatusResult = new JobStatusResult();
        this.parseContent(message, jobStatusResult);
        return jobStatusResult;
    }

    private void parseContent(Message message, JobStatusResult jobStatusResult) throws MessagingException, AiravataException {
        String subject = message.getSubject();
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(subject);
        try {
            if (matcher.find()) {
                jobStatusResult.setJobId(matcher.group("jobId"));
                jobStatusResult.setJobName(matcher.group("jobName"));
                String content = (String)message.getContent();
                jobStatusResult.setState(this.getJobState(matcher.group("status"), content));
            } else {
                log.error("[EJM]: No matched found for subject => \n" + subject);
            }
        }
        catch (IOException e) {
            throw new AiravataException("[EJM]: Error while reading content of the email message");
        }
    }

    private JobState getJobState(String status, String content) {
        switch (status) {
            case "started": {
                return JobState.ACTIVE;
            }
            case "Done": {
                return JobState.COMPLETE;
            }
            case "Exited": {
                return JobState.FAILED;
            }
        }
        return JobState.UNKNOWN;
    }
}

