/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.email.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.gfac.core.monitor.EmailParser;
import org.apache.airavata.gfac.core.monitor.JobStatusResult;
import org.apache.airavata.gfac.monitor.email.parser.SLURMEmailParser;
import org.apache.airavata.model.status.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiravataCustomMailParser
implements EmailParser {
    private static final Logger log = LoggerFactory.getLogger(SLURMEmailParser.class);
    private static final String REGEX = "[a-zA-Z]*_[a-z]*=(?<jobId>\\d*)[ ]*[a-zA-Z]*=(?<jobName>[a-zA-Z0-9-]*)[ ]*[a-zA-Z]*=(?<status>[a-zA-Z]*).*";
    public static final String COMPLETED = "COMPLETED";
    private static final Pattern pattern = Pattern.compile("[a-zA-Z]*_[a-z]*=(?<jobId>\\d*)[ ]*[a-zA-Z]*=(?<jobName>[a-zA-Z0-9-]*)[ ]*[a-zA-Z]*=(?<status>[a-zA-Z]*).*");

    public JobStatusResult parseEmail(Message message) throws MessagingException, AiravataException {
        JobStatusResult jobStatusResult = new JobStatusResult();
        this.parseSubject(message.getSubject(), jobStatusResult);
        return jobStatusResult;
    }

    private void parseSubject(String subject, JobStatusResult jobStatusResult) throws MessagingException {
        Matcher matcher = pattern.matcher(subject);
        if (matcher.find()) {
            jobStatusResult.setJobId(matcher.group("jobId"));
            jobStatusResult.setJobName(matcher.group("jobName"));
            jobStatusResult.setState(this.getJobState(matcher.group("status")));
            jobStatusResult.setAuthoritative(false);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {}
        } else {
            log.error("[EJM]: No matched found for subject -> " + subject);
        }
    }

    private JobState getJobState(String state) {
        switch (state.trim()) {
            case "COMPLETED": {
                return JobState.COMPLETE;
            }
        }
        log.error("[EJM]: Job State " + state + " isn't handle by Airavata custom parser");
        return JobState.UNKNOWN;
    }
}

