/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ExtendedSession;
import com.jcraft.jsch.GSSContext;
import com.jcraft.jsch.GSSContextX509;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.JSchPartialAuthException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserAuth;
import com.jcraft.jsch.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.airavata.gfac.core.authentication.GSIAuthenticationInfo;
import org.globus.gsi.gssapi.GSSConstants;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class UserAuthGSSAPIWithMICGSSCredentials
extends UserAuth {
    private static final int SSH_MSG_USERAUTH_GSSAPI_RESPONSE = 60;
    private static final int SSH_MSG_USERAUTH_GSSAPI_TOKEN = 61;
    private static final int SSH_MSG_USERAUTH_GSSAPI_ERROR = 64;
    private static final int SSH_MSG_USERAUTH_GSSAPI_ERRTOK = 65;
    private static final int SSH_MSG_USERAUTH_GSSAPI_MIC = 66;
    private static String[] supportedMethods = new String[]{"gssapi-with-mic.x509", "gssapi-with-mic.krb5"};
    private static byte[][] supportedOids;

    public boolean start(Session session) throws Exception {
        String method;
        Packet packet = session.packet;
        Buffer buf = session.buf;
        String username = session.username;
        byte[] _username = Util.str2byte((String)username);
        ArrayList methods = new ArrayList();
        boolean found = false;
        for (int i = 0; i < supportedOids.length; ++i) {
            found = found || this.checkForSupportedOIDs(methods, packet, buf, i, _username, session);
        }
        if (!found) {
            return false;
        }
        boolean success = false;
        Iterator it = methods.iterator();
        while (it.hasNext() && !(success = this.tryMethod(username, _username, method = (String)it.next(), session, packet, buf))) {
        }
        return success;
    }

    private boolean checkForSupportedOIDs(List methods, Packet packet, Buffer buf, int index, byte[] _username, Session session) throws Exception {
        packet.reset();
        buf.putByte((byte)50);
        buf.putString(_username);
        buf.putString("ssh-connection".getBytes());
        buf.putString("gssapi-with-mic".getBytes());
        buf.putInt(1);
        buf.putString(supportedOids[index]);
        session.write(packet);
        while (true) {
            buf = session.read(buf);
            if (buf.buffer[5] == 51) {
                return false;
            }
            if (buf.buffer[5] == 60) {
                buf.getInt();
                buf.getByte();
                buf.getByte();
                byte[] message = buf.getString();
                if (Util.array_equals((byte[])message, (byte[])supportedOids[index])) {
                    methods.add(supportedMethods[index]);
                    return true;
                }
            }
            if (buf.buffer[5] != 53) break;
            buf.getInt();
            buf.getByte();
            buf.getByte();
            byte[] _message = buf.getString();
            buf.getString();
            String message = Util.byte2str((byte[])_message);
            if (this.userinfo == null) continue;
            this.userinfo.showMessage(message);
        }
        return false;
    }

    private boolean tryMethod(String username, byte[] _username, String method, Session session, Packet packet, Buffer buf) throws Exception {
        GSSContext context = null;
        try {
            Class<?> c = Class.forName(session.getConfig(method));
            context = (GSSContext)c.newInstance();
        }
        catch (Exception e) {
            return false;
        }
        if (session instanceof ExtendedSession) {
            GSIAuthenticationInfo authenticationInfo = ((ExtendedSession)session).getAuthenticationInfo();
            if (context instanceof GSSContextX509) {
                ((GSSContextX509)context).setCredential(authenticationInfo.getCredentials());
            }
        }
        try {
            context.create(username, session.host);
        }
        catch (JSchException e) {
            return false;
        }
        byte[] token = new byte[]{};
        while (!context.isEstablished()) {
            try {
                token = context.init(token, 0, token.length);
            }
            catch (JSchException e) {
                return false;
            }
            if (token != null) {
                packet.reset();
                buf.putByte((byte)61);
                buf.putString(token);
                session.write(packet);
            }
            if (context.isEstablished()) continue;
            buf = session.read(buf);
            if (buf.buffer[5] == 64) {
                buf = session.read(buf);
            } else if (buf.buffer[5] == 65) {
                buf = session.read(buf);
            }
            if (buf.buffer[5] == 51) {
                return false;
            }
            buf.getInt();
            buf.getByte();
            buf.getByte();
            token = buf.getString();
        }
        Buffer mbuf = new Buffer();
        mbuf.putString(session.getSessionId());
        mbuf.putByte((byte)50);
        mbuf.putString(_username);
        mbuf.putString("ssh-connection".getBytes());
        mbuf.putString("gssapi-with-mic".getBytes());
        byte[] mic = context.getMIC(mbuf.buffer, 0, mbuf.getLength());
        if (mic == null) {
            return false;
        }
        packet.reset();
        buf.putByte((byte)66);
        buf.putString(mic);
        session.write(packet);
        context.dispose();
        buf = session.read(buf);
        if (buf.buffer[5] == 52) {
            return true;
        }
        if (buf.buffer[5] == 51) {
            buf.getInt();
            buf.getByte();
            buf.getByte();
            byte[] foo = buf.getString();
            int partial_success = buf.getByte();
            if (partial_success != 0) {
                throw new JSchPartialAuthException(new String(foo));
            }
        }
        return false;
    }

    static {
        try {
            supportedOids = new byte[][]{GSSConstants.MECH_OID.getDER(), new Oid("1.2.840.113554.1.2.2").getDER()};
        }
        catch (GSSException gsse) {
            gsse.printStackTrace();
        }
    }
}

