/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MultiMap;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.jmx.AtomicLongMBean;
import com.hazelcast.jmx.CountDownLatchMBean;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.InstanceMBean;
import com.hazelcast.jmx.ListMBean;
import com.hazelcast.jmx.LockMBean;
import com.hazelcast.jmx.MapMBean;
import com.hazelcast.jmx.MultiMapMBean;
import com.hazelcast.jmx.QueueMBean;
import com.hazelcast.jmx.SemaphoreMBean;
import com.hazelcast.jmx.SetMBean;
import com.hazelcast.jmx.TopicMBean;
import com.hazelcast.logging.ILogger;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ManagementService
implements DistributedObjectListener {
    public static final String DOMAIN = "com.hazelcast";
    final HazelcastInstanceImpl instance;
    private final boolean enabled;
    private final ILogger logger;
    private final String registrationId;

    public ManagementService(HazelcastInstanceImpl instance) {
        this.instance = instance;
        this.logger = instance.getLoggingService().getLogger(this.getClass());
        this.enabled = instance.node.groupProperties.ENABLE_JMX.getBoolean();
        if (this.enabled) {
            this.logger.info("Hazelcast JMX agent enabled.");
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                InstanceMBean instanceMBean = new InstanceMBean(instance, this);
                mbs.registerMBean(instanceMBean, instanceMBean.objectName);
            }
            catch (Exception e) {
                this.logger.warning("Unable to start JMX service", e);
            }
            this.registrationId = instance.addDistributedObjectListener(this);
            for (DistributedObject distributedObject : instance.getDistributedObjects()) {
                this.registerDistributedObject(distributedObject);
            }
        } else {
            this.registrationId = null;
        }
    }

    public void destroy() {
        if (!this.enabled) {
            return;
        }
        this.instance.removeDistributedObjectListener(this.registrationId);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> entries = mbs.queryNames(new ObjectName("com.hazelcast:instance=" + this.quote(this.instance.getName()) + ",*"), null);
            for (ObjectName name : entries) {
                if (!mbs.isRegistered(name)) continue;
                mbs.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            this.logger.warning("Error while un-registering MBeans", e);
        }
    }

    public static void shutdownAll() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> entries = mbs.queryNames(new ObjectName("com.hazelcast:*"), null);
            for (ObjectName name : entries) {
                if (!mbs.isRegistered(name)) continue;
                mbs.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ManagementService.class.getName()).log(Level.WARNING, "Error while shutting down all jmx services...", e);
        }
    }

    @Override
    public void distributedObjectCreated(DistributedObjectEvent event) {
        this.registerDistributedObject(event.getDistributedObject());
    }

    @Override
    public void distributedObjectDestroyed(DistributedObjectEvent event) {
        this.unregisterDistributedObject(event.getDistributedObject());
    }

    private void registerDistributedObject(DistributedObject distributedObject) {
        MBeanServer mbs;
        HazelcastMBean bean = this.createHazelcastBean(distributedObject);
        if (bean != null && !(mbs = ManagementFactory.getPlatformMBeanServer()).isRegistered(bean.objectName)) {
            try {
                mbs.registerMBean(bean, bean.objectName);
            }
            catch (Exception e) {
                this.logger.warning("Error while registering " + bean.objectName, e);
            }
        }
    }

    private void unregisterDistributedObject(DistributedObject distributedObject) {
        String objectType = this.getObjectType(distributedObject);
        if (objectType != null) {
            ObjectName objectName = this.createObjectName(objectType, distributedObject.getName());
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (mbs.isRegistered(objectName)) {
                try {
                    mbs.unregisterMBean(objectName);
                }
                catch (Exception e) {
                    this.logger.warning("Error while un-registering " + objectName, e);
                }
            }
        }
    }

    private HazelcastMBean createHazelcastBean(DistributedObject distributedObject) {
        try {
            if (distributedObject instanceof IList) {
                return new ListMBean((IList)distributedObject, this);
            }
            if (distributedObject instanceof IAtomicLong) {
                return new AtomicLongMBean((IAtomicLong)distributedObject, this);
            }
            if (distributedObject instanceof ICountDownLatch) {
                return new CountDownLatchMBean((ICountDownLatch)distributedObject, this);
            }
            if (distributedObject instanceof ILock) {
                return new LockMBean((ILock)distributedObject, this);
            }
            if (distributedObject instanceof IMap) {
                return new MapMBean((IMap)distributedObject, this);
            }
            if (distributedObject instanceof MultiMap) {
                return new MultiMapMBean((MultiMap)distributedObject, this);
            }
            if (distributedObject instanceof IQueue) {
                return new QueueMBean((IQueue)distributedObject, this);
            }
            if (distributedObject instanceof ISemaphore) {
                return new SemaphoreMBean((ISemaphore)distributedObject, this);
            }
            if (distributedObject instanceof ISet) {
                return new SetMBean((ISet)distributedObject, this);
            }
            if (distributedObject instanceof ITopic) {
                return new TopicMBean((ITopic)distributedObject, this);
            }
        }
        catch (HazelcastInstanceNotActiveException hazelcastInstanceNotActiveException) {
            // empty catch block
        }
        return null;
    }

    private String getObjectType(DistributedObject distributedObject) {
        if (distributedObject instanceof IList) {
            return "List";
        }
        if (distributedObject instanceof IAtomicLong) {
            return "AtomicLong";
        }
        if (distributedObject instanceof ICountDownLatch) {
            return "CountDownLatch";
        }
        if (distributedObject instanceof ILock) {
            return "Lock";
        }
        if (distributedObject instanceof IMap) {
            return "Map";
        }
        if (distributedObject instanceof MultiMap) {
            return "MultiMap";
        }
        if (distributedObject instanceof IQueue) {
            return "Queue";
        }
        if (distributedObject instanceof ISemaphore) {
            return "Semaphore";
        }
        if (distributedObject instanceof ISet) {
            return "ISet";
        }
        if (distributedObject instanceof ITopic) {
            return "ITopic";
        }
        return null;
    }

    protected ObjectName createObjectName(String type, String name) {
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        properties.put("instance", this.quote(this.instance.getName()));
        if (type != null) {
            properties.put("type", this.quote(type));
        }
        if (name != null) {
            properties.put("name", this.quote(name));
        }
        try {
            return new ObjectName(DOMAIN, properties);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException();
        }
    }

    private String quote(String text) {
        return Pattern.compile("[:\",=*?]").matcher(text).find() ? ObjectName.quote(text) : text;
    }
}

