/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.URIResolver;
import org.apache.axis2.util.XSLTTemplateProcessor;
import org.apache.axis2.wsdl.codegen.writer.FileWriter;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.w3c.dom.Document;

public class AntBuildWriter
extends FileWriter {
    private String databindingFramework = ConfigPropertyFileLoader.getDefaultDBFrameworkName();

    public AntBuildWriter(String outputFileLocation) {
        this.outputFileLocation = new File(outputFileLocation);
    }

    public AntBuildWriter(File outputFileLocation, String language) {
        this.outputFileLocation = outputFileLocation;
        this.language = language;
    }

    public void setDatabindingFramework(String databindingFramework) {
        this.databindingFramework = databindingFramework;
    }

    public void createOutFile(String packageName, String fileName) throws Exception {
        this.outputFile = org.apache.axis2.util.FileWriter.createClassFile(this.outputFileLocation, "", "build", ".xml");
        this.fileExists = this.outputFile.exists();
        if (!this.fileExists) {
            this.stream = new FileOutputStream(this.outputFile);
        }
    }

    protected String findTemplate(Map languageSpecificPropertyMap) {
        String ownClazzName = this.getClass().getName();
        String templateName = null;
        Iterator keys = languageSpecificPropertyMap.keySet().iterator();
        while (keys.hasNext()) {
            String propertyValue;
            String key = keys.next().toString();
            if (!key.endsWith(".template") || !(propertyValue = languageSpecificPropertyMap.get(key).toString()).startsWith(ownClazzName) || key.indexOf(this.databindingFramework) == -1) continue;
            templateName = propertyValue.substring(propertyValue.indexOf(",") + 1);
            break;
        }
        return templateName;
    }

    public void parse(Document doc, URIResolver resolver) throws Exception {
        if (!this.fileExists) {
            XSLTTemplateProcessor.parse(this.stream, doc, this.xsltStream, resolver);
            this.stream.flush();
            this.stream.close();
        }
    }
}

